/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.common;

import android.content.Context;
import android.util.Log;
import backtraceio.library.common.PermissionHelper;
import backtraceio.library.logger.BacktraceLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;

public class FileHelper {
    private static final String LOG_TAG = FileHelper.class.getSimpleName();

    static String getFileNameFromPath(String absolutePath) {
        return absolutePath.substring(absolutePath.lastIndexOf("/") + 1);
    }

    public static ArrayList<String> filterOutFiles(Context context, List<String> paths) {
        ArrayList<String> result = new ArrayList<String>();
        if (paths == null) {
            return result;
        }
        paths = new ArrayList<String>(new HashSet<String>(paths));
        for (String path : paths) {
            if (FileHelper.isFilePathInvalid(path)) {
                Log.e((String)LOG_TAG, (String)String.format("Path for file %s is invalid", path));
                continue;
            }
            if (!FileHelper.isPathToInternalStorage(context, path)) {
                Log.d((String)LOG_TAG, (String)String.format("Passed path is path to external storage %s", path));
                if (!PermissionHelper.isPermissionForReadExternalStorageGranted(context)) {
                    Log.e((String)LOG_TAG, (String)"Permission READ_EXTERNAL_STORAGE is not granted.");
                    continue;
                }
            }
            result.add(path);
        }
        return result;
    }

    public static String getFileExtension(File file) {
        String name = file.getName().substring(Math.max(file.getName().lastIndexOf(47), file.getName().lastIndexOf(92)) < 0 ? 0 : Math.max(file.getName().lastIndexOf(47), file.getName().lastIndexOf(92)));
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf + 1);
    }

    private static boolean isFilePathInvalid(String filePath) {
        return filePath == null || filePath.isEmpty() || !FileHelper.isFileExists(filePath);
    }

    public static boolean isFileExists(String absoluteFilePath) {
        return new File(absoluteFilePath).exists();
    }

    private static boolean isPathToInternalStorage(Context context, String path) {
        if (context == null || path == null) {
            return false;
        }
        String dataDir = context.getApplicationInfo().dataDir;
        String cacheDir = context.getCacheDir().getAbsolutePath();
        String filesDir = context.getFilesDir().getPath();
        BacktraceLogger.d(LOG_TAG, String.format("Passed path %s, Internal paths %s, %s, %s", path, dataDir, cacheDir, filesDir));
        return path.startsWith(dataDir) || path.startsWith(cacheDir) || path.startsWith(filesDir);
    }

    public static String readFile(File file) {
        try {
            Scanner scanner = new Scanner(file);
            StringBuilder sb = new StringBuilder();
            while (scanner.hasNext()) {
                sb.append(scanner.nextLine());
            }
            scanner.close();
            return sb.toString();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage());
            return null;
        }
    }
}

