/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.breadcrumbs;

import backtraceio.library.breadcrumbs.BacktraceQueueFileHelper;
import backtraceio.library.enums.BacktraceBreadcrumbLevel;
import backtraceio.library.enums.BacktraceBreadcrumbType;
import backtraceio.library.logger.BacktraceLogger;
import java.io.IOException;
import java.util.Map;
import org.json.JSONObject;

public class BacktraceBreadcrumbsLogManager {
    private final String LOG_TAG = BacktraceBreadcrumbsLogManager.class.getSimpleName();
    private long breadcrumbId = System.currentTimeMillis();
    private final BacktraceQueueFileHelper backtraceQueueFileHelper;
    private final int maxMessageSizeBytes = 1024;
    private final int maxAttributeSizeBytes = 1024;

    public BacktraceBreadcrumbsLogManager(String breadcrumbLogPath, int maxQueueFileSizeBytes) throws IOException, NoSuchMethodException {
        this.backtraceQueueFileHelper = new BacktraceQueueFileHelper(breadcrumbLogPath, maxQueueFileSizeBytes);
    }

    public boolean addBreadcrumb(String message, Map<String, Object> attributes, BacktraceBreadcrumbType type, BacktraceBreadcrumbLevel level) {
        long time = System.currentTimeMillis();
        message = message.substring(0, Math.min(message.length(), 1024));
        JSONObject breadcrumb = new JSONObject();
        try {
            breadcrumb.put("timestamp", time);
            breadcrumb.put("id", this.breadcrumbId++);
            breadcrumb.put("level", (Object)level.toString());
            breadcrumb.put("type", (Object)type.toString());
            breadcrumb.put("message", (Object)message);
            if (attributes != null) {
                JSONObject attributesJson = new JSONObject();
                int currentAttributeSize = 0;
                for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                    if ((currentAttributeSize += entry.getKey().length() + entry.getValue().toString().length()) >= 1024) continue;
                    attributesJson.put(entry.getKey(), entry.getValue());
                }
                if (attributesJson.length() > 0) {
                    breadcrumb.put("attributes", (Object)attributesJson);
                }
            }
        }
        catch (Exception ex) {
            BacktraceLogger.e(this.LOG_TAG, "Could not create the breadcrumb JSON");
            return false;
        }
        StringBuilder breadcrumbSerializedString = new StringBuilder("\n");
        breadcrumbSerializedString.append(breadcrumb.toString().replace("\\n", ""));
        breadcrumbSerializedString.append("\n");
        return this.backtraceQueueFileHelper.add(breadcrumbSerializedString.toString().getBytes());
    }

    public boolean clear() {
        boolean success = this.backtraceQueueFileHelper.clear();
        if (success) {
            this.breadcrumbId = 0L;
        }
        return success;
    }

    public void setCurrentBreadcrumbId(long breadcrumbId) {
        this.breadcrumbId = breadcrumbId;
    }

    public long getCurrentBreadcrumbId() {
        return this.breadcrumbId;
    }
}

