/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library;

import android.net.Uri;

public class BacktraceCredentials {
    private final String format = "json";
    private String endpointUrl;
    private String submissionToken;
    private Uri backtraceHostUri;

    public BacktraceCredentials(String endpointUrl, String submissionToken) {
        this.endpointUrl = endpointUrl;
        this.submissionToken = submissionToken;
    }

    public BacktraceCredentials(String backtraceHostUri) {
        this(Uri.parse((String)backtraceHostUri));
    }

    public BacktraceCredentials(Uri backtraceHostUri) {
        this.backtraceHostUri = backtraceHostUri;
    }

    private String getEndpointUrl() {
        return this.endpointUrl;
    }

    private Uri getBacktraceHostUri() {
        return this.backtraceHostUri;
    }

    private Uri getServerUrl() {
        String serverUrl = this.getEndpointUrl();
        String prefix = serverUrl.endsWith("/") ? "" : "/";
        String url = String.format("%s%spost?format=%s&token=%s", serverUrl, prefix, this.format, this.getSubmissionToken());
        return Uri.parse((String)url);
    }

    public Uri getSubmissionUrl() {
        Uri backtraceUri = this.getBacktraceHostUri();
        if (backtraceUri != null) {
            return backtraceUri;
        }
        return this.getServerUrl();
    }

    public Uri getMinidumpSubmissionUrl() {
        Uri backtraceJsonUri = this.getSubmissionUrl();
        String jsonUrl = backtraceJsonUri.toString();
        if (jsonUrl.contains("format=json")) {
            jsonUrl = jsonUrl.replace("format=json", "format=minidump");
        } else if (jsonUrl.contains("/json")) {
            jsonUrl = jsonUrl.replace("/json", "/minidump");
        } else {
            return null;
        }
        return Uri.parse((String)jsonUrl);
    }

    public String getUniverseName() {
        String submissionUrl = this.getSubmissionUrl().toString();
        String backtraceSubmitUrl = "https://submit.backtrace.io/";
        if (submissionUrl.startsWith("https://submit.backtrace.io/")) {
            int universeIndexStart = "https://submit.backtrace.io/".length();
            int universeIndexEnd = submissionUrl.indexOf(47, universeIndexStart);
            if (universeIndexEnd == -1) {
                throw new IllegalArgumentException("Invalid Backtrace URL");
            }
            return submissionUrl.substring(universeIndexStart, universeIndexEnd);
        }
        String backtraceDomain = "backtrace.io";
        if (submissionUrl.indexOf("backtrace.io") == -1) {
            throw new IllegalArgumentException("Invalid Backtrace URL");
        }
        Uri uri = Uri.parse((String)submissionUrl);
        return uri.getHost().substring(0, uri.getHost().indexOf("."));
    }

    public String getSubmissionToken() {
        if (this.submissionToken != null) {
            return this.submissionToken;
        }
        int tokenLength = 64;
        String tokenQueryParam = "token=";
        String submissionUrl = this.getSubmissionUrl().toString();
        int tokenEndIndex = submissionUrl.lastIndexOf("/");
        if (submissionUrl.contains("submit.backtrace.io")) {
            if (tokenEndIndex - 64 < 0) {
                return null;
            }
            return submissionUrl.substring(tokenEndIndex - 64, tokenEndIndex);
        }
        int tokenQueryParamStartIndex = submissionUrl.indexOf("token=");
        if (tokenQueryParamStartIndex == -1) {
            return null;
        }
        int tokenParamStartIndex = tokenQueryParamStartIndex + "token=".length();
        return submissionUrl.substring(tokenParamStartIndex, tokenParamStartIndex + 64);
    }
}

