/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.services;

import backtraceio.library.common.BacktraceSerializeHelper;
import backtraceio.library.common.BacktraceStringHelper;
import backtraceio.library.common.MultiFormRequestHelper;
import backtraceio.library.common.RequestHelper;
import backtraceio.library.events.OnServerErrorEventListener;
import backtraceio.library.http.HttpHelper;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.BacktraceResult;
import backtraceio.library.models.json.BacktraceReport;
import backtraceio.library.models.metrics.EventsPayload;
import backtraceio.library.models.metrics.EventsResult;
import backtraceio.library.models.types.BacktraceResultStatus;
import backtraceio.library.models.types.HttpException;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

class BacktraceReportSender {
    private static final String LOG_TAG = BacktraceReportSender.class.getSimpleName();
    private static final int CHUNK_SIZE = 131072;

    BacktraceReportSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BacktraceResult sendReport(String serverUrl, String json, List<String> attachments, BacktraceReport report, OnServerErrorEventListener errorCallback) {
        BacktraceResult result;
        block14: {
            HttpURLConnection urlConnection = null;
            try {
                URL url = new URL(serverUrl);
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("POST");
                urlConnection.setUseCaches(false);
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                urlConnection.setChunkedStreamingMode(131072);
                urlConnection.setRequestProperty("Connection", "Keep-Alive");
                urlConnection.setRequestProperty("Cache-Control", "no-cache");
                urlConnection.setRequestProperty("Content-Type", MultiFormRequestHelper.getContentType());
                BacktraceLogger.d(LOG_TAG, "HttpURLConnection successfully initialized");
                DataOutputStream request = new DataOutputStream(urlConnection.getOutputStream());
                MultiFormRequestHelper.addJson(request, json);
                MultiFormRequestHelper.addFiles(request, attachments);
                MultiFormRequestHelper.addEndOfRequest(request);
                request.flush();
                request.close();
                int statusCode = urlConnection.getResponseCode();
                BacktraceLogger.d(LOG_TAG, "Received response status from Backtrace API for HTTP request is: " + statusCode);
                if (statusCode == 200) {
                    result = BacktraceSerializeHelper.fromJson(HttpHelper.getResponseMessage(urlConnection), BacktraceResult.class);
                    result.setBacktraceReport(report);
                    break block14;
                }
                String message = HttpHelper.getResponseMessage(urlConnection);
                message = BacktraceStringHelper.isNullOrEmpty(message) ? urlConnection.getResponseMessage() : message;
                throw new HttpException(statusCode, String.format("%s: %s", statusCode, message));
            }
            catch (Exception e) {
                if (errorCallback != null) {
                    BacktraceLogger.d(LOG_TAG, "Custom handler on server error");
                    errorCallback.onEvent(e);
                }
                BacktraceLogger.e(LOG_TAG, "Sending HTTP request failed to Backtrace API", e);
                result = BacktraceResult.OnError(report, e);
            }
            finally {
                if (urlConnection != null) {
                    try {
                        urlConnection.disconnect();
                        BacktraceLogger.d(LOG_TAG, "Disconnecting HttpUrlConnection successful");
                    }
                    catch (Exception e) {
                        BacktraceLogger.e(LOG_TAG, "Disconnecting HttpUrlConnection failed", e);
                        result = BacktraceResult.OnError(report, e);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventsResult sendEvents(String serverUrl, String json, EventsPayload payload, OnServerErrorEventListener errorCallback) {
        EventsResult result;
        block14: {
            HttpURLConnection urlConnection = null;
            int statusCode = -1;
            try {
                URL url = new URL(serverUrl);
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("POST");
                urlConnection.setUseCaches(false);
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                urlConnection.setRequestProperty("Connection", "Keep-Alive");
                urlConnection.setRequestProperty("Content-Type", RequestHelper.getContentType());
                BacktraceLogger.d(LOG_TAG, "HttpURLConnection successfully initialized");
                DataOutputStream request = new DataOutputStream(urlConnection.getOutputStream());
                RequestHelper.addJson(request, json);
                RequestHelper.addEndOfRequest(request);
                request.flush();
                request.close();
                statusCode = urlConnection.getResponseCode();
                BacktraceLogger.d(LOG_TAG, "Received response status from Backtrace API for HTTP request is: " + statusCode);
                if (statusCode == 200) {
                    result = new EventsResult(payload, urlConnection.getResponseMessage(), BacktraceResultStatus.Ok, statusCode);
                    break block14;
                }
                String message = HttpHelper.getResponseMessage(urlConnection);
                message = BacktraceStringHelper.isNullOrEmpty(message) ? urlConnection.getResponseMessage() : message;
                throw new HttpException(statusCode, String.format("%s: %s", statusCode, message));
            }
            catch (Exception e) {
                if (errorCallback != null) {
                    BacktraceLogger.d(LOG_TAG, "Custom handler on server error");
                    errorCallback.onEvent(e);
                }
                BacktraceLogger.e(LOG_TAG, "Sending HTTP request failed to Backtrace API", e);
                BacktraceLogger.e(LOG_TAG, "Failed HTTP request URL " + serverUrl);
                result = EventsResult.OnError(payload, e, statusCode);
            }
            finally {
                if (urlConnection != null) {
                    try {
                        urlConnection.disconnect();
                        BacktraceLogger.d(LOG_TAG, "Disconnecting HttpUrlConnection successful");
                    }
                    catch (Exception e) {
                        BacktraceLogger.e(LOG_TAG, "Disconnecting HttpUrlConnection failed", e);
                        result = EventsResult.OnError(payload, e, statusCode);
                    }
                }
            }
        }
        return result;
    }
}

