/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.services;

import android.content.Context;
import backtraceio.library.BacktraceCredentials;
import backtraceio.library.common.BacktraceStringHelper;
import backtraceio.library.common.BacktraceTimeHelper;
import backtraceio.library.events.EventsOnServerResponseEventListener;
import backtraceio.library.events.EventsRequestHandler;
import backtraceio.library.events.RequestHandler;
import backtraceio.library.interfaces.Api;
import backtraceio.library.interfaces.Metrics;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.BacktraceMetricsSettings;
import backtraceio.library.models.json.BacktraceAttributes;
import backtraceio.library.models.metrics.SummedEvent;
import backtraceio.library.models.metrics.UniqueEvent;
import backtraceio.library.services.SummedEventsHandler;
import backtraceio.library.services.UniqueEventsHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;

public final class BacktraceMetrics
implements Metrics {
    public static final int defaultTimeIntervalInMin = 30;
    public static final long defaultTimeIntervalMs = 1800000L;
    public static final int maxNumberOfAttempts = 3;
    public static final int defaultTimeBetweenRetriesMs = 10000;
    public static final int maxTimeBetweenRetriesMs = 300000;
    public static final String defaultBaseUrl = "https://events.backtrace.io/api";
    private static final transient String LOG_TAG = BacktraceMetrics.class.getSimpleName();
    public final String defaultUniqueEventName = "guid";
    private final String startupSummedEventName = "Application Launches";
    public UniqueEventsHandler uniqueEventsHandler;
    public SummedEventsHandler summedEventsHandler;
    protected Map<String, Object> customReportAttributes;
    protected Context context;
    protected BacktraceMetricsSettings settings = null;
    private String startupUniqueEventName = "guid";
    private int maximumNumberOfEvents = 350;
    private final RequestHandler requestHandler = null;
    private final Api backtraceApi;
    private final BacktraceCredentials credentials;

    public BacktraceMetrics(Context context, @NotNull Map<String, Object> customReportAttributes, Api backtraceApi, BacktraceCredentials credentials) {
        this.context = context;
        this.customReportAttributes = customReportAttributes;
        this.backtraceApi = backtraceApi;
        this.credentials = credentials;
    }

    @Override
    public void enable() {
        this.enable(new BacktraceMetricsSettings(this.credentials), "guid");
    }

    @Override
    public void enable(String defaultUniqueEventName) {
        this.enable(new BacktraceMetricsSettings(this.credentials, defaultUniqueEventName));
    }

    @Override
    public void enable(BacktraceMetricsSettings settings) {
        this.enable(settings, "guid");
    }

    @Override
    public void enable(BacktraceMetricsSettings settings, String uniqueEventName) {
        if (uniqueEventName == null || uniqueEventName.length() == 0) {
            throw new IllegalArgumentException("Unique event name must be defined!");
        }
        this.setStartupUniqueEventName(uniqueEventName);
        this.settings = settings;
        try {
            this.startMetricsEventHandlers(this.backtraceApi);
            this.sendStartupEvent();
            BacktraceLogger.d(LOG_TAG, "Metrics enabled");
        }
        catch (Exception e) {
            BacktraceLogger.e(LOG_TAG, "Could not enable metrics, exception " + e.getMessage());
        }
    }

    private void startMetricsEventHandlers(Api backtraceApi) {
        this.uniqueEventsHandler = backtraceApi.enableUniqueEvents(this);
        this.summedEventsHandler = backtraceApi.enableSummedEvents(this);
    }

    protected String getStartupUniqueEventName() {
        return this.startupUniqueEventName;
    }

    public void setStartupUniqueEventName(String startupUniqueEventName) {
        this.startupUniqueEventName = startupUniqueEventName;
    }

    public String getBaseUrl() {
        return this.settings.getBaseUrl();
    }

    @Override
    public void sendStartupEvent() {
        this.addUniqueEvent(this.startupUniqueEventName);
        this.addSummedEvent("Application Launches");
        this.uniqueEventsHandler.send();
        this.summedEventsHandler.send();
    }

    @Override
    public void send() {
        this.uniqueEventsHandler.send();
        this.summedEventsHandler.send();
    }

    @Override
    public boolean addUniqueEvent(String attributeName) {
        return this.addUniqueEvent(attributeName, null);
    }

    @Override
    public boolean addUniqueEvent(String attributeName, Map<String, Object> attributes) {
        if (!this.shouldProcessEvent(attributeName)) {
            BacktraceLogger.w(LOG_TAG, "Skipping report");
            return false;
        }
        Map<String, Object> localAttributes = this.createLocalAttributes(attributes);
        Object value = localAttributes.get(attributeName);
        if (!BacktraceStringHelper.isObjectNotNullOrNotEmptyString(value)) {
            BacktraceLogger.w(LOG_TAG, "Attribute name for Unique Event is not available in attribute scope");
            return false;
        }
        for (UniqueEvent uniqueEvent : this.uniqueEventsHandler.events) {
            if (!uniqueEvent.getName().equals(attributeName)) continue;
            BacktraceLogger.w(LOG_TAG, "Already defined unique event with this attribute name, skipping");
            return false;
        }
        UniqueEvent uniqueEvent = new UniqueEvent(attributeName, BacktraceTimeHelper.getTimestampSeconds(), localAttributes);
        this.uniqueEventsHandler.events.addLast(uniqueEvent);
        if (this.count() == this.maximumNumberOfEvents) {
            this.uniqueEventsHandler.send();
            this.summedEventsHandler.send();
        }
        return true;
    }

    @Override
    public void setMaximumNumberOfEvents(int maximumNumberOfEvents) {
        this.maximumNumberOfEvents = maximumNumberOfEvents;
        this.uniqueEventsHandler.setMaximumNumberOfEvents(maximumNumberOfEvents);
        this.summedEventsHandler.setMaximumNumberOfEvents(maximumNumberOfEvents);
    }

    @Override
    public int count() {
        return this.getUniqueEvents().size() + this.getSummedEvents().size();
    }

    @Override
    public boolean addSummedEvent(String metricGroupName) {
        return this.addSummedEvent(metricGroupName, null);
    }

    @Override
    public boolean addSummedEvent(String metricGroupName, Map<String, Object> attributes) {
        if (!this.shouldProcessEvent(metricGroupName)) {
            BacktraceLogger.w(LOG_TAG, "Skipping report");
            return false;
        }
        HashMap<String, Object> localAttributes = new HashMap<String, Object>();
        if (attributes != null) {
            localAttributes.putAll(attributes);
        }
        SummedEvent summedEvent = new SummedEvent(metricGroupName, BacktraceTimeHelper.getTimestampSeconds(), localAttributes);
        this.summedEventsHandler.events.addLast(summedEvent);
        if (this.count() == this.maximumNumberOfEvents) {
            this.uniqueEventsHandler.send();
            this.summedEventsHandler.send();
        }
        return true;
    }

    @Override
    public ConcurrentLinkedDeque<UniqueEvent> getUniqueEvents() {
        return this.uniqueEventsHandler.events;
    }

    @Override
    public ConcurrentLinkedDeque<SummedEvent> getSummedEvents() {
        return this.summedEventsHandler.events;
    }

    @Override
    public void setUniqueEventsRequestHandler(EventsRequestHandler eventsRequestHandler) {
        this.backtraceApi.setUniqueEventsRequestHandler(eventsRequestHandler);
    }

    @Override
    public void setSummedEventsRequestHandler(EventsRequestHandler eventsRequestHandler) {
        this.backtraceApi.setSummedEventsRequestHandler(eventsRequestHandler);
    }

    private boolean shouldProcessEvent(String name) {
        if (BacktraceStringHelper.isNullOrEmpty(name)) {
            BacktraceLogger.e(LOG_TAG, "Cannot process event, attribute name is null or empty");
            return false;
        }
        if (this.maximumNumberOfEvents > 0 && this.count() + 1 > this.maximumNumberOfEvents) {
            BacktraceLogger.e(LOG_TAG, "Cannot process event, reached maximum number of events: " + this.maximumNumberOfEvents + " events count: " + this.count());
            return false;
        }
        return true;
    }

    protected Map<String, Object> createLocalAttributes(Map<String, Object> attributes) {
        HashMap<String, Object> localAttributes = new HashMap<String, Object>();
        if (attributes != null) {
            localAttributes.putAll(attributes);
        }
        BacktraceAttributes backtraceAttributes = new BacktraceAttributes(this.context, null, this.customReportAttributes);
        localAttributes.putAll(backtraceAttributes.getAllAttributes());
        return localAttributes;
    }

    @Override
    public void setUniqueEventsOnServerResponse(EventsOnServerResponseEventListener callback) {
        this.backtraceApi.setUniqueEventsOnServerResponse(callback);
    }

    @Override
    public void setSummedEventsOnServerResponse(EventsOnServerResponseEventListener callback) {
        this.backtraceApi.setSummedEventsOnServerResponse(callback);
    }
}

