/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.services;

import backtraceio.library.BacktraceCredentials;
import backtraceio.library.events.EventsOnServerResponseEventListener;
import backtraceio.library.events.EventsRequestHandler;
import backtraceio.library.events.OnServerErrorEventListener;
import backtraceio.library.events.OnServerResponseEventListener;
import backtraceio.library.events.RequestHandler;
import backtraceio.library.interfaces.Api;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.BacktraceData;
import backtraceio.library.models.metrics.SummedEventsPayload;
import backtraceio.library.models.metrics.UniqueEventsPayload;
import backtraceio.library.services.BacktraceHandlerInputEvents;
import backtraceio.library.services.BacktraceHandlerInputReport;
import backtraceio.library.services.BacktraceHandlerThread;
import backtraceio.library.services.BacktraceMetrics;
import backtraceio.library.services.SummedEventsHandler;
import backtraceio.library.services.UniqueEventsHandler;

public class BacktraceApi
implements Api {
    private static final transient String LOG_TAG = BacktraceApi.class.getSimpleName();
    private final transient BacktraceHandlerThread threadSender;
    private final String reportSubmissionUrl;
    private OnServerErrorEventListener onServerError = null;
    private RequestHandler requestHandler = null;
    private EventsRequestHandler uniqueEventsRequestHandler = null;
    private EventsRequestHandler summedEventsRequestHandler = null;
    private EventsOnServerResponseEventListener uniqueEventsServerResponse = null;
    private EventsOnServerResponseEventListener summedEventsServerResponse = null;

    public BacktraceApi(BacktraceCredentials credentials) {
        if (credentials == null) {
            BacktraceLogger.e(LOG_TAG, "BacktraceCredentials parameter passed to BacktraceApi constructor is null");
            throw new IllegalArgumentException("BacktraceCredentials cannot be null");
        }
        this.reportSubmissionUrl = credentials.getSubmissionUrl().toString();
        this.threadSender = new BacktraceHandlerThread(BacktraceHandlerThread.class.getSimpleName(), this.reportSubmissionUrl);
    }

    @Override
    public void setUniqueEventsRequestHandler(EventsRequestHandler uniqueEventsRequestHandler) {
        this.uniqueEventsRequestHandler = uniqueEventsRequestHandler;
    }

    @Override
    public void setSummedEventsRequestHandler(EventsRequestHandler summedEventsRequestHandler) {
        this.summedEventsRequestHandler = summedEventsRequestHandler;
    }

    @Override
    public void setUniqueEventsOnServerResponse(EventsOnServerResponseEventListener callback) {
        this.uniqueEventsServerResponse = callback;
    }

    @Override
    public void setSummedEventsOnServerResponse(EventsOnServerResponseEventListener callback) {
        this.summedEventsServerResponse = callback;
    }

    @Override
    public void setOnServerError(OnServerErrorEventListener onServerError) {
        this.onServerError = onServerError;
    }

    @Override
    public void setRequestHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    @Override
    public UniqueEventsHandler enableUniqueEvents(BacktraceMetrics backtraceMetrics) {
        return this.threadSender.createUniqueEventsHandler(backtraceMetrics, this);
    }

    @Override
    public SummedEventsHandler enableSummedEvents(BacktraceMetrics backtraceMetrics) {
        return this.threadSender.createSummedEventsHandler(backtraceMetrics, this);
    }

    @Override
    public void send(BacktraceData data, OnServerResponseEventListener callback) {
        BacktraceHandlerInputReport input = new BacktraceHandlerInputReport(data, callback, this.onServerError, this.requestHandler);
        this.threadSender.sendReport(input);
    }

    @Override
    public void sendEventsPayload(UniqueEventsPayload payload) {
        BacktraceHandlerInputEvents input = new BacktraceHandlerInputEvents(payload, this.uniqueEventsServerResponse, this.onServerError, this.uniqueEventsRequestHandler);
        this.threadSender.sendUniqueEvents(input);
    }

    @Override
    public void sendEventsPayload(SummedEventsPayload payload) {
        BacktraceHandlerInputEvents input = new BacktraceHandlerInputEvents(payload, this.summedEventsServerResponse, this.onServerError, this.summedEventsRequestHandler);
        this.threadSender.sendSummedEvents(input);
    }
}

