/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models.metrics;

import backtraceio.library.models.metrics.Event;
import backtraceio.library.models.metrics.EventsMetadata;
import com.google.gson.annotations.SerializedName;
import java.util.concurrent.ConcurrentLinkedDeque;

public abstract class EventsPayload<T extends Event> {
    private static final transient String LOG_TAG = EventsPayload.class.getSimpleName();
    @SerializedName(value="application")
    private final String application;
    @SerializedName(value="appversion")
    private final String appVersion;
    public transient int numRetries = 0;
    @SerializedName(value="metadata")
    private final EventsMetadata eventsMetadata;

    public EventsPayload(String application, String appVersion) {
        this.application = application;
        this.appVersion = appVersion;
        this.eventsMetadata = new EventsMetadata(0);
    }

    public int getDroppedEvents() {
        return this.eventsMetadata.getDroppedEvents();
    }

    public void setDroppedEvents(int droppedEvents) {
        this.eventsMetadata.setDroppedEvents(droppedEvents);
    }

    public abstract ConcurrentLinkedDeque<T> getEvents();
}

