/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models.json;

import android.content.Context;
import backtraceio.library.common.BacktraceTimeHelper;
import backtraceio.library.models.BacktraceData;
import backtraceio.library.models.BacktraceStackFrame;
import backtraceio.library.models.BacktraceStackTrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BacktraceReport {
    public UUID uuid = UUID.randomUUID();
    public long timestamp = BacktraceTimeHelper.getTimestampSeconds();
    public Boolean exceptionTypeReport = false;
    public String classifier = "";
    public Map<String, Object> attributes;
    public String message;
    public Exception exception;
    public List<String> attachmentPaths;
    public ArrayList<BacktraceStackFrame> diagnosticStack;

    public BacktraceReport(String message) {
        this((Exception)null, null, null);
        this.message = message;
    }

    public BacktraceReport(String message, Map<String, Object> attributes) {
        this((Exception)null, attributes, null);
        this.message = message;
    }

    public BacktraceReport(String message, List<String> attachmentPaths) {
        this(message, null, attachmentPaths);
    }

    public BacktraceReport(String message, Map<String, Object> attributes, List<String> attachmentPaths) {
        this((Exception)null, attributes, attachmentPaths);
        this.message = message;
    }

    public BacktraceReport(Exception exception) {
        this(exception, null, null);
    }

    public BacktraceReport(Exception exception, Map<String, Object> attributes) {
        this(exception, attributes, null);
    }

    public BacktraceReport(Exception exception, List<String> attachmentPaths) {
        this(exception, null, attachmentPaths);
    }

    public BacktraceReport(Exception exception, Map<String, Object> attributes, List<String> attachmentPaths) {
        this.attributes = attributes == null ? new HashMap<String, Object>(){} : attributes;
        this.attachmentPaths = attachmentPaths == null ? new ArrayList() : attachmentPaths;
        this.exception = exception;
        this.exceptionTypeReport = exception != null;
        this.diagnosticStack = new BacktraceStackTrace(exception).getStackFrames();
        if (this.exceptionTypeReport.booleanValue() && exception != null) {
            this.classifier = exception.getClass().getCanonicalName();
        }
        this.setDefaultErrorTypeAttribute();
    }

    private void setDefaultErrorTypeAttribute() {
        if (this.attributes.containsKey("error.type")) {
            return;
        }
        this.attributes.put("error.type", this.exceptionTypeReport != false ? "Exception" : "Message");
    }

    public static Map<String, Object> concatAttributes(BacktraceReport report, Map<String, Object> attributes) {
        HashMap<String, Object> reportAttributes;
        HashMap<String, Object> hashMap = reportAttributes = report.attributes != null ? report.attributes : new HashMap<String, Object>();
        if (attributes == null) {
            return reportAttributes;
        }
        reportAttributes.putAll(attributes);
        return reportAttributes;
    }

    public BacktraceData toBacktraceData(Context context, Map<String, Object> clientAttributes) {
        return this.toBacktraceData(context, clientAttributes, false);
    }

    public BacktraceData toBacktraceData(Context context, Map<String, Object> clientAttributes, boolean isProguardEnabled) {
        BacktraceData backtraceData = new BacktraceData(context, this, clientAttributes);
        backtraceData.symbolication = isProguardEnabled ? "proguard" : null;
        return backtraceData;
    }
}

