/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models.json;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import backtraceio.library.BacktraceClient;
import backtraceio.library.common.BacktraceStringHelper;
import backtraceio.library.common.DeviceAttributesHelper;
import backtraceio.library.common.TypeHelper;
import backtraceio.library.enums.ScreenOrientation;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.json.BacktraceReport;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class BacktraceAttributes {
    private static final transient String LOG_TAG = BacktraceAttributes.class.getSimpleName();
    public Map<String, String> attributes = new HashMap<String, String>();
    private final Map<String, Object> complexAttributes = new HashMap<String, Object>();
    private final Context context;
    private static boolean isMetricsEnabled = false;
    private static String sessionId = UUID.randomUUID().toString();

    public BacktraceAttributes(Context context, BacktraceReport report, Map<String, Object> clientAttributes) {
        this(context, report, clientAttributes, true);
    }

    public BacktraceAttributes(Context context, Map<String, Object> clientAttributes) {
        this(context, null, clientAttributes, false);
    }

    public BacktraceAttributes(Context context, BacktraceReport report, Map<String, Object> clientAttributes, Boolean includeDynamicAttributes) {
        this.context = context;
        if (report != null) {
            this.convertReportAttributes(report);
            this.setExceptionAttributes(report);
        }
        if (clientAttributes != null) {
            this.convertClientAttributes(clientAttributes);
        }
        if (report != null && clientAttributes != null) {
            BacktraceReport.concatAttributes(report, clientAttributes);
        }
        this.setAppInformation();
        this.setDeviceInformation(includeDynamicAttributes);
        this.setScreenInformation(includeDynamicAttributes);
    }

    public Map<String, Object> getComplexAttributes() {
        return this.complexAttributes;
    }

    private void setDeviceInformation(Boolean includeDynamicAttributes) {
        this.attributes.put("uname.version", Build.VERSION.RELEASE);
        this.attributes.put("culture", Locale.getDefault().getDisplayLanguage());
        this.attributes.put("build.type", "Release");
        this.attributes.put("device.model", Build.MODEL);
        this.attributes.put("device.brand", Build.BRAND);
        this.attributes.put("device.product", Build.PRODUCT);
        this.attributes.put("device.sdk", String.valueOf(Build.VERSION.SDK_INT));
        this.attributes.put("device.manufacturer", Build.MANUFACTURER);
        this.attributes.put("device.os_version", System.getProperty("os.version"));
        DeviceAttributesHelper deviceAttributesHelper = new DeviceAttributesHelper(this.context);
        this.attributes.putAll(deviceAttributesHelper.getDeviceAttributes(includeDynamicAttributes));
    }

    private void setAppInformation() {
        this.attributes.put("application.package", this.context.getApplicationContext().getPackageName());
        this.attributes.put("application", this.getApplicationName());
        String version = this.getApplicationVersionOrEmpty();
        if (!BacktraceStringHelper.isNullOrEmpty(version)) {
            this.attributes.put("application.version", version);
            this.attributes.put("version", version);
        }
        this.attributes.put("application.session", sessionId);
        this.attributes.put("backtrace.agent", "backtrace-android");
        this.attributes.put("backtrace.version", BacktraceClient.version);
    }

    private void setScreenInformation(Boolean includeDynamicAttributes) {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        this.attributes.put("screen.width", String.valueOf(metrics.widthPixels));
        this.attributes.put("screen.height", String.valueOf(metrics.heightPixels));
        this.attributes.put("screen.dpi", String.valueOf(metrics.densityDpi));
        if (!includeDynamicAttributes.booleanValue()) {
            return;
        }
        this.attributes.put("screen.orientation", this.getScreenOrientation().toString());
        this.attributes.put("screen.brightness", String.valueOf(this.getScreenBrightness()));
    }

    private void setExceptionAttributes(BacktraceReport report) {
        if (report == null) {
            return;
        }
        if (!report.exceptionTypeReport.booleanValue()) {
            this.attributes.put("error.message", report.message);
            return;
        }
        this.attributes.put("classifier", report.exception.getClass().getName());
        this.attributes.put("error.message", report.exception.getMessage());
    }

    private ScreenOrientation getScreenOrientation() {
        int orientation = this.context.getResources().getConfiguration().orientation;
        if (orientation == 1) {
            return ScreenOrientation.PORTRAIT;
        }
        if (orientation == 2) {
            return ScreenOrientation.LANDSCAPE;
        }
        return ScreenOrientation.UNDEFINED;
    }

    private int getScreenBrightness() {
        return Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)"screen_brightness", (int)0);
    }

    private void convertClientAttributes(Map<String, Object> clientAttributes) {
        this.convertAttributes(clientAttributes);
    }

    private void convertReportAttributes(BacktraceReport report) {
        Map<String, Object> attributes = BacktraceReport.concatAttributes(report, null);
        this.convertAttributes(attributes);
        if (report.exceptionTypeReport.booleanValue()) {
            this.complexAttributes.put("Exception properties", report.exception);
        }
    }

    private void convertAttributes(Map<String, Object> attributes) {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            Class<?> type = value.getClass();
            if (TypeHelper.isPrimitiveOrPrimitiveWrapperOrString(type)) {
                this.attributes.put(entry.getKey(), value.toString());
                continue;
            }
            this.complexAttributes.put(entry.getKey(), value);
        }
    }

    public String getApplicationName() {
        return this.context.getApplicationInfo().loadLabel(this.context.getPackageManager()).toString();
    }

    public String getApplicationVersionOrEmpty() {
        try {
            return this.context.getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            BacktraceLogger.e(LOG_TAG, "Could not resolve application version");
            e.printStackTrace();
            return "";
        }
    }

    public Map<String, Object> getAllAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(this.attributes);
        attributes.putAll(this.complexAttributes);
        return attributes;
    }
}

