/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models;

import android.content.Context;
import backtraceio.library.BacktraceClient;
import backtraceio.library.common.FileHelper;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.json.Annotations;
import backtraceio.library.models.json.BacktraceAttributes;
import backtraceio.library.models.json.BacktraceReport;
import backtraceio.library.models.json.SourceCode;
import backtraceio.library.models.json.SourceCodeData;
import backtraceio.library.models.json.ThreadData;
import backtraceio.library.models.json.ThreadInformation;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class BacktraceData {
    private static final transient String LOG_TAG = BacktraceData.class.getSimpleName();
    @SerializedName(value="lang")
    public final String lang = "java";
    @SerializedName(value="agent")
    public final String agent = "backtrace-android";
    @SerializedName(value="symbolication")
    public String symbolication;
    @SerializedName(value="uuid")
    public String uuid;
    @SerializedName(value="timestamp")
    public long timestamp;
    @SerializedName(value="langVersion")
    public String langVersion;
    @SerializedName(value="agentVersion")
    public String agentVersion;
    @SerializedName(value="attributes")
    public Map<String, String> attributes;
    @SerializedName(value="mainThread")
    public String mainThread;
    @SerializedName(value="classifiers")
    public String[] classifiers;
    @SerializedName(value="annotations")
    public Map<String, Object> annotations;
    @SerializedName(value="sourceCode")
    public Map<String, SourceCode> sourceCode;
    public transient BacktraceReport report;
    public transient Context context;
    @SerializedName(value="threads")
    Map<String, ThreadInformation> threadInformationMap;

    public BacktraceData(Context context, BacktraceReport report, Map<String, Object> clientAttributes) {
        if (report == null) {
            return;
        }
        this.context = context;
        this.report = report;
        this.setReportInformation();
        this.setThreadsInformation();
        this.setAttributes(clientAttributes);
    }

    public List<String> getAttachments() {
        return FileHelper.filterOutFiles(this.context, this.report.attachmentPaths);
    }

    private void setAnnotations(Map<String, Object> complexAttributes) {
        BacktraceLogger.d(LOG_TAG, "Setting annotations");
        String exceptionMessage = null;
        if (this.attributes != null && this.attributes.containsKey("error.message")) {
            exceptionMessage = this.attributes.get("error.message");
        }
        this.annotations = Annotations.getAnnotations(exceptionMessage, complexAttributes);
    }

    private void setAttributes(Map<String, Object> clientAttributes) {
        BacktraceLogger.d(LOG_TAG, "Setting attributes");
        BacktraceAttributes backtraceAttributes = new BacktraceAttributes(this.context, this.report, clientAttributes);
        this.attributes = backtraceAttributes.attributes;
        this.setAnnotations(backtraceAttributes.getComplexAttributes());
    }

    private void setReportInformation() {
        String[] stringArray;
        BacktraceLogger.d(LOG_TAG, "Setting report information");
        this.uuid = this.report.uuid.toString();
        this.timestamp = this.report.timestamp;
        if (this.report.exceptionTypeReport.booleanValue()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.report.classifier;
        } else {
            stringArray = null;
        }
        this.classifiers = stringArray;
        this.langVersion = System.getProperty("java.version");
        this.agentVersion = BacktraceClient.version;
    }

    private void setThreadsInformation() {
        BacktraceLogger.d(LOG_TAG, "Setting threads information");
        ThreadData threadData = new ThreadData(this.report.diagnosticStack);
        this.mainThread = threadData.getMainThread();
        this.threadInformationMap = threadData.threadInformation;
        SourceCodeData sourceCodeData = new SourceCodeData(this.report.diagnosticStack);
        this.sourceCode = sourceCodeData.data.isEmpty() ? null : sourceCodeData.data;
    }
}

