/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.logger;

import android.util.Log;
import backtraceio.library.logger.LogLevel;

public class BacktraceLogger {
    private static final String BASE_TAG = "BacktraceLogger: ";
    private static LogLevel logLevel = LogLevel.OFF;

    public static void setLevel(LogLevel level) {
        logLevel = level;
    }

    public static int d(String tag, String message) {
        if (logLevel.ordinal() <= LogLevel.DEBUG.ordinal()) {
            return Log.d((String)BacktraceLogger.getTag(tag), (String)message);
        }
        return 0;
    }

    public static int w(String tag, String message) {
        if (logLevel.ordinal() <= LogLevel.WARN.ordinal()) {
            return Log.w((String)BacktraceLogger.getTag(tag), (String)message);
        }
        return 0;
    }

    public static int e(String tag, String message) {
        if (logLevel.ordinal() <= LogLevel.ERROR.ordinal()) {
            return Log.e((String)BacktraceLogger.getTag(tag), (String)message);
        }
        return 0;
    }

    public static int e(String tag, String message, Throwable tr) {
        if (logLevel.ordinal() <= LogLevel.ERROR.ordinal()) {
            return Log.e((String)BacktraceLogger.getTag(tag), (String)message, (Throwable)tr);
        }
        return 0;
    }

    private static String getTag(String tag) {
        return BASE_TAG + tag;
    }
}

