/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.common;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.net.wifi.WifiManager;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import backtraceio.library.common.PermissionHelper;
import backtraceio.library.enums.BatteryState;
import backtraceio.library.enums.BluetoothStatus;
import backtraceio.library.enums.GpsStatus;
import backtraceio.library.enums.LocationStatus;
import backtraceio.library.enums.NfcStatus;
import backtraceio.library.enums.WifiStatus;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.UUID;

public class DeviceAttributesHelper {
    private final Context context;

    public DeviceAttributesHelper(Context context) {
        this.context = context;
    }

    public HashMap<String, String> getDeviceAttributes(Boolean includeDynamicAttributes) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("guid", this.generateDeviceId());
        result.put("uname.sysname", "Android");
        result.put("uname.machine", System.getProperty("os.arch"));
        if (!includeDynamicAttributes.booleanValue()) {
            return result;
        }
        result.put("device.airplane_mode", String.valueOf(this.isAirplaneModeOn()));
        result.put("device.location", this.getLocationServiceStatus().toString());
        result.put("device.nfc.status", this.getNfcStatus().toString());
        result.put("device.gps.enabled", this.getGpsStatus().toString());
        result.put("device.bluetooth_status", this.isBluetoothEnabled().toString());
        result.put("device.cpu.temperature", String.valueOf(this.getCpuTemperature()));
        result.put("device.is_power_saving_mode", String.valueOf(this.isPowerSavingMode()));
        result.put("device.wifi.status", this.getWifiStatus().toString());
        result.put("system.memory.total", this.getMaxRamSize());
        result.put("system.memory.free", this.getDeviceFreeRam());
        result.put("system.memory.active", this.getDeviceActiveRam());
        result.put("app.storage_used", this.getAppUsedStorageSize());
        result.put("battery.level", String.valueOf(this.getBatteryLevel()));
        result.put("battery.state", this.getBatteryState().toString());
        result.put("cpu.boottime", String.valueOf(System.currentTimeMillis() - SystemClock.elapsedRealtime()));
        return result;
    }

    private boolean isAirplaneModeOn() {
        return Settings.Global.getInt((ContentResolver)this.context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    private LocationStatus getLocationServiceStatus() {
        int mode = Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"location_mode", (int)0);
        if (mode != 0) {
            return LocationStatus.ENABLED;
        }
        return LocationStatus.DISABLED;
    }

    private NfcStatus getNfcStatus() {
        NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.context);
        if (nfcAdapter == null) {
            return NfcStatus.NOT_AVAILABLE;
        }
        if (!nfcAdapter.isEnabled()) {
            return NfcStatus.DISABLED;
        }
        return NfcStatus.ENABLED;
    }

    @SuppressLint(value={"MissingPermission"})
    private BluetoothStatus isBluetoothEnabled() {
        BluetoothAdapter mBluetoothAdapter;
        if (!PermissionHelper.isPermissionForBluetoothGranted(this.context)) {
            return BluetoothStatus.NOT_PERMITTED;
        }
        BluetoothManager mBluetoothManager = (BluetoothManager)this.context.getSystemService("bluetooth");
        if (mBluetoothManager != null && (mBluetoothAdapter = mBluetoothManager.getAdapter()) != null && mBluetoothAdapter.isEnabled()) {
            return BluetoothStatus.ENABLED;
        }
        return BluetoothStatus.DISABLED;
    }

    private float getCpuTemperature() {
        try {
            Process p = Runtime.getRuntime().exec("cat sys/class/thermal/thermal_zone0/temp");
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = reader.readLine();
            if (line == null) {
                return 0.0f;
            }
            return Float.parseFloat(line) / 1000.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private GpsStatus getGpsStatus() {
        LocationManager manager = (LocationManager)this.context.getSystemService("location");
        return manager.isProviderEnabled("gps") ? GpsStatus.ENABLED : GpsStatus.DISABLED;
    }

    private WifiStatus getWifiStatus() {
        if (!PermissionHelper.isPermissionForAccessWifiStateGranted(this.context)) {
            return WifiStatus.NOT_PERMITTED;
        }
        WifiManager mng = (WifiManager)this.context.getApplicationContext().getSystemService("wifi");
        if (mng.isWifiEnabled()) {
            return WifiStatus.ENABLED;
        }
        return WifiStatus.DISABLED;
    }

    private boolean isPowerSavingMode() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        PowerManager powerManager = (PowerManager)this.context.getSystemService("power");
        return powerManager.isPowerSaveMode();
    }

    private float getBatteryLevel() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.context.registerReceiver(null, intentFilter);
        if (batteryStatus == null) {
            return -1.0f;
        }
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        return (float)level / (float)scale;
    }

    private BatteryState getBatteryState() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.context.registerReceiver(null, intentFilter);
        if (batteryStatus == null) {
            return BatteryState.UNKNOWN;
        }
        int status = batteryStatus.getIntExtra("status", -1);
        switch (status) {
            case 5: {
                return BatteryState.FULL;
            }
            case 2: {
                return BatteryState.CHARGING;
            }
            case 4: {
                return BatteryState.UNPLUGGED;
            }
        }
        return BatteryState.UNKNOWN;
    }

    private String generateDeviceId() {
        String androidId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        if (TextUtils.isEmpty((CharSequence)androidId)) {
            return null;
        }
        return UUID.nameUUIDFromBytes(androidId.getBytes()).toString();
    }

    private String getMaxRamSize() {
        return Long.toString(this.getMemoryInformation().totalMem);
    }

    private String getDeviceFreeRam() {
        return Long.toString(this.getMemoryInformation().availMem);
    }

    private String getDeviceActiveRam() {
        ActivityManager.MemoryInfo mi = this.getMemoryInformation();
        return Long.toString(mi.totalMem - mi.availMem);
    }

    private ActivityManager.MemoryInfo getMemoryInformation() {
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
        activityManager.getMemoryInfo(memInfo);
        return memInfo;
    }

    private String getAppUsedStorageSize() {
        long freeSize = 0L;
        long totalSize = 0L;
        long usedSize = -1L;
        try {
            Runtime info = Runtime.getRuntime();
            freeSize = info.freeMemory();
            totalSize = info.totalMemory();
            usedSize = totalSize - freeSize;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Long.toString(usedSize);
    }
}

