/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.breadcrumbs;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.os.Build;
import backtraceio.library.breadcrumbs.BacktraceActivityLifecycleListener;
import backtraceio.library.breadcrumbs.BacktraceBreadcrumbsLogManager;
import backtraceio.library.breadcrumbs.BacktraceBroadcastReceiver;
import backtraceio.library.breadcrumbs.BacktraceComponentListener;
import backtraceio.library.enums.BacktraceBreadcrumbLevel;
import backtraceio.library.enums.BacktraceBreadcrumbType;
import backtraceio.library.events.OnSuccessfulBreadcrumbAddEventListener;
import backtraceio.library.interfaces.Breadcrumbs;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.json.BacktraceReport;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class BacktraceBreadcrumbs
implements Breadcrumbs {
    private static final transient String LOG_TAG = BacktraceBreadcrumbs.class.getSimpleName();
    private OnSuccessfulBreadcrumbAddEventListener onSuccessfulBreadcrumbAddEventListener = null;
    private EnumSet<BacktraceBreadcrumbType> enabledBreadcrumbTypes;
    private BacktraceBroadcastReceiver backtraceBroadcastReceiver;
    private BacktraceComponentListener backtraceComponentListener;
    private BacktraceActivityLifecycleListener backtraceActivityLifecycleListener;
    private BacktraceBreadcrumbsLogManager backtraceBreadcrumbsLogManager;
    private Context context;
    public static final int DEFAULT_MAX_LOG_SIZE_BYTES = 64000;
    String breadcrumbLogDirectory;
    private static final String breadcrumbLogFileName = "bt-breadcrumbs-0";

    public BacktraceBreadcrumbs(String breadcrumbLogDirectory) {
        this.breadcrumbLogDirectory = breadcrumbLogDirectory;
    }

    @Override
    public void setOnSuccessfulBreadcrumbAddEventListener(OnSuccessfulBreadcrumbAddEventListener eventListener) {
        this.onSuccessfulBreadcrumbAddEventListener = eventListener;
    }

    private void unregisterAutomaticBreadcrumbReceivers() {
        if (this.backtraceBroadcastReceiver != null) {
            BacktraceLogger.d(LOG_TAG, "Unregistering previous BacktraceBroadcastReceiver");
            this.context.unregisterReceiver((BroadcastReceiver)this.backtraceBroadcastReceiver);
            this.backtraceBroadcastReceiver = null;
        }
        if (this.backtraceComponentListener != null) {
            BacktraceLogger.d(LOG_TAG, "Unregistering previous BacktraceComponentListener");
            this.context.unregisterComponentCallbacks((ComponentCallbacks)this.backtraceComponentListener);
            this.backtraceComponentListener = null;
        }
        if (this.backtraceActivityLifecycleListener != null) {
            if (this.context instanceof Application) {
                BacktraceLogger.d(LOG_TAG, "Unregistering previous BacktraceActivityLifecycleListener");
                ((Application)this.context).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.backtraceActivityLifecycleListener);
                this.backtraceActivityLifecycleListener = null;
            } else {
                BacktraceLogger.e(LOG_TAG, "BacktraceActivityLifecycleListener registered with non-Activity context");
            }
        }
    }

    private void registerAutomaticBreadcrumbReceivers() {
        this.unregisterAutomaticBreadcrumbReceivers();
        if (this.enabledBreadcrumbTypes == null) {
            BacktraceLogger.d(LOG_TAG, "No breadcrumbs are enabled, not registering any new breadcrumb receivers");
            return;
        }
        this.registerBroadcastReceiver();
        if (this.enabledBreadcrumbTypes.contains((Object)BacktraceBreadcrumbType.SYSTEM)) {
            this.backtraceComponentListener = new BacktraceComponentListener(this);
            this.context.registerComponentCallbacks((ComponentCallbacks)this.backtraceComponentListener);
            if (this.context instanceof Application) {
                this.backtraceActivityLifecycleListener = new BacktraceActivityLifecycleListener(this);
                ((Application)this.context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.backtraceActivityLifecycleListener);
            }
        }
    }

    private void registerBroadcastReceiver() {
        this.backtraceBroadcastReceiver = new BacktraceBroadcastReceiver(this);
        if (Build.VERSION.SDK_INT >= 33) {
            this.context.registerReceiver((BroadcastReceiver)this.backtraceBroadcastReceiver, this.backtraceBroadcastReceiver.getIntentFilter(), 2);
        } else {
            this.context.registerReceiver((BroadcastReceiver)this.backtraceBroadcastReceiver, this.backtraceBroadcastReceiver.getIntentFilter());
        }
    }

    @Override
    public boolean enableBreadcrumbs(Context context) {
        return this.enableBreadcrumbs(context, BacktraceBreadcrumbType.ALL);
    }

    @Override
    public boolean enableBreadcrumbs(Context context, EnumSet<BacktraceBreadcrumbType> breadcrumbTypesToEnable) {
        return this.enableBreadcrumbs(context, breadcrumbTypesToEnable, 64000);
    }

    @Override
    public boolean enableBreadcrumbs(Context context, int maxBreadcrumbLogSizeBytes) {
        return this.enableBreadcrumbs(context, BacktraceBreadcrumbType.ALL, maxBreadcrumbLogSizeBytes);
    }

    @Override
    public boolean enableBreadcrumbs(Context context, EnumSet<BacktraceBreadcrumbType> breadcrumbTypesToEnable, int maxBreadcrumbLogSizeBytes) {
        this.context = context;
        if (this.backtraceBreadcrumbsLogManager == null) {
            try {
                this.backtraceBreadcrumbsLogManager = new BacktraceBreadcrumbsLogManager(this.breadcrumbLogDirectory + "/" + breadcrumbLogFileName, maxBreadcrumbLogSizeBytes);
            }
            catch (Exception ex) {
                BacktraceLogger.e(LOG_TAG, "Could not start the Breadcrumb logger due to: " + ex.getMessage());
                return false;
            }
        }
        this.enabledBreadcrumbTypes = breadcrumbTypesToEnable;
        this.registerAutomaticBreadcrumbReceivers();
        this.addConfigurationBreadcrumb();
        return true;
    }

    @Override
    public EnumSet<BacktraceBreadcrumbType> getEnabledBreadcrumbTypes() {
        return this.enabledBreadcrumbTypes;
    }

    @Override
    public boolean clearBreadcrumbs() {
        boolean success = this.backtraceBreadcrumbsLogManager.clear();
        this.addConfigurationBreadcrumb();
        return success;
    }

    @Override
    public void setCurrentBreadcrumbId(long breadcrumbId) {
        this.backtraceBreadcrumbsLogManager.setCurrentBreadcrumbId(breadcrumbId);
    }

    @Override
    public long getCurrentBreadcrumbId() {
        return this.backtraceBreadcrumbsLogManager.getCurrentBreadcrumbId();
    }

    @Override
    public boolean addBreadcrumb(String message) {
        return this.addBreadcrumb(message, null, BacktraceBreadcrumbType.MANUAL, BacktraceBreadcrumbLevel.INFO);
    }

    @Override
    public boolean addBreadcrumb(String message, BacktraceBreadcrumbLevel level) {
        return this.addBreadcrumb(message, null, BacktraceBreadcrumbType.MANUAL, level);
    }

    @Override
    public boolean addBreadcrumb(String message, Map<String, Object> attributes) {
        return this.addBreadcrumb(message, attributes, BacktraceBreadcrumbType.MANUAL, BacktraceBreadcrumbLevel.INFO);
    }

    @Override
    public boolean addBreadcrumb(String message, Map<String, Object> attributes, BacktraceBreadcrumbLevel level) {
        return this.addBreadcrumb(message, attributes, BacktraceBreadcrumbType.MANUAL, level);
    }

    @Override
    public boolean addBreadcrumb(String message, BacktraceBreadcrumbType type) {
        return this.addBreadcrumb(message, null, type, BacktraceBreadcrumbLevel.INFO);
    }

    @Override
    public boolean addBreadcrumb(String message, BacktraceBreadcrumbType type, BacktraceBreadcrumbLevel level) {
        return this.addBreadcrumb(message, null, type, level);
    }

    @Override
    public boolean addBreadcrumb(String message, Map<String, Object> attributes, BacktraceBreadcrumbType type) {
        return this.addBreadcrumb(message, attributes, type, BacktraceBreadcrumbLevel.INFO);
    }

    @Override
    public boolean addBreadcrumb(String message, Map<String, Object> attributes, BacktraceBreadcrumbType type, BacktraceBreadcrumbLevel level) {
        if (!this.isEnabled() || this.backtraceBreadcrumbsLogManager == null) {
            return false;
        }
        boolean addResult = this.backtraceBreadcrumbsLogManager.addBreadcrumb(message, attributes, type, level);
        if (addResult && this.onSuccessfulBreadcrumbAddEventListener != null) {
            this.onSuccessfulBreadcrumbAddEventListener.onSuccessfulAdd(this.getCurrentBreadcrumbId());
        }
        return addResult;
    }

    @Override
    public void processReportBreadcrumbs(BacktraceReport backtraceReport) {
        if (!this.isEnabled()) {
            return;
        }
        backtraceReport.attachmentPaths.add(this.getBreadcrumbLogPath());
        long lastBreadcrumbId = this.getCurrentBreadcrumbId();
        backtraceReport.attributes.put("breadcrumbs.lastId", lastBreadcrumbId);
    }

    private boolean addConfigurationBreadcrumb() {
        if (this.backtraceBreadcrumbsLogManager == null) {
            BacktraceLogger.e(LOG_TAG, "Could not add configuration breadcrumb, BreadcrumbsLogManager is null");
            return false;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (BacktraceBreadcrumbType enabledType : BacktraceBreadcrumbType.values()) {
            if (enabledType == BacktraceBreadcrumbType.CONFIGURATION) {
                attributes.put(enabledType.toString(), "enabled");
            }
            String state = this.enabledBreadcrumbTypes != null && this.enabledBreadcrumbTypes.contains((Object)enabledType) ? "enabled" : "disabled";
            attributes.put(enabledType.toString(), state);
        }
        return this.backtraceBreadcrumbsLogManager.addBreadcrumb("Breadcrumbs configuration", attributes, BacktraceBreadcrumbType.CONFIGURATION, BacktraceBreadcrumbLevel.INFO);
    }

    @Override
    public boolean isEnabled() {
        return this.enabledBreadcrumbTypes != null && !this.enabledBreadcrumbTypes.isEmpty();
    }

    @Override
    public String getBreadcrumbLogPath() {
        return this.breadcrumbLogDirectory + "/" + breadcrumbLogFileName;
    }
}

