/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.base;

import android.content.Context;
import backtraceio.library.BacktraceCredentials;
import backtraceio.library.BacktraceDatabase;
import backtraceio.library.enums.BacktraceBreadcrumbLevel;
import backtraceio.library.enums.BacktraceBreadcrumbType;
import backtraceio.library.enums.UnwindingMode;
import backtraceio.library.events.OnBeforeSendEventListener;
import backtraceio.library.events.OnServerErrorEventListener;
import backtraceio.library.events.OnServerResponseEventListener;
import backtraceio.library.events.RequestHandler;
import backtraceio.library.interfaces.Api;
import backtraceio.library.interfaces.Breadcrumbs;
import backtraceio.library.interfaces.Client;
import backtraceio.library.interfaces.Database;
import backtraceio.library.interfaces.Metrics;
import backtraceio.library.models.BacktraceData;
import backtraceio.library.models.BacktraceResult;
import backtraceio.library.models.database.BacktraceDatabaseRecord;
import backtraceio.library.models.database.BacktraceDatabaseSettings;
import backtraceio.library.models.json.BacktraceReport;
import backtraceio.library.models.types.BacktraceResultStatus;
import backtraceio.library.services.BacktraceApi;
import backtraceio.library.services.BacktraceMetrics;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BacktraceBase
implements Client {
    private static final transient String LOG_TAG = BacktraceBase.class.getSimpleName();
    public final Database database;
    public static String version;
    public final Map<String, Object> attributes;
    public final List<String> attachments;
    private final BacktraceCredentials credentials;
    public Metrics metrics = null;
    protected Context context;
    private Api backtraceApi;
    private OnBeforeSendEventListener beforeSendEventListener = null;
    private boolean isProguardEnabled = false;

    public BacktraceBase(Context context, BacktraceCredentials credentials) {
        this(context, credentials, (Database)null);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, List<String> attachments) {
        this(context, credentials, (Database)null, attachments);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, Map<String, Object> attributes) {
        this(context, credentials, (Database)null, attributes);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, Map<String, Object> attributes, List<String> attachments) {
        this(context, credentials, (Database)null, attributes, attachments);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, BacktraceDatabaseSettings databaseSettings) {
        this(context, credentials, new BacktraceDatabase(context, databaseSettings));
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, BacktraceDatabaseSettings databaseSettings, List<String> attachments) {
        this(context, credentials, (Database)new BacktraceDatabase(context, databaseSettings), attachments);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, BacktraceDatabaseSettings databaseSettings, Map<String, Object> attributes) {
        this(context, credentials, (Database)new BacktraceDatabase(context, databaseSettings), attributes);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, BacktraceDatabaseSettings databaseSettings, Map<String, Object> attributes, List<String> attachments) {
        this(context, credentials, new BacktraceDatabase(context, databaseSettings), attributes, attachments);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, Database database) {
        this(context, credentials, database, (Map<String, Object>)null);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, Database database, List<String> attachments) {
        this(context, credentials, database, null, attachments);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, Database database, Map<String, Object> attributes) {
        this(context, credentials, database, attributes, null);
    }

    public BacktraceBase(Context context, BacktraceCredentials credentials, Database database, Map<String, Object> attributes, List<String> attachments) {
        this.context = context;
        this.credentials = credentials;
        this.attributes = attributes != null ? attributes : new HashMap<String, Object>();
        this.attachments = attachments != null ? attachments : new ArrayList();
        this.database = database != null ? database : new BacktraceDatabase();
        this.setBacktraceApi(new BacktraceApi(credentials));
        this.database.start();
        this.metrics = new BacktraceMetrics(context, attributes, this.backtraceApi, credentials);
    }

    public native void crash();

    private void setBacktraceApi(Api backtraceApi) {
        this.backtraceApi = backtraceApi;
        if (this.database != null) {
            this.database.setApi(this.backtraceApi);
        }
    }

    @Override
    public void enableNativeIntegration() {
        this.database.setupNativeIntegration(this, this.credentials);
    }

    public void enableNativeIntegration(boolean enableClientSideUnwinding) {
        this.database.setupNativeIntegration(this, this.credentials, enableClientSideUnwinding);
    }

    public void enableNativeIntegration(boolean enableClientSideUnwinding, UnwindingMode unwindingMode) {
        this.database.setupNativeIntegration(this, this.credentials, enableClientSideUnwinding, unwindingMode);
    }

    public void disableNativeIntegration() {
        this.database.disableNativeIntegration();
    }

    public void enableProguard() {
        this.isProguardEnabled = true;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setOnBeforeSendEventListener(OnBeforeSendEventListener eventListener) {
        this.beforeSendEventListener = eventListener;
    }

    public void setOnServerErrorEventListener(OnServerErrorEventListener eventListener) {
        this.backtraceApi.setOnServerError(eventListener);
    }

    public void setOnRequestHandler(RequestHandler requestHandler) {
        this.backtraceApi.setRequestHandler(requestHandler);
    }

    public boolean enableBreadcrumbs(Context context) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().enableBreadcrumbs(context);
    }

    public boolean enableBreadcrumbs(Context context, int maxBreadcrumbLogSizeBytes) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().enableBreadcrumbs(context, maxBreadcrumbLogSizeBytes);
    }

    public boolean enableBreadcrumbs(Context context, EnumSet<BacktraceBreadcrumbType> breadcrumbTypesToEnable) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().enableBreadcrumbs(context, breadcrumbTypesToEnable);
    }

    public boolean enableBreadcrumbs(Context context, EnumSet<BacktraceBreadcrumbType> breadcrumbTypesToEnable, int maxBreadcrumbLogSizeBytes) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().enableBreadcrumbs(context, breadcrumbTypesToEnable, maxBreadcrumbLogSizeBytes);
    }

    public boolean clearBreadcrumbs() {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().clearBreadcrumbs();
    }

    public boolean addBreadcrumb(String message) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().addBreadcrumb(message);
    }

    public boolean addBreadcrumb(String message, BacktraceBreadcrumbLevel level) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().addBreadcrumb(message, level);
    }

    public boolean addBreadcrumb(String message, Map<String, Object> attributes) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().addBreadcrumb(message, attributes);
    }

    public boolean addBreadcrumb(String message, Map<String, Object> attributes, BacktraceBreadcrumbLevel level) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().addBreadcrumb(message, attributes, level);
    }

    public boolean addBreadcrumb(String message, BacktraceBreadcrumbType type) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().addBreadcrumb(message, type);
    }

    public boolean addBreadcrumb(String message, BacktraceBreadcrumbType type, BacktraceBreadcrumbLevel level) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().addBreadcrumb(message, type, level);
    }

    public boolean addBreadcrumb(String message, Map<String, Object> attributes, BacktraceBreadcrumbType type) {
        if (this.isBreadcrumbsAvailable()) {
            return this.database.getBreadcrumbs().addBreadcrumb(message, attributes, type);
        }
        return false;
    }

    public boolean addBreadcrumb(String message, Map<String, Object> attributes, BacktraceBreadcrumbType type, BacktraceBreadcrumbLevel level) {
        if (!this.isBreadcrumbsAvailable()) {
            return false;
        }
        return this.database.getBreadcrumbs().addBreadcrumb(message, attributes, type, level);
    }

    public void nativeCrash() {
        this.crash();
    }

    public native void dumpWithoutCrash(String var1);

    public native void dumpWithoutCrash(String var1, boolean var2);

    @Override
    public void send(BacktraceReport report) {
        this.send(report, null);
    }

    public void send(BacktraceReport report, OnServerResponseEventListener callback) {
        Breadcrumbs breadcrumbs = this.database.getBreadcrumbs();
        if (breadcrumbs != null) {
            breadcrumbs.processReportBreadcrumbs(report);
        }
        this.addReportAttachments(report);
        BacktraceData backtraceData = new BacktraceData(this.context, report, this.attributes);
        backtraceData.symbolication = this.isProguardEnabled ? "proguard" : null;
        BacktraceDatabaseRecord record = this.database.add(report, this.attributes, this.isProguardEnabled);
        if (this.beforeSendEventListener != null) {
            backtraceData = this.beforeSendEventListener.onEvent(backtraceData);
        }
        this.backtraceApi.send(backtraceData, this.getDatabaseCallback(record, callback));
    }

    private OnServerResponseEventListener getDatabaseCallback(final BacktraceDatabaseRecord record, final OnServerResponseEventListener customCallback) {
        return new OnServerResponseEventListener(){

            @Override
            public void onEvent(BacktraceResult backtraceResult) {
                if (record != null) {
                    record.close();
                }
                if (backtraceResult != null && backtraceResult.status == BacktraceResultStatus.Ok) {
                    BacktraceBase.this.database.delete(record);
                }
                if (customCallback != null) {
                    customCallback.onEvent(backtraceResult);
                }
            }
        };
    }

    private void addReportAttachments(BacktraceReport report) {
        if (this.attachments != null) {
            for (String path : this.attachments) {
                report.attachmentPaths.add(path);
            }
        }
    }

    private boolean isBreadcrumbsAvailable() {
        return this.database != null && this.database.getBreadcrumbs() != null;
    }

    static {
        System.loadLibrary("backtrace-native");
        version = "3.7.11";
    }
}

