/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library;

import android.content.Context;
import backtraceio.library.BacktraceCredentials;
import backtraceio.library.base.BacktraceBase;
import backtraceio.library.breadcrumbs.BacktraceBreadcrumbs;
import backtraceio.library.common.FileHelper;
import backtraceio.library.enums.UnwindingMode;
import backtraceio.library.enums.database.RetryBehavior;
import backtraceio.library.events.OnServerResponseEventListener;
import backtraceio.library.interfaces.Api;
import backtraceio.library.interfaces.Breadcrumbs;
import backtraceio.library.interfaces.Database;
import backtraceio.library.interfaces.DatabaseContext;
import backtraceio.library.interfaces.DatabaseFileContext;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.BacktraceData;
import backtraceio.library.models.BacktraceResult;
import backtraceio.library.models.database.BacktraceDatabaseRecord;
import backtraceio.library.models.database.BacktraceDatabaseSettings;
import backtraceio.library.models.json.BacktraceAttributes;
import backtraceio.library.models.json.BacktraceReport;
import backtraceio.library.models.types.BacktraceResultStatus;
import backtraceio.library.services.BacktraceDatabaseContext;
import backtraceio.library.services.BacktraceDatabaseFileContext;
import java.io.File;
import java.util.Calendar;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

public class BacktraceDatabase
implements Database {
    private final String _crashpadHandlerName = "/libcrashpad_handler.so";
    private final String _crashpadDatabasePathPrefix = "/crashpad";
    private static boolean _timerBackgroundWork = false;
    private static Timer _timer;
    private final transient String LOG_TAG = BacktraceDatabase.class.getSimpleName();
    private Api BacktraceApi;
    private Context _applicationContext;
    private DatabaseContext backtraceDatabaseContext;
    private DatabaseFileContext backtraceDatabaseFileContext;
    private BacktraceDatabaseSettings databaseSettings;
    private boolean _enable = false;
    private Breadcrumbs breadcrumbs;

    public native void addAttribute(String var1, String var2);

    private native boolean initialize(String var1, String var2, String var3, String[] var4, String[] var5, String[] var6, boolean var7, UnwindingMode var8);

    private native void disable();

    public BacktraceDatabase() {
        BacktraceLogger.w(this.LOG_TAG, "Disabled instance of BacktraceDatabase created, native crashes won't be captured");
    }

    public BacktraceDatabase(Context context, String path) {
        this(context, new BacktraceDatabaseSettings(path));
    }

    public BacktraceDatabase(Context context, BacktraceDatabaseSettings databaseSettings) {
        boolean createDirs;
        if (databaseSettings == null || context == null) {
            throw new IllegalArgumentException("Database settings or application context is null");
        }
        if (databaseSettings.getDatabasePath() == null || databaseSettings.getDatabasePath().isEmpty()) {
            throw new IllegalArgumentException("Database path is null or empty");
        }
        if (!(FileHelper.isFileExists(databaseSettings.getDatabasePath()) || (createDirs = new File(databaseSettings.getDatabasePath()).mkdirs()) && FileHelper.isFileExists(databaseSettings.getDatabasePath()))) {
            throw new IllegalArgumentException("Incorrect database path or application doesn't have permission to write to this path");
        }
        this._applicationContext = context;
        this.databaseSettings = databaseSettings;
        this.backtraceDatabaseContext = new BacktraceDatabaseContext(this._applicationContext, databaseSettings);
        this.backtraceDatabaseFileContext = new BacktraceDatabaseFileContext(this.getDatabasePath(), this.databaseSettings.getMaxDatabaseSize(), this.databaseSettings.getMaxRecordCount());
        this.breadcrumbs = new BacktraceBreadcrumbs(this.getDatabasePath());
    }

    private String getDatabasePath() {
        return this.databaseSettings.getDatabasePath();
    }

    @Override
    public Boolean setupNativeIntegration(BacktraceBase client, BacktraceCredentials credentials) {
        return this.setupNativeIntegration(client, credentials, false);
    }

    @Override
    public Boolean setupNativeIntegration(BacktraceBase client, BacktraceCredentials credentials, boolean enableClientSideUnwinding) {
        return this.setupNativeIntegration(client, credentials, enableClientSideUnwinding, UnwindingMode.REMOTE_DUMPWITHOUTCRASH);
    }

    @Override
    public Boolean setupNativeIntegration(BacktraceBase client, BacktraceCredentials credentials, boolean enableClientSideUnwinding, UnwindingMode unwindingMode) {
        if (this.getSettings() == null) {
            return false;
        }
        String minidumpSubmissionUrl = credentials.getMinidumpSubmissionUrl().toString();
        if (minidumpSubmissionUrl == null) {
            return false;
        }
        String handlerPath = this._applicationContext.getApplicationInfo().nativeLibraryDir + "/libcrashpad_handler.so";
        if (!FileHelper.isFileExists(handlerPath)) {
            return false;
        }
        BacktraceAttributes crashpadAttributes = new BacktraceAttributes(this._applicationContext, client.attributes);
        crashpadAttributes.attributes.put("error.type", "Crash");
        String[] keys = crashpadAttributes.attributes.keySet().toArray(new String[0]);
        String[] values = crashpadAttributes.attributes.values().toArray(new String[0]);
        String[] attachmentPaths = new String[client.attachments.size() + 1];
        if (client.attachments != null) {
            for (int i = 0; i < client.attachments.size(); ++i) {
                attachmentPaths[i] = client.attachments.get(i);
            }
        }
        attachmentPaths[attachmentPaths.length - 1] = this.breadcrumbs.getBreadcrumbLogPath();
        String databasePath = this.getSettings().getDatabasePath() + "/crashpad";
        File crashHandlerDir = new File(databasePath);
        crashHandlerDir.mkdir();
        Boolean initialized = this.initialize(minidumpSubmissionUrl, databasePath, handlerPath, keys, values, attachmentPaths, enableClientSideUnwinding, unwindingMode);
        if (initialized.booleanValue() && this.breadcrumbs.isEnabled()) {
            this.breadcrumbs.setOnSuccessfulBreadcrumbAddEventListener(breadcrumbId -> this.addAttribute("breadcrumbs.lastId", Long.toString(breadcrumbId)));
        }
        return initialized;
    }

    @Override
    public void disableNativeIntegration() {
        this.disable();
    }

    @Override
    public Breadcrumbs getBreadcrumbs() {
        return this.breadcrumbs;
    }

    @Override
    public void start() {
        if (this.databaseSettings == null) {
            return;
        }
        if (this.backtraceDatabaseContext != null && !this.backtraceDatabaseContext.isEmpty()) {
            this._enable = true;
            return;
        }
        this.loadReports();
        this.removeOrphaned();
        if (this.databaseSettings.getRetryBehavior() == RetryBehavior.ByInterval || this.databaseSettings.isAutoSendMode()) {
            this.setupTimer();
        }
        this._enable = true;
    }

    @Override
    public BacktraceDatabaseSettings getSettings() {
        return this.databaseSettings;
    }

    private void setupTimer() {
        _timer = new Timer();
        _timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                String dateTimeNow = Calendar.getInstance().getTime().toString();
                BacktraceLogger.d(BacktraceDatabase.this.LOG_TAG, "Timer - " + dateTimeNow);
                if (BacktraceDatabase.this.backtraceDatabaseContext == null) {
                    BacktraceLogger.w(BacktraceDatabase.this.LOG_TAG, "Timer - database context is null: " + dateTimeNow);
                    return;
                }
                if (BacktraceDatabase.this.backtraceDatabaseContext.isEmpty()) {
                    BacktraceLogger.d(BacktraceDatabase.this.LOG_TAG, "Timer - database is empty (no records): " + dateTimeNow);
                    return;
                }
                if (_timerBackgroundWork) {
                    BacktraceLogger.d(BacktraceDatabase.this.LOG_TAG, "Timer - another timer works now: " + dateTimeNow);
                    return;
                }
                BacktraceLogger.d(BacktraceDatabase.this.LOG_TAG, "Timer - continue working: " + dateTimeNow);
                _timerBackgroundWork = true;
                _timer.cancel();
                _timer.purge();
                _timer = null;
                BacktraceDatabaseRecord record = BacktraceDatabase.this.backtraceDatabaseContext.first();
                while (record != null) {
                    final CountDownLatch threadWaiter = new CountDownLatch(1);
                    BacktraceData backtraceData = record.getBacktraceData(BacktraceDatabase.this._applicationContext);
                    if (backtraceData == null || backtraceData.report == null) {
                        BacktraceLogger.d(BacktraceDatabase.this.LOG_TAG, "Timer - backtrace data or report is null - deleting record");
                        BacktraceDatabase.this.delete(record);
                    } else {
                        final BacktraceDatabaseRecord currentRecord = record;
                        BacktraceDatabase.this.BacktraceApi.send(backtraceData, new OnServerResponseEventListener(){

                            @Override
                            public void onEvent(BacktraceResult backtraceResult) {
                                if (backtraceResult.status == BacktraceResultStatus.Ok) {
                                    BacktraceLogger.d(BacktraceDatabase.this.LOG_TAG, "Timer - deleting record");
                                    BacktraceDatabase.this.delete(currentRecord);
                                } else {
                                    BacktraceLogger.d(BacktraceDatabase.this.LOG_TAG, "Timer - closing record");
                                    currentRecord.close();
                                }
                                threadWaiter.countDown();
                            }
                        });
                        try {
                            threadWaiter.await();
                        }
                        catch (Exception ex) {
                            BacktraceLogger.e(BacktraceDatabase.this.LOG_TAG, "Error during waiting for result in Timer", ex);
                        }
                        if (currentRecord.valid() && !currentRecord.locked) {
                            BacktraceLogger.d(BacktraceDatabase.this.LOG_TAG, "Timer - record is valid and unlocked");
                            break;
                        }
                    }
                    record = BacktraceDatabase.this.backtraceDatabaseContext.first();
                }
                BacktraceLogger.d(BacktraceDatabase.this.LOG_TAG, "Setup new timer");
                _timerBackgroundWork = false;
                BacktraceDatabase.this.setupTimer();
            }
        }, this.databaseSettings.getRetryInterval() * 1000, (long)(this.databaseSettings.getRetryInterval() * 1000));
    }

    @Override
    public void flush() {
        if (this.BacktraceApi == null) {
            throw new IllegalArgumentException("BacktraceApi is required if you want to use Flush method");
        }
        BacktraceDatabaseRecord record = this.backtraceDatabaseContext.first();
        while (record != null) {
            BacktraceData backtraceData = record.getBacktraceData(this._applicationContext);
            this.delete(record);
            if (backtraceData != null) {
                this.BacktraceApi.send(backtraceData, null);
            }
            record = this.backtraceDatabaseContext.first();
        }
    }

    @Override
    public void setApi(Api backtraceApi) {
        this.BacktraceApi = backtraceApi;
    }

    @Override
    public void clear() {
        if (this.backtraceDatabaseContext != null) {
            this.backtraceDatabaseContext.clear();
        }
        if (this.backtraceDatabaseFileContext != null) {
            this.backtraceDatabaseFileContext.clear();
        }
    }

    private void removeOrphaned() {
        Iterable<BacktraceDatabaseRecord> records = this.backtraceDatabaseContext.get();
        this.backtraceDatabaseFileContext.removeOrphaned(records);
    }

    @Override
    public boolean validConsistency() {
        return this.backtraceDatabaseFileContext.validFileConsistency();
    }

    @Override
    public BacktraceDatabaseRecord add(BacktraceReport backtraceReport, Map<String, Object> attributes) {
        return this.add(backtraceReport, attributes, false);
    }

    @Override
    public BacktraceDatabaseRecord add(BacktraceReport backtraceReport, Map<String, Object> attributes, boolean isProguardEnabled) {
        if (!this._enable || backtraceReport == null) {
            return null;
        }
        boolean validationResult = this.validateDatabaseSize();
        if (!validationResult) {
            return null;
        }
        BacktraceData data = backtraceReport.toBacktraceData(this._applicationContext, attributes, isProguardEnabled);
        return this.backtraceDatabaseContext.add(data);
    }

    @Override
    public Iterable<BacktraceDatabaseRecord> get() {
        if (this.backtraceDatabaseContext == null) {
            return null;
        }
        return this.backtraceDatabaseContext.get();
    }

    @Override
    public void delete(BacktraceDatabaseRecord record) {
        if (this.backtraceDatabaseContext == null) {
            return;
        }
        this.backtraceDatabaseContext.delete(record);
    }

    public int count() {
        return this.backtraceDatabaseContext.count();
    }

    private void loadReports() {
        Iterable<File> files = this.backtraceDatabaseFileContext.getRecords();
        for (File file : files) {
            BacktraceDatabaseRecord record = BacktraceDatabaseRecord.readFromFile(file);
            if (record == null) continue;
            if (!record.valid()) {
                record.delete();
                continue;
            }
            this.backtraceDatabaseContext.add(record);
            this.validateDatabaseSize();
            record.close();
        }
    }

    private boolean validateDatabaseSize() {
        if (this.backtraceDatabaseContext.count() + 1 > this.databaseSettings.getMaxRecordCount() && this.databaseSettings.getMaxRecordCount() != 0 && !this.backtraceDatabaseContext.removeOldestRecord()) {
            BacktraceLogger.e(this.LOG_TAG, "Can't remove last record. Database size is invalid");
            return false;
        }
        if (this.databaseSettings.getMaxDatabaseSize() != 0L && this.backtraceDatabaseContext.getDatabaseSize() > this.databaseSettings.getMaxDatabaseSize()) {
            int deletePolicyRetry = 5;
            while (this.backtraceDatabaseContext.getDatabaseSize() > this.databaseSettings.getMaxDatabaseSize()) {
                this.backtraceDatabaseContext.removeOldestRecord();
                if (--deletePolicyRetry != 0) continue;
            }
            return deletePolicyRetry != 0;
        }
        return true;
    }

    @Override
    public long getDatabaseSize() {
        return this.backtraceDatabaseContext.getDatabaseSize();
    }
}

