/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.extended_mockito.util;

public class StringUtil {
    public static boolean containsAll(Object whole, CharSequence ... parts) {
        if (StringUtil.anyIsNull(whole, parts)) {
            return false;
        }
        for (CharSequence part : parts) {
            if (null == part) {
                return false;
            }
            if (whole.toString().contains(part)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOneOrMoreOf(Object whole, CharSequence ... parts) {
        if (StringUtil.anyIsNull(whole, parts)) {
            return false;
        }
        for (CharSequence part : parts) {
            if (null == part || !whole.toString().contains(part)) continue;
            return true;
        }
        return false;
    }

    public static String charSequenceArrayToString(CharSequence ... seq) {
        if (null == seq) {
            return "null";
        }
        return "[" + String.join((CharSequence)",", seq) + "]";
    }

    public static <T> String arrayToString(T[] items, String delimiter) {
        if (null == items) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        for (T cur : items) {
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            buf.append(cur.toString());
        }
        return buf.toString();
    }

    private static boolean anyIsNull(Object ... args) {
        for (Object arg : args) {
            if (null != arg) continue;
            return true;
        }
        return false;
    }
}

