/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.extended_mockito;

import com.github.aro_tech.extended_mockito.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.mockito.ArgumentMatcher;

public class LenientOrderListMatcher<T>
implements ArgumentMatcher<List<T>> {
    private final T[] items;

    @SafeVarargs
    LenientOrderListMatcher(T ... items) {
        this.items = items;
    }

    public boolean matches(List<T> argument) {
        if (null != argument) {
            List<T> receivedList = argument;
            if (null == this.items) {
                return this.receivedListContainsOneNullItem(receivedList);
            }
            if (this.items.length == receivedList.size()) {
                return this.containsSameItemsInAnyOrder(receivedList, this.items);
            }
        }
        return false;
    }

    private boolean containsSameItemsInAnyOrder(List<T> receivedList, T ... items) {
        HashSet<T> expected = new HashSet<T>(Arrays.asList(items));
        for (T received : receivedList) {
            if (expected.contains(received)) continue;
            return false;
        }
        return true;
    }

    private boolean receivedListContainsOneNullItem(List<T> receivedList) {
        return receivedList.size() == 1 && null == receivedList.get(0);
    }

    public String toString() {
        return "[List in any order of: " + StringUtil.arrayToString(this.items, ", ") + "]";
    }
}

