/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.shaded.org.apache.http.impl.conn;

import com.github.vfss3.shaded.org.apache.http.HttpResponse;
import com.github.vfss3.shaded.org.apache.http.HttpResponseFactory;
import com.github.vfss3.shaded.org.apache.http.annotation.Contract;
import com.github.vfss3.shaded.org.apache.http.annotation.ThreadingBehavior;
import com.github.vfss3.shaded.org.apache.http.config.MessageConstraints;
import com.github.vfss3.shaded.org.apache.http.impl.DefaultHttpResponseFactory;
import com.github.vfss3.shaded.org.apache.http.impl.conn.DefaultHttpResponseParser;
import com.github.vfss3.shaded.org.apache.http.io.HttpMessageParser;
import com.github.vfss3.shaded.org.apache.http.io.HttpMessageParserFactory;
import com.github.vfss3.shaded.org.apache.http.io.SessionInputBuffer;
import com.github.vfss3.shaded.org.apache.http.message.BasicLineParser;
import com.github.vfss3.shaded.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

