/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.shaded.com.amazonaws.transform;

import com.github.vfss3.shaded.com.amazonaws.AmazonServiceException;
import com.github.vfss3.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.github.vfss3.shaded.com.amazonaws.annotation.ThreadSafe;
import com.github.vfss3.shaded.com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.github.vfss3.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.github.vfss3.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.github.vfss3.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.github.vfss3.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(new PropertyNamingStrategy.PascalCaseStrategy());
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        return (AmazonServiceException)MAPPER.treeToValue(jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }
}

