/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.shaded.com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.github.vfss3.shaded.com.amazonaws.services.kms.AWSKMS;
import com.github.vfss3.shaded.com.amazonaws.services.s3.internal.S3Direct;
import com.github.vfss3.shaded.com.amazonaws.services.s3.internal.crypto.ContentCryptoMaterial;
import com.github.vfss3.shaded.com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.github.vfss3.shaded.com.amazonaws.services.s3.internal.crypto.S3CryptoModuleAE;
import com.github.vfss3.shaded.com.amazonaws.services.s3.internal.crypto.S3ObjectWrapper;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.CryptoConfiguration;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.CryptoMode;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.EncryptionMaterialsProvider;

class S3CryptoModuleAEStrict
extends S3CryptoModuleAE {
    S3CryptoModuleAEStrict(AWSKMS kms, S3Direct s3, AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(kms, s3, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
        if (cryptoConfig.getCryptoMode() != CryptoMode.StrictAuthenticatedEncryption) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected final boolean isStrict() {
        return true;
    }

    @Override
    protected void securityCheck(ContentCryptoMaterial cekMaterial, S3ObjectWrapper retrieved) {
        if (!ContentCryptoScheme.AES_GCM.equals(cekMaterial.getContentCryptoScheme())) {
            throw new SecurityException("S3 object [bucket: " + retrieved.getBucketName() + ", key: " + retrieved.getKey() + "] not encrypted using authenticated encryption");
        }
    }
}

