/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.shaded.com.amazonaws.http.apache.client.impl;

import com.github.vfss3.shaded.com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import com.github.vfss3.shaded.com.amazonaws.util.IOUtils;
import com.github.vfss3.shaded.org.apache.http.Header;
import com.github.vfss3.shaded.org.apache.http.HttpEntity;
import com.github.vfss3.shaded.org.apache.http.HttpException;
import com.github.vfss3.shaded.org.apache.http.HttpResponse;
import com.github.vfss3.shaded.org.apache.http.HttpResponseInterceptor;
import com.github.vfss3.shaded.org.apache.http.entity.HttpEntityWrapper;
import com.github.vfss3.shaded.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CRC32ChecksumResponseInterceptor
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpEntity entity = response.getEntity();
        Header[] headers = response.getHeaders("x-amz-crc32");
        if (entity == null || headers == null || headers.length == 0) {
            return;
        }
        HttpEntityWrapper crc32ResponseEntity = new HttpEntityWrapper(entity){
            private final InputStream content;
            {
                this.content = new CRC32ChecksumCalculatingInputStream(this.wrappedEntity.getContent());
            }

            @Override
            public InputStream getContent() throws IOException {
                return this.content;
            }

            @Override
            public void writeTo(OutputStream outstream) throws IOException {
                try {
                    IOUtils.copy(this.getContent(), outstream);
                }
                finally {
                    this.getContent().close();
                }
            }
        };
        response.setEntity(crc32ResponseEntity);
        context.setAttribute(CRC32ChecksumCalculatingInputStream.class.getName(), crc32ResponseEntity.getContent());
    }
}

