/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.parser;

import com.github.vfss3.S3FileName;
import com.github.vfss3.operations.PlatformFeatures;
import com.github.vfss3.parser.PlatformFeaturesImpl;
import com.github.vfss3.shaded.com.amazonaws.regions.Regions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class S3FileNameParser
extends AbstractFileNameParser {
    private static final String DEFAULT_SIGNING_REGION = "us-east-1";
    private static final String DEFAULT_ALIYUN_SIGNING_REGION = "cn-hangzhou";
    private final Log log = LogFactory.getLog(S3FileNameParser.class);
    private static final Pattern AWS_HOST_PATTERN = Pattern.compile("((?<bucket>[a-z0-9\\-]+)\\.)?s3[-.]((?<region>[a-z0-9\\-]+)\\.)?amazonaws\\.com");
    private static final Pattern YANDEX_HOST_PATTERN = Pattern.compile("((?<bucket>[a-z0-9\\-]+)\\.)?storage\\.yandexcloud\\.net");
    private static final Pattern MAIL_RU_HOST_PATTERN = Pattern.compile("((?<bucket>[a-z0-9\\-]+)\\.)?[ih]b\\.bizmrg\\.com");
    private static final Pattern ALIYUN_HOST_PATTERN = Pattern.compile("((?<bucket>[a-z0-9\\-]+)\\.)?oss(-(?<region>[a-z0-9\\-]+))?\\.aliyuncs\\.com");
    private static final Pattern ORACLE_HOST_PATTERN = Pattern.compile("(?<bucket>[a-z0-9\\-]+)\\.compat\\.objectstorage\\.(?<region>[a-z0-9\\-]+)\\.oraclecloud\\.com");
    private static final Pattern DIGITAL_OCEAN_HOST_PATTERN = Pattern.compile("(?<bucket>[a-z0-9\\-]+)\\.(?<region>[a-z0-9\\-]+)\\.digitaloceanspaces\\.com");
    private static final Pattern SBER_CLOUD_HOST_PATTERN = Pattern.compile("(?<bucket>[a-z0-9\\-]+)\\.obs\\.(?<region>[a-z0-9\\-]+)\\.hc\\.sbercloud\\.ru");
    private static final Pattern PATH = Pattern.compile("^/+(?<bucket>[^/]+)/*(?<key>/.*)?");

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        Matcher pathMatcher;
        URI uri;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Parse uri [base=" + base + ",filename=" + filename + "]"));
        }
        try {
            uri = new URI(filename.replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new FileSystemException((Throwable)e);
        }
        if (!uri.getScheme().equalsIgnoreCase("s3")) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{uri.getScheme(), filename});
        }
        if (uri.getHost() == null || uri.getHost().trim().length() == 0) {
            throw new FileSystemException("Not able to find host in url [" + filename + "]");
        }
        String accessKey = null;
        String secretKey = null;
        String region = null;
        if (uri.getUserInfo() != null && uri.getUserInfo().trim().length() != 0) {
            String[] info = uri.getUserInfo().split(":");
            if (info.length != 2 && info.length != 3) {
                throw new FileSystemException("Wrong user info inside url [" + filename + "]");
            }
            accessKey = info[0];
            secretKey = info[1];
            String string = region = info.length == 3 ? info[2] : null;
        }
        if (base != null) {
            S3FileName file = this.buildS3FileName(base, filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("From [base=" + base + ",file=" + filename + "] got " + file));
            }
            return file;
        }
        Matcher hostNameMatcher = AWS_HOST_PATTERN.matcher(uri.getHost());
        if (hostNameMatcher.matches()) {
            region = region == null ? hostNameMatcher.group("region") : region;
            this.checkRegion(region);
            String bucket = hostNameMatcher.group("bucket");
            String host = uri.getHost();
            String key = uri.getPath();
            if (bucket != null && bucket.trim().length() > 0) {
                host = region != null && region.trim().length() > 0 ? "s3-" + region + ".amazonaws.com" : "s3.amazonaws.com";
            } else {
                Matcher pathMatcher2 = PATH.matcher(uri.getPath());
                if (pathMatcher2.matches()) {
                    String pathBucket = pathMatcher2.group("bucket");
                    if (pathBucket != null && pathBucket.trim().length() > 0) {
                        bucket = pathMatcher2.group("bucket");
                    }
                    key = pathMatcher2.group("key");
                }
            }
            if (bucket == null || bucket.trim().length() == 0) {
                throw new FileSystemException("Not able to find bucket inside [" + filename + "]");
            }
            if (region == null) {
                region = DEFAULT_SIGNING_REGION;
            }
            S3FileName file = this.buildS3FileName(host, null, bucket, bucket, region, key, accessKey, secretKey, new PlatformFeaturesImpl(true, true, true, true, true));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("From uri " + filename + " got " + file));
            }
            return file;
        }
        hostNameMatcher = YANDEX_HOST_PATTERN.matcher(uri.getHost());
        if (hostNameMatcher.matches()) {
            String key;
            String bucket = hostNameMatcher.group("bucket");
            if (bucket != null && bucket.trim().length() > 0) {
                key = uri.getPath();
            } else {
                Matcher pathMatcher3 = PATH.matcher(uri.getPath());
                if (pathMatcher3.matches()) {
                    bucket = pathMatcher3.group("bucket");
                    key = pathMatcher3.group("key");
                } else {
                    throw new FileSystemException("Not able to find bucket inside [" + filename + "]");
                }
            }
            S3FileName file = this.buildS3FileName("storage.yandexcloud.net", bucket, null, bucket, "ru-central1", key, accessKey, secretKey, new PlatformFeaturesImpl(false, true, false, true, true));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("From uri " + filename + " got " + file));
            }
            return file;
        }
        hostNameMatcher = MAIL_RU_HOST_PATTERN.matcher(uri.getHost());
        if (hostNameMatcher.matches()) {
            String key;
            String bucket = hostNameMatcher.group("bucket");
            if (bucket != null && bucket.trim().length() > 0) {
                key = uri.getPath();
            } else {
                Matcher pathMatcher4 = PATH.matcher(uri.getPath());
                if (pathMatcher4.matches()) {
                    bucket = pathMatcher4.group("bucket");
                    key = pathMatcher4.group("key");
                } else {
                    throw new FileSystemException("Not able to find bucket inside [" + filename + "]");
                }
            }
            S3FileName file = this.buildS3FileName("hb.bizmrg.com", null, bucket, bucket, "ru-msk", key, accessKey, secretKey, new PlatformFeaturesImpl(true, false, false, true, true));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("From uri " + filename + " got " + file));
            }
            return file;
        }
        hostNameMatcher = ALIYUN_HOST_PATTERN.matcher(uri.getHost());
        if (hostNameMatcher.matches()) {
            region = region == null ? hostNameMatcher.group("region") : region;
            String host = uri.getHost();
            String bucket = hostNameMatcher.group("bucket");
            if (bucket == null || bucket.trim().length() == 0) {
                throw new FileSystemException("Path-style URLs are not supported on Aliyun Object Storage Service  [" + filename + "]");
            }
            host = host.substring(bucket.length() + 1);
            S3FileName file = this.buildS3FileName(host, null, null, bucket, region != null ? region : DEFAULT_ALIYUN_SIGNING_REGION, uri.getPath(), accessKey, secretKey, new PlatformFeaturesImpl(true, false, true, false, true));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("From uri " + filename + " got " + file));
            }
            return file;
        }
        hostNameMatcher = ORACLE_HOST_PATTERN.matcher(uri.getHost());
        if (hostNameMatcher.matches()) {
            region = region == null ? hostNameMatcher.group("region") : region;
            String host = uri.getHost();
            String namespace = hostNameMatcher.group("bucket");
            if (namespace == null || namespace.trim().length() == 0) {
                throw new FileSystemException("Virtual host style URLs are not supported on Oracle Cloud Storage Service  [" + filename + "]");
            }
            Matcher pathMatcher5 = PATH.matcher(uri.getPath());
            if (!pathMatcher5.matches()) {
                throw new FileSystemException("Not able to find bucket inside [" + filename + "]");
            }
            String bucket = pathMatcher5.group("bucket");
            String key = pathMatcher5.group("key");
            S3FileName file = this.buildS3FileName(host, null, bucket, bucket, region, key, accessKey, secretKey, new PlatformFeaturesImpl(false, false, false, false, false));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("From uri " + filename + " got " + file));
            }
            return file;
        }
        hostNameMatcher = DIGITAL_OCEAN_HOST_PATTERN.matcher(uri.getHost());
        if (hostNameMatcher.matches()) {
            region = region == null ? hostNameMatcher.group("region") : region;
            String host = uri.getHost();
            String bucket = hostNameMatcher.group("bucket");
            if (bucket == null || bucket.trim().length() == 0) {
                throw new FileSystemException("Path-style URLs are not supported on Digital Ocean Spaces [" + filename + "]");
            }
            host = host.substring(bucket.length() + 1);
            S3FileName file = this.buildS3FileName(host, null, null, bucket, region, uri.getPath(), accessKey, secretKey, new PlatformFeaturesImpl(true, true, false, true, true));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("From uri " + filename + " got " + file));
            }
            return file;
        }
        hostNameMatcher = SBER_CLOUD_HOST_PATTERN.matcher(uri.getHost());
        if (hostNameMatcher.matches()) {
            region = region == null ? hostNameMatcher.group("region") : region;
            String host = uri.getHost();
            String bucket = hostNameMatcher.group("bucket");
            if (bucket == null || bucket.trim().length() == 0) {
                throw new FileSystemException("Path-style URLs are not supported on SberCloud [" + filename + "]");
            }
            host = host.substring(bucket.length() + 1);
            S3FileName file = this.buildS3FileName(host, null, null, bucket, region, uri.getPath(), accessKey, secretKey, new PlatformFeaturesImpl(true, true, false, true, true));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("From uri " + filename + " got " + file));
            }
            return file;
        }
        StringBuilder host = new StringBuilder(uri.getHost());
        if (uri.getPort() != -1) {
            host.append(':').append(uri.getPort());
        }
        if ((pathMatcher = PATH.matcher(uri.getPath())).matches()) {
            S3FileName file = this.buildS3FileName(host.toString(), null, pathMatcher.group("bucket"), pathMatcher.group("bucket"), region != null ? region : DEFAULT_SIGNING_REGION, pathMatcher.group("key"), accessKey, secretKey, new PlatformFeaturesImpl(true, true, false, true, true));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("From uri " + filename + " got " + file));
            }
            return file;
        }
        throw new FileSystemException("Not able to find bucket inside [" + filename + "]");
    }

    private void checkRegion(String regionName) throws FileSystemException {
        if (regionName != null && regionName.trim().length() > 0) {
            try {
                Objects.requireNonNull(Regions.fromName(regionName));
            }
            catch (IllegalArgumentException e) {
                throw new FileSystemException("Not able to parse region [" + regionName + "]");
            }
        }
    }

    private S3FileName buildS3FileName(FileName base, String key) {
        S3FileName s3Base = (S3FileName)base;
        return s3Base.createName(key.substring(s3Base.getRootURI().length()), FileType.IMAGINARY);
    }

    private S3FileName buildS3FileName(String endpoint, String urlPrefix, String pathPrefix, String bucket, String signingRegion, String key, String accessKey, String secretKey, PlatformFeatures features) throws FileSystemException {
        if (key == null || key.trim().length() == 0) {
            key = "/";
        }
        if (!key.equals("/")) {
            StringBuilder sb = new StringBuilder(key);
            UriParser.fixSeparators((StringBuilder)sb);
            UriParser.normalisePath((StringBuilder)sb);
            key = sb.toString();
        }
        FileType type = "/".equals(key) ? FileType.FOLDER : FileType.IMAGINARY;
        return new S3FileName(endpoint, urlPrefix, pathPrefix, bucket, signingRegion, key, type, accessKey, secretKey, features);
    }
}

