/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.operations;

import com.github.vfss3.S3FileObject;
import com.github.vfss3.operations.ServerSideEncryption;
import org.apache.commons.vfs2.FileSystemException;

class ServerSideEncryptionImpl
implements ServerSideEncryption {
    private final S3FileObject file;

    ServerSideEncryptionImpl(S3FileObject file) {
        this.file = file;
    }

    @Override
    public boolean noEncryption() throws FileSystemException {
        return !this.file.getSSEAlgorithm().isPresent();
    }

    @Override
    public boolean encryptedWith(String algorithm) throws FileSystemException {
        return this.file.getSSEAlgorithm().filter(a -> a.equals(algorithm)).isPresent();
    }

    public void process() throws FileSystemException {
    }
}

