/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.operations;

import com.github.vfss3.S3FileObject;
import com.github.vfss3.operations.AclGetter;
import com.github.vfss3.operations.AclSetter;
import com.github.vfss3.operations.IAclGetter;
import com.github.vfss3.operations.IAclSetter;
import com.github.vfss3.operations.IMD5HashGetter;
import com.github.vfss3.operations.IPublicUrlsGetter;
import com.github.vfss3.operations.MD5HashGetter;
import com.github.vfss3.operations.MockServerSideEncryption;
import com.github.vfss3.operations.PlatformFeatures;
import com.github.vfss3.operations.PublicUrlsGetter;
import com.github.vfss3.operations.ServerSideEncryption;
import com.github.vfss3.operations.ServerSideEncryptionImpl;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.operations.FileOperation;
import org.apache.commons.vfs2.operations.FileOperationProvider;

public class S3FileOperationsProvider
implements FileOperationProvider {
    public void collectOperations(Collection<Class<? extends FileOperation>> operationsList, FileObject file) {
        if (file instanceof S3FileObject) {
            operationsList.add(IAclGetter.class);
            operationsList.add(IAclSetter.class);
            operationsList.add(IPublicUrlsGetter.class);
            operationsList.add(IMD5HashGetter.class);
            operationsList.add(ServerSideEncryption.class);
            operationsList.add(PlatformFeatures.class);
        }
    }

    public FileOperation getOperation(FileObject file, Class<? extends FileOperation> operationClass) throws FileSystemException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(operationClass);
        if (file instanceof S3FileObject) {
            S3FileObject s3file = (S3FileObject)file;
            if (operationClass.equals(IAclGetter.class)) {
                return new AclGetter(s3file);
            }
            if (operationClass.equals(IAclSetter.class)) {
                return new AclSetter(s3file);
            }
            if (operationClass.equals(IPublicUrlsGetter.class)) {
                return new PublicUrlsGetter(s3file);
            }
            if (operationClass.equals(IMD5HashGetter.class)) {
                return new MD5HashGetter(s3file);
            }
            if (operationClass.equals(ServerSideEncryption.class)) {
                if (s3file.getName().getPlatformFeatures().supportsServerSideEncryption()) {
                    return new ServerSideEncryptionImpl(s3file);
                }
                return new MockServerSideEncryption();
            }
            if (operationClass.equals(PlatformFeatures.class)) {
                return s3file.getName().getPlatformFeatures();
            }
        }
        throw new FileSystemException("Operation " + operationClass.getName() + " is not provided for file " + file.getName());
    }
}

