/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.operations;

import com.github.vfss3.S3FileObject;
import com.github.vfss3.S3FileSystemOptions;
import com.github.vfss3.operations.IPublicUrlsGetter;
import org.apache.commons.vfs2.FileSystemException;

class PublicUrlsGetter
implements IPublicUrlsGetter {
    private final S3FileObject file;

    public PublicUrlsGetter(S3FileObject file) {
        this.file = file;
    }

    @Override
    public String getHttpUrl() {
        S3FileSystemOptions options = new S3FileSystemOptions(this.file.getFileSystem().getFileSystemOptions());
        return this.file.getName().getURI().replaceFirst("^s3://", options.isUseHttps() ? "https://" : "http://");
    }

    @Override
    public String getSignedUrl(int expireInSeconds) throws FileSystemException {
        return this.file.getSignedUrl(expireInSeconds);
    }

    public void process() throws FileSystemException {
    }
}

