/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.operations;

import com.github.vfss3.S3FileObject;
import com.github.vfss3.operations.Acl;
import com.github.vfss3.operations.IAclGetter;
import org.apache.commons.vfs2.FileSystemException;

class AclGetter
implements IAclGetter {
    private S3FileObject file;
    private Acl acl;
    private boolean initialized = false;

    public AclGetter(S3FileObject file) {
        this.file = file;
    }

    @Override
    public boolean canRead(Acl.Group group) {
        if (!this.initialized) {
            throw new IllegalStateException("Call IAclGetter::process() method before using this object");
        }
        return this.acl.isAllowed(group, Acl.Permission.READ);
    }

    @Override
    public boolean canWrite(Acl.Group group) {
        if (!this.initialized) {
            throw new IllegalStateException("Call IAclGetter::process() method before using this object");
        }
        return this.acl.isAllowed(group, Acl.Permission.WRITE);
    }

    @Override
    public Acl getAcl() {
        if (!this.initialized) {
            throw new IllegalStateException("Call IAclGetter::process() method before using this object");
        }
        return this.acl;
    }

    @Override
    public void process() throws FileSystemException {
        this.initialized = true;
        this.acl = this.file.getAcl();
    }
}

