/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Acl {
    private int groupsCount = Group.values().length;
    private int rulesCount = Permission.values().length;
    private byte[][] rulesTable = new byte[this.groupsCount][this.rulesCount];
    private Map<Group, Permission[]> rules;
    private boolean changed = true;

    public Acl() {
        this(null);
    }

    public Acl(Map<Group, Permission[]> rules) {
        if (rules != null) {
            this.setRules(rules);
        } else {
            this.denyAll();
        }
    }

    public void allow(Group group, Permission permission) {
        this.setRule(group, permission, (byte)1);
    }

    public void allow(Group group, Permission[] permission_list) {
        this.setRule(group, permission_list, (byte)1);
    }

    public void allow(Group group) {
        this.setRule(group, (byte)1);
    }

    public void allow(Permission permission) {
        this.setRule(permission, (byte)1);
    }

    public void allow(Permission[] permission_list) {
        this.setRule(permission_list, (byte)1);
    }

    public void allowAll() {
        this.setRule((byte)1);
    }

    public void deny(Group group, Permission permission) {
        this.setRule(group, permission, (byte)0);
    }

    public void deny(Group group, Permission[] permission_list) {
        this.setRule(group, permission_list, (byte)0);
    }

    public void deny(Group group) {
        this.setRule(group, (byte)0);
    }

    public void deny(Permission permission) {
        this.setRule(permission, (byte)0);
    }

    public void deny(Permission[] permission) {
        this.setRule(permission, (byte)0);
    }

    public void denyAll() {
        this.setRule((byte)0);
    }

    public boolean isAllowed(Group group, Permission permission) {
        return this.rulesTable[group.ordinal()][permission.ordinal()] == 1;
    }

    public boolean isDenied(Group group, Permission permission) {
        return this.rulesTable[group.ordinal()][permission.ordinal()] == 0;
    }

    public void setRules(Map<Group, Permission[]> rules) {
        this.denyAll();
        for (Group group : rules.keySet()) {
            Permission[] permissions = rules.get((Object)group);
            this.allow(group, permissions);
        }
    }

    public Map<Group, Permission[]> getRules() {
        if (this.changed) {
            HashMap<Group, Permission[]> result = new HashMap<Group, Permission[]>(this.groupsCount);
            Permission[] rightValues = Permission.values();
            for (Group group : Group.values()) {
                int groupIndex = group.ordinal();
                ArrayList<Permission> permissions = new ArrayList<Permission>(this.rulesCount);
                for (int i = 0; i < this.rulesCount; ++i) {
                    if (this.rulesTable[groupIndex][i] != 1) continue;
                    permissions.add(rightValues[i]);
                }
                result.put(group, permissions.toArray(new Permission[permissions.size()]));
            }
            this.rules = result;
        }
        return this.rules;
    }

    private void setRule(Group group, Permission permission, byte allow) {
        this.rulesTable[group.ordinal()][permission.ordinal()] = allow;
        this.changed = true;
    }

    private void setRule(Group group, Permission[] permissions, byte allow) {
        int groupIndex = group.ordinal();
        for (Permission permission : permissions) {
            this.rulesTable[groupIndex][permission.ordinal()] = allow;
        }
        this.changed = true;
    }

    private void setRule(Group group, byte allow) {
        int groupIndex = group.ordinal();
        for (int i = 0; i < this.rulesCount; ++i) {
            this.rulesTable[groupIndex][i] = allow;
        }
        this.changed = true;
    }

    private void setRule(Permission permission, byte allow) {
        int i = permission.ordinal();
        for (int j = 0; j < this.groupsCount; ++j) {
            this.rulesTable[j][i] = allow;
        }
    }

    private void setRule(Permission[] permissions, byte allow) {
        for (Permission permission : permissions) {
            int i = permission.ordinal();
            for (int j = 0; j < this.groupsCount; ++j) {
                this.rulesTable[j][i] = allow;
            }
        }
    }

    private void setRule(byte allow) {
        for (int j = 0; j < this.groupsCount; ++j) {
            for (int i = 0; i < this.rulesCount; ++i) {
                this.rulesTable[j][i] = allow;
            }
        }
        this.changed = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Group, Permission[]> entry : this.getRules().entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(Arrays.toString((Object[])entry.getValue())).append(',');
        }
        return "Acl{rules={" + sb.toString() + "}}";
    }

    public static enum Group {
        OWNER,
        AUTHORIZED,
        EVERYONE;

    }

    public static enum Permission {
        READ,
        WRITE;

    }
}

