/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.github.vfss3.S3FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;

public class S3FileSystemOptions {
    public static final String PREFIX = "s3";
    private final FileSystemOptions options;

    public S3FileSystemOptions() {
        this(null);
    }

    public S3FileSystemOptions(FileSystemOptions options) {
        this(options, true);
    }

    public S3FileSystemOptions(FileSystemOptions options, boolean cloneOptions) {
        this.options = options != null ? (cloneOptions ? (FileSystemOptions)options.clone() : options) : new FileSystemOptions();
    }

    public void setServerSideEncryption(boolean serverSideEncryption) {
        S3FileSystemConfigBuilder.getInstance().setServerSideEncryption(this.options, serverSideEncryption);
    }

    public boolean getServerSideEncryption() {
        return S3FileSystemConfigBuilder.getInstance().getServerSideEncryption(this.options);
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        S3FileSystemConfigBuilder.getInstance().setClientConfiguration(this.options, clientConfiguration);
    }

    public ClientConfiguration getClientConfiguration() {
        return S3FileSystemConfigBuilder.getInstance().getClientConfiguration(this.options);
    }

    public void setDisableChunkedEncoding(boolean disableChunkedEncoding) {
        S3FileSystemConfigBuilder.getInstance().setDisableChunkedEncoding(this.options, disableChunkedEncoding);
    }

    public boolean isDisableChunkedEncoding() {
        return S3FileSystemConfigBuilder.getInstance().getDisableChunkedEncoding(this.options);
    }

    public boolean isUseHttps() {
        return S3FileSystemConfigBuilder.getInstance().isUseHttps(this.options);
    }

    public void setUseHttps(boolean useHttps) {
        S3FileSystemConfigBuilder.getInstance().setUseHttps(this.options, useHttps);
    }

    public boolean isCreateBucket() {
        return S3FileSystemConfigBuilder.getInstance().isCreateBucket(this.options);
    }

    public void setCreateBucket(boolean createBucket) {
        S3FileSystemConfigBuilder.getInstance().setCreateBucket(this.options, createBucket);
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return S3FileSystemConfigBuilder.getInstance().getCredentialsProvider(this.options);
    }

    public void setCredentialsProvider(AWSCredentialsProvider provider) {
        S3FileSystemConfigBuilder.getInstance().setCredentialsProvider(this.options, provider);
    }

    public FileSystemOptions toFileSystemOptions() {
        return (FileSystemOptions)this.options.clone();
    }

    public String toString() {
        return this.options.toString();
    }
}

