/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.github.vfss3.S3FileSystem;
import java.util.Objects;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;

public class S3FileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String SERVER_SIDE_ENCRYPTION = "serverSideEncryption";
    private static final String CLIENT_CONFIGURATION = "clientConfiguration";
    private static final String DISABLE_CHUNKED_ENCODING = "disableChunkedEncoding";
    private static final String USE_HTTPS = "useHttps";
    private static final String CREATE_BUCKET = "createBucket";
    private static final String CREDENTIALS_PROVIDER = "credentialsProvider";
    private static final int DEFAULT_MAX_ERROR_RETRY = 8;
    private static final S3FileSystemConfigBuilder BUILDER = new S3FileSystemConfigBuilder();

    public static S3FileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private S3FileSystemConfigBuilder() {
        super("s3.");
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return S3FileSystem.class;
    }

    void setOption(FileSystemOptions opts, String name, Object value) {
        this.setParam(opts, name, value);
    }

    Object getOption(FileSystemOptions opts, String name) {
        return this.getParam(opts, name);
    }

    boolean getBooleanOption(FileSystemOptions opts, String name, boolean defaultValue) {
        return this.getBoolean(opts, name, defaultValue);
    }

    String getStringOption(FileSystemOptions opts, String name, String defaultValue) {
        return this.getString(opts, name, defaultValue);
    }

    int getIntegerOption(FileSystemOptions opts, String name, int defaultValue) {
        return this.getInteger(opts, name, defaultValue);
    }

    public boolean getServerSideEncryption(FileSystemOptions opts) {
        return this.getBooleanOption(opts, SERVER_SIDE_ENCRYPTION, false);
    }

    public void setServerSideEncryption(FileSystemOptions opts, boolean serverSideEncryption) {
        this.setOption(opts, SERVER_SIDE_ENCRYPTION, serverSideEncryption);
    }

    public void setClientConfiguration(FileSystemOptions opts, ClientConfiguration clientConfiguration) {
        this.setOption(opts, CLIENT_CONFIGURATION, Objects.requireNonNull(clientConfiguration));
    }

    public ClientConfiguration getClientConfiguration(FileSystemOptions opts) {
        ClientConfiguration clientConfiguration = (ClientConfiguration)this.getOption(opts, CLIENT_CONFIGURATION);
        if (clientConfiguration == null) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setMaxErrorRetry(8);
        }
        return clientConfiguration;
    }

    public boolean getDisableChunkedEncoding(FileSystemOptions opts) {
        S3FileSystemConfigBuilder builder = new S3FileSystemConfigBuilder();
        return builder.getBooleanOption(opts, DISABLE_CHUNKED_ENCODING, false);
    }

    public void setDisableChunkedEncoding(FileSystemOptions opts, boolean disableChunkedEncoding) {
        S3FileSystemConfigBuilder builder = new S3FileSystemConfigBuilder();
        builder.setOption(opts, DISABLE_CHUNKED_ENCODING, disableChunkedEncoding);
    }

    public boolean isUseHttps(FileSystemOptions opts) {
        S3FileSystemConfigBuilder builder = new S3FileSystemConfigBuilder();
        return builder.getBooleanOption(opts, USE_HTTPS, true);
    }

    public void setUseHttps(FileSystemOptions opts, boolean useHttps) {
        S3FileSystemConfigBuilder builder = new S3FileSystemConfigBuilder();
        builder.setOption(opts, USE_HTTPS, useHttps);
    }

    public boolean isCreateBucket(FileSystemOptions opts) {
        S3FileSystemConfigBuilder builder = new S3FileSystemConfigBuilder();
        return builder.getBooleanOption(opts, CREATE_BUCKET, false);
    }

    public void setCreateBucket(FileSystemOptions opts, boolean createBucket) {
        S3FileSystemConfigBuilder builder = new S3FileSystemConfigBuilder();
        builder.setOption(opts, CREATE_BUCKET, createBucket);
    }

    public AWSCredentialsProvider getCredentialsProvider(FileSystemOptions opts) {
        S3FileSystemConfigBuilder builder = new S3FileSystemConfigBuilder();
        AWSCredentialsProvider provider = (AWSCredentialsProvider)builder.getOption(opts, CREDENTIALS_PROVIDER);
        return provider != null ? provider : new DefaultAWSCredentialsProviderChain();
    }

    public void setCredentialsProvider(FileSystemOptions opts, AWSCredentialsProvider provider) {
        S3FileSystemConfigBuilder builder = new S3FileSystemConfigBuilder();
        builder.setOption(opts, CREDENTIALS_PROVIDER, provider);
    }
}

