/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.github.vfss3.AbstractFileSystem;
import com.github.vfss3.S3FileName;
import com.github.vfss3.S3FileObject;
import com.github.vfss3.S3FileProvider;
import com.github.vfss3.S3FileSystemOptions;
import com.github.vfss3.shaded.com.amazonaws.AmazonServiceException;
import com.github.vfss3.shaded.com.amazonaws.services.s3.AmazonS3;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.Bucket;
import com.github.vfss3.shaded.com.amazonaws.services.s3.transfer.TransferManager;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class S3FileSystem
extends AbstractFileSystem {
    private final Log log = LogFactory.getLog(this.getClass());
    private AmazonS3 service;
    private TransferManager transferManager;
    private final Bucket bucket;

    S3FileSystem(S3FileName rootName, S3FileSystemOptions options, TransferManager transferManager) throws FileSystemException {
        super(rootName, null, options.toFileSystemOptions());
        this.transferManager = transferManager;
        this.service = transferManager.getAmazonS3Client();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Init new S3 FileSystem [root=" + rootName + ",opts=" + options + "]"));
        }
        try {
            if (options.isCreateBucket() && !this.doesBucketExist(rootName.getBucket())) {
                this.bucket = this.service.createBucket(rootName.getBucket());
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Created new bucket [" + this.bucket + "]"));
                }
            } else {
                this.bucket = new Bucket(rootName.getBucket());
            }
        }
        catch (AmazonServiceException e) {
            String s3message = e.getMessage();
            if (s3message != null) {
                throw new FileSystemException(s3message, (Throwable)e);
            }
            throw new FileSystemException((Throwable)e);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(S3FileProvider.capabilities);
    }

    AmazonS3 getService() {
        return this.service;
    }

    TransferManager getTransferManager() {
        return this.transferManager;
    }

    @Override
    protected FileObject createFile(FileName fileName) throws Exception {
        S3FileObject s3FileObject = new S3FileObject((S3FileName)fileName, this);
        return s3FileObject;
    }

    @Override
    protected void doCloseCommunicationLink() {
        if (this.transferManager != null) {
            this.transferManager.shutdownNow(true);
            this.service = null;
            this.transferManager = null;
        }
    }

    private boolean doesBucketExist(String bucketName) throws FileSystemException {
        try {
            return this.service.doesBucketExistV2(bucketName);
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 403) {
                throw new FileSystemException("vfs.provider.s3/connection-forbidden.error", (Object)bucketName, (Throwable)e);
            }
            if (e.getStatusCode() == 301) {
                return true;
            }
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw new FileSystemException((Throwable)e);
        }
    }
}

