/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.github.vfss3.CachingFileProvider;
import com.github.vfss3.S3FileName;
import com.github.vfss3.S3FileSystem;
import com.github.vfss3.S3FileSystemConfigBuilder;
import com.github.vfss3.S3FileSystemOptions;
import com.github.vfss3.parser.S3FileNameParser;
import com.github.vfss3.shaded.com.amazonaws.auth.BasicAWSCredentials;
import com.github.vfss3.shaded.com.amazonaws.client.builder.AwsClientBuilder;
import com.github.vfss3.shaded.com.amazonaws.services.s3.AmazonS3;
import com.github.vfss3.shaded.com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.github.vfss3.shaded.com.amazonaws.services.s3.transfer.TransferManager;
import com.github.vfss3.shaded.com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.FileNameParser;

public class S3FileProvider
extends CachingFileProvider {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT));

    public S3FileProvider() {
        this.setFileNameParser((FileNameParser)new S3FileNameParser());
    }

    @Override
    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        S3FileName root = (S3FileName)fileName;
        S3FileSystemOptions options = new S3FileSystemOptions(fileSystemOptions);
        AmazonS3ClientBuilder clientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(options.getClientConfiguration());
        if (root.hasCredentials()) {
            clientBuilder.withCredentials(new AWSStaticCredentialsProvider(new BasicAWSCredentials(root.getAccessKey(), root.getSecretKey())));
        } else {
            clientBuilder.withCredentials(options.getCredentialsProvider());
        }
        if (options.isDisableChunkedEncoding()) {
            clientBuilder.disableChunkedEncoding();
        }
        if (root.hasPathPrefix()) {
            clientBuilder.enablePathStyleAccess();
        }
        if (options.getServerSideEncryption() && !root.getPlatformFeatures().supportsServerSideEncryption()) {
            this.log.warn((Object)"Try to use Server-Side Encryption with cloud that doesn't support it");
        }
        StringBuilder endpoint = new StringBuilder();
        if (options.isUseHttps()) {
            endpoint.append("https://");
        } else {
            endpoint.append("http://");
        }
        endpoint.append(root.getEndpoint());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Endpoint configuration [endpoint=" + endpoint + ",region=" + root.getSigningRegion() + "]"));
        }
        clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint.toString(), root.getSigningRegion()));
        TransferManager transferManager = TransferManagerBuilder.standard().withS3Client((AmazonS3)clientBuilder.build()).build();
        return new S3FileSystem(root, options, transferManager);
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return S3FileSystemConfigBuilder.getInstance();
    }
}

