/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.github.vfss3.AbstractFileObject;
import com.github.vfss3.FileObjectUtils;
import com.github.vfss3.ObjectContentHolder;
import com.github.vfss3.ObjectMetadataHolder;
import com.github.vfss3.S3FileName;
import com.github.vfss3.S3FileSystem;
import com.github.vfss3.S3FileSystemOptions;
import com.github.vfss3.operations.Acl;
import com.github.vfss3.shaded.com.amazonaws.AmazonClientException;
import com.github.vfss3.shaded.com.amazonaws.AmazonServiceException;
import com.github.vfss3.shaded.com.amazonaws.services.s3.AmazonS3;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.AccessControlList;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.AmazonS3Exception;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.CanonicalGrantee;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.CopyObjectRequest;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.Grant;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.Grantee;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.GroupGrantee;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.ListObjectsRequest;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.ObjectListing;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.Owner;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.Permission;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.S3Object;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import com.github.vfss3.shaded.com.amazonaws.services.s3.transfer.TransferManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;

public class S3FileObject
extends AbstractFileObject<S3FileSystem> {
    private final Log log = LogFactory.getLog(this.getClass());
    private ObjectMetadataHolder objectMetadataHolder;
    private ObjectContentHolder objectContentHolder;

    public S3FileObject(S3FileName fileName, S3FileSystem fileSystem) {
        super(fileName, fileSystem);
    }

    @Override
    public boolean isAttached() {
        return this.objectMetadataHolder != null;
    }

    @Override
    public void setAttached(boolean attached) {
        if (attached && this.objectMetadataHolder == null || !attached && this.objectMetadataHolder != null) {
            throw new IllegalStateException("Wrong usage of 'attached' property");
        }
    }

    @Override
    protected void doAttach() throws FileSystemException {
        if (this.getName().getPath().equals("/")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attach S3FileObject to the bucket " + this.getName()));
            }
            this.doAttachVirtualFolder();
            return;
        }
        try {
            String candidateKey = this.getName().getS3KeyAs(FileType.FILE);
            this.doAttach(FileType.FILE, new ObjectMetadataHolder(this.getService().getObjectMetadata(this.getBucketName(), candidateKey)));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attach file to S3 Object " + this.getName()));
            }
            return;
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 403) {
                this.doAttach(FileType.FILE, new ObjectMetadataHolder());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Attach to forbidden S3 object " + this.getName()));
                }
                return;
            }
            try {
                String candidateKey = this.getName().getS3KeyAs(FileType.FOLDER);
                this.doAttach(FileType.FOLDER, new ObjectMetadataHolder(this.getService().getObjectMetadata(this.getBucketName(), candidateKey)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Attach folder to S3 Object " + this.getName()));
                }
                return;
            }
            catch (AmazonServiceException candidateKey) {
                try {
                    String candidateKey2 = this.getName().getS3KeyAs(FileType.FOLDER);
                    ObjectListing listing = this.getService().listObjects(new ListObjectsRequest().withBucketName(this.getBucketName()).withPrefix(candidateKey2).withMaxKeys(1));
                    if (!listing.getObjectSummaries().isEmpty()) {
                        this.doAttachVirtualFolder();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Attach folder to virtual S3 folder " + this.getName()));
                        }
                        return;
                    }
                }
                catch (AmazonServiceException amazonServiceException) {
                    // empty catch block
                }
                if (this.objectMetadataHolder == null) {
                    this.doAttach(null, new ObjectMetadataHolder());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Attach to empty S3 object " + this.getName()));
                    }
                }
                return;
            }
        }
    }

    protected final void doAttachVirtualFolder() throws FileSystemException {
        this.doAttach(FileType.FOLDER, new ObjectMetadataHolder().withZeroContentLength().withContentType(""));
    }

    protected void doAttach(FileType type, ObjectMetadataHolder metadata) throws FileSystemException {
        if (this.objectMetadataHolder != null) {
            throw new FileSystemException("Try to reattach file " + this.getName() + " without detach");
        }
        this.objectMetadataHolder = Objects.requireNonNull(metadata);
        if (type != null) {
            this.injectType(type);
        }
    }

    @Override
    protected void doDetach() throws FileSystemException {
        if (this.objectMetadataHolder == null) {
            throw new FileSystemException("Try to detach file " + this.getName() + " without attach");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Detach [" + this.getName() + "]"));
        }
        this.objectMetadataHolder = null;
    }

    @Override
    protected void doDelete() throws Exception {
        String bucket = this.getBucketName();
        String key = this.getName().getS3Key().orElseThrow(() -> new FileSystemException("Can't delete whole bucket"));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Delete object [bucket=" + bucket + ",name=" + key + "]"));
        }
        this.getService().deleteObject(bucket, key);
    }

    @Override
    protected void doCreateFolder() throws Exception {
        String key = this.getName().getS3KeyAs(FileType.FOLDER);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Create new folder in bucket [" + this.getBucketName() + "] with key [" + key + "]"));
        }
        if (!this.isAttached()) {
            throw new FileSystemException("Need to attach first");
        }
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        this.getService().putObject(new PutObjectRequest(this.getBucketName(), key, input, metadata));
    }

    @Override
    protected long doGetLastModifiedTime() {
        return this.objectMetadataHolder.getLastModified();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        if (this.objectContentHolder == null) {
            this.objectContentHolder = new ObjectContentHolder();
        }
        String objectPath = this.getName().getS3Key().orElseThrow(() -> new FileSystemException("Not able to get object path"));
        if (this.objectMetadataHolder.getContentLength() == 0L || !this.objectMetadataHolder.getMD5Hash().isPresent()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Try to get input stream from empty object [" + objectPath + "]. Return empty stream"));
            }
            return new ByteArrayInputStream(new byte[0]);
        }
        if (!this.objectContentHolder.sameData(this.objectMetadataHolder)) {
            S3Object obj = this.getService().getObject(this.getBucketName(), objectPath);
            this.objectContentHolder.populateData(obj.getObjectContent(), this.objectMetadataHolder);
        }
        return this.objectContentHolder.getInputStream();
    }

    @Override
    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        if (append) {
            throw new FileSystemException("Append mode is not supported for S3 because of inconsistency");
        }
        if (this.objectContentHolder == null) {
            this.objectContentHolder = new ObjectContentHolder();
        }
        return this.objectContentHolder.getOutputStream(this);
    }

    @Override
    protected FileType doGetType() {
        return FileType.IMAGINARY;
    }

    @Override
    protected String[] doListChildren() {
        throw new UnsupportedOperationException("this should never get called since we override getChildren()");
    }

    @Override
    protected FileObject[] doListChildrenResolved() throws FileSystemException {
        FileObject childObject;
        S3FileObject s3FileObject;
        String stripPath;
        this.assertType(FileType.FOLDER);
        String path = this.getName().getS3Key().orElse("");
        ObjectListing listing = this.getService().listObjects(new ListObjectsRequest().withBucketName(this.getBucketName()).withDelimiter("/").withPrefix(path));
        ArrayList<S3ObjectSummary> summaries = new ArrayList<S3ObjectSummary>(listing.getObjectSummaries());
        TreeSet<String> commonPrefixes = new TreeSet<String>(listing.getCommonPrefixes());
        while (listing.isTruncated()) {
            listing = this.getService().listNextBatchOfObjects(listing);
            summaries.addAll(listing.getObjectSummaries());
            commonPrefixes.addAll(listing.getCommonPrefixes());
        }
        ArrayList<FileObject> resolvedChildren = new ArrayList<FileObject>(summaries.size() + commonPrefixes.size());
        for (String commonPrefix : commonPrefixes) {
            stripPath = commonPrefix.substring(path.length());
            if (stripPath.equals("/") || (s3FileObject = (S3FileObject)FileObjectUtils.unwrap(childObject = this.resolveFile(stripPath, NameScope.CHILD))) == null) continue;
            s3FileObject.doAttachVirtualFolder();
            s3FileObject.setParent(this);
            resolvedChildren.add(childObject);
        }
        for (S3ObjectSummary summary : summaries) {
            if (summary.getKey().equals(path) || (s3FileObject = (S3FileObject)FileObjectUtils.unwrap(childObject = this.resolveFile(stripPath = summary.getKey().substring(path.length()), NameScope.CHILD))) == null) continue;
            s3FileObject.doAttach(FileType.FILE, new ObjectMetadataHolder(summary));
            s3FileObject.setParent(this);
            resolvedChildren.add(childObject);
        }
        return resolvedChildren.toArray(new FileObject[0]);
    }

    @Override
    protected long doGetContentSize() {
        return this.objectMetadataHolder.getContentLength();
    }

    @Override
    public S3FileName getName() {
        return (S3FileName)super.getName();
    }

    @Override
    protected boolean checkBeforeDelete(FileObject file) throws FileSystemException {
        return false;
    }

    @Override
    public void close() throws FileSystemException {
        super.close();
        if (this.objectContentHolder != null) {
            this.objectContentHolder.close();
            this.objectContentHolder = null;
        }
    }

    private AccessControlList getS3Acl() throws FileSystemException {
        Optional<String> key = this.getName().getS3Key();
        String bucketName = this.getBucketName();
        if (key.isPresent()) {
            if (this.getType() != FileType.FILE && this.getType() != FileType.FOLDER) {
                throw new FileSystemException("Wrong type to get acl " + this.getName());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Get acl for object [bucket=" + bucketName + ",key=" + key.get() + "]"));
            }
            return this.getService().getObjectAcl(bucketName, key.get());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get acl for bucket " + bucketName));
        }
        return this.getService().getBucketAcl(bucketName);
    }

    private void putS3Acl(AccessControlList s3Acl) throws FileSystemException {
        Optional<String> key = this.getName().getS3Key();
        if (key.isPresent()) {
            if (this.getType() != FileType.FILE && this.getType() != FileType.FOLDER) {
                throw new FileSystemException("Wrong type to put acl " + this.getName());
            }
            this.getService().setObjectAcl(this.getBucketName(), key.get(), s3Acl);
        } else {
            this.getService().setBucketAcl(this.getBucketName(), s3Acl);
        }
    }

    public Acl getAcl() throws FileSystemException {
        AccessControlList s3Acl;
        this.assertType(FileType.FILE, FileType.FOLDER);
        Acl myAcl = new Acl();
        try {
            s3Acl = this.getS3Acl();
        }
        catch (AmazonServiceException e) {
            throw new FileSystemException((Throwable)e);
        }
        Owner owner = s3Acl.getOwner();
        List<Grant> grants = s3Acl.getGrantsAsList();
        for (Grant item : grants) {
            Grantee grantee;
            Acl.Permission[] rights;
            Permission perm = item.getPermission();
            if (perm.equals((Object)Permission.FullControl)) {
                rights = Acl.Permission.values();
            } else if (perm.equals((Object)Permission.Read)) {
                rights = new Acl.Permission[]{Acl.Permission.READ};
            } else if (perm.equals((Object)Permission.Write)) {
                rights = new Acl.Permission[]{Acl.Permission.WRITE};
            } else {
                this.log.error((Object)("Skip unknown permission " + (Object)((Object)perm)));
                continue;
            }
            if (item.getGrantee() instanceof GroupGrantee) {
                grantee = (GroupGrantee)item.getGrantee();
                if (GroupGrantee.AllUsers.equals(grantee)) {
                    myAcl.allow(Acl.Group.EVERYONE, rights);
                    continue;
                }
                if (!GroupGrantee.AuthenticatedUsers.equals(grantee)) continue;
                myAcl.allow(Acl.Group.AUTHORIZED, rights);
                continue;
            }
            if (!(item.getGrantee() instanceof CanonicalGrantee) || !((CanonicalGrantee)(grantee = (CanonicalGrantee)item.getGrantee())).getIdentifier().equals(owner.getId())) continue;
            myAcl.allow(Acl.Group.OWNER, rights);
        }
        return myAcl;
    }

    public void setAcl(Acl acl) throws FileSystemException {
        Owner owner;
        this.assertType(FileType.FILE, FileType.FOLDER);
        AccessControlList s3Acl = new AccessControlList();
        try {
            owner = this.getS3Acl().getOwner();
        }
        catch (AmazonServiceException e) {
            throw new FileSystemException((Throwable)e);
        }
        s3Acl.setOwner(owner);
        Map<Acl.Group, Acl.Permission[]> rules = acl.getRules();
        Acl.Permission[] allRights = Acl.Permission.values();
        for (Acl.Group group : rules.keySet()) {
            Grantee grantee;
            Permission perm;
            Acl.Permission[] rights = rules.get((Object)group);
            if (rights.length == 0) continue;
            if (Arrays.equals((Object[])rights, (Object[])allRights)) {
                perm = Permission.FullControl;
            } else if (acl.isAllowed(group, Acl.Permission.READ)) {
                perm = Permission.Read;
            } else if (acl.isAllowed(group, Acl.Permission.WRITE)) {
                perm = Permission.Write;
            } else {
                this.log.error((Object)("Skip unknown set of rights " + Arrays.toString((Object[])rights)));
                continue;
            }
            if (group.equals((Object)Acl.Group.EVERYONE)) {
                grantee = GroupGrantee.AllUsers;
            } else if (group.equals((Object)Acl.Group.AUTHORIZED)) {
                grantee = GroupGrantee.AuthenticatedUsers;
            } else if (group.equals((Object)Acl.Group.OWNER)) {
                grantee = new CanonicalGrantee(owner.getId());
            } else {
                this.log.error((Object)("Skip unknown group " + (Object)((Object)group)));
                continue;
            }
            s3Acl.grantPermission(grantee, perm);
        }
        try {
            this.putS3Acl(s3Acl);
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public String getSignedUrl(int expireInSeconds) throws FileSystemException {
        this.assertType(FileType.FILE, FileType.FOLDER);
        Calendar cal = Calendar.getInstance();
        cal.add(13, expireInSeconds);
        try {
            return this.getService().generatePresignedUrl(this.getBucketName(), this.getName().getS3Key().orElseThrow(() -> new FileSystemException("Not able get presigned url for a bucket")), cal.getTime()).toString();
        }
        catch (AmazonServiceException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public Optional<String> getMD5Hash() throws FileSystemException {
        this.assertType(FileType.FILE, FileType.FOLDER);
        return this.objectMetadataHolder.getMD5Hash();
    }

    public Optional<String> getSSEAlgorithm() throws FileSystemException {
        this.assertType(FileType.FILE, FileType.FOLDER);
        if (this.objectMetadataHolder.isVirtual()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Have to fetch real metadata for [" + this.getName() + "]"));
            }
            this.refresh();
            this.getType();
        }
        if (this.objectMetadataHolder.isVirtual()) {
            throw new FileSystemException("Not able to fetch real metadata from " + this.getName());
        }
        return Optional.of(this.objectMetadataHolder).map(ObjectMetadataHolder::getServerSideEncryption);
    }

    public String getCacheFile() throws FileSystemException {
        if (this.objectContentHolder != null) {
            return this.objectContentHolder.getFile();
        }
        return null;
    }

    protected void assertType(FileType ... types) throws FileSystemException {
        FileType type = this.getType();
        boolean val = false;
        for (FileType t : types) {
            val = type == t || val;
        }
        if (!val) {
            throw new FileSystemException("File type should be one of " + Arrays.toString(types));
        }
    }

    protected AmazonS3 getService() {
        return ((S3FileSystem)this.getFileSystem()).getService();
    }

    protected TransferManager getTransferManager() {
        return ((S3FileSystem)this.getFileSystem()).getTransferManager();
    }

    protected String getBucketName() {
        return ((S3FileName)this.getFileSystem().getRootName()).getBucket();
    }

    @Override
    public boolean canRenameTo(FileObject newfile) {
        return false;
    }

    @Override
    public void copyFrom(FileObject file, FileSelector selector) throws FileSystemException {
        if (!file.exists()) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", (Object)file);
        }
        ArrayList files = new ArrayList();
        file.findFiles(selector, false, files);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Found files " + files.toString()));
        }
        LinkedHashMap<FileObject, FileObject> filesToCopy = new LinkedHashMap<FileObject, FileObject>();
        for (FileObject fileObject : files) {
            String relPath;
            FileObject destFile;
            FileObject unwrappedDestFile;
            FileObject unwrappedSrcFile = FileObjectUtils.unwrap(fileObject);
            if (!this.allowS3Copy(unwrappedSrcFile, unwrappedDestFile = FileObjectUtils.unwrap(destFile = this.resolveFile(relPath = file.getName().getRelativeName(unwrappedSrcFile.getName()), NameScope.DESCENDENT_OR_SELF)))) {
                this.log.warn((Object)("One of files don't allow S3 copy - fallback to default implementation [from=" + unwrappedSrcFile + ",to=" + unwrappedDestFile + "]"));
                super.copyFrom(file, selector);
                this.refresh();
                return;
            }
            filesToCopy.put(unwrappedSrcFile, unwrappedDestFile);
        }
        for (Map.Entry entry : filesToCopy.entrySet()) {
            FileObject source = (FileObject)entry.getKey();
            FileObject destination = (FileObject)entry.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Do file copy from [" + source.getName() + "] to [" + destination.getName() + "]"));
            }
            this.doCopyFrom(source, destination);
        }
        this.refresh();
    }

    protected boolean allowS3Copy(FileObject fromFile, FileObject toFile) throws FileSystemException {
        if (fromFile.getType().hasChildren()) {
            return true;
        }
        if (fromFile instanceof S3FileObject && ((S3FileObject)fromFile).sameFileSystem(toFile)) {
            return true;
        }
        if (fromFile.getType().hasContent() && fromFile.getURL().getProtocol().equals("file") && toFile instanceof S3FileObject) {
            try {
                fromFile.getURL().toURI();
                return true;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void doCopyFrom(FileObject fromFile, FileObject toFile) throws FileSystemException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Do S3 copy [from=" + fromFile + ",to=" + toFile + "]"));
        }
        if (toFile.exists()) {
            if (fromFile.getType() != toFile.getType()) {
                toFile.delete(Selectors.SELECT_ALL);
            }
        } else {
            FileObject parent = this.getParent();
            if (parent != null) {
                parent.createFolder();
            }
        }
        try {
            if (fromFile.getType().hasChildren()) {
                toFile.createFolder();
            } else if (fromFile instanceof S3FileObject && ((S3FileObject)fromFile).sameFileSystem(toFile)) {
                S3FileObject s3SrcFile = (S3FileObject)fromFile;
                S3FileObject s3DestFile = (S3FileObject)toFile;
                String srcBucketName = s3SrcFile.getBucketName();
                String srcFileName = s3SrcFile.getName().getS3Key().orElseThrow(() -> new FileSystemException("Not able to copy whole bucket"));
                String destBucketName = s3DestFile.getBucketName();
                String destFileName = s3DestFile.getName().getS3KeyAs(FileType.FILE);
                if (!s3SrcFile.exists()) {
                    throw new FileSystemException("Source file doesn't exist [" + s3SrcFile + "]");
                }
                if (!s3DestFile.exists()) {
                    s3DestFile.createFile();
                }
                CopyObjectRequest copy = new CopyObjectRequest(srcBucketName, srcFileName, destBucketName, destFileName);
                if (s3SrcFile.getType() == FileType.FILE) {
                    if (s3SrcFile.objectMetadataHolder.isVirtual()) {
                        s3SrcFile.refresh();
                        s3SrcFile.getType();
                    }
                    if (s3SrcFile.objectMetadataHolder.isVirtual()) {
                        throw new FileSystemException("Not able to fetch real metadata from " + this.getName());
                    }
                    s3SrcFile.objectMetadataHolder.withServerSideEncryption(this.getServerSideEncryption()).sendWith(copy);
                }
                this.getService().copyObject(copy);
            } else if (fromFile.getType().hasContent() && fromFile.getURL().getProtocol().equals("file") && toFile instanceof S3FileObject) {
                S3FileObject s3DestFile = (S3FileObject)toFile;
                try {
                    File localFile = new File(fromFile.getURL().toURI());
                    s3DestFile.upload(localFile);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        catch (AmazonClientException | IOException e) {
            throw new FileSystemException("vfs.provider/copy-file.error", (Throwable)e, new Object[]{fromFile, toFile});
        }
        finally {
            toFile.close();
        }
    }

    protected boolean sameFileSystem(FileObject toFile) {
        if (!(toFile instanceof S3FileObject)) {
            return false;
        }
        S3FileName destFile = ((S3FileObject)toFile).getName();
        return Objects.equals(this.getName().getEndpoint(), destFile.getEndpoint()) && Objects.equals(this.getName().getAccessKey(), destFile.getAccessKey()) && Objects.equals(this.getName().getSecretKey(), destFile.getSecretKey());
    }

    String upload(File file) throws IOException {
        ObjectMetadataHolder newMetadata;
        String md5;
        String key = this.getType() == FileType.IMAGINARY ? this.getName().getS3KeyAs(FileType.FILE) : this.getName().getS3Key().orElseThrow(() -> new FileSystemException("Not able to copy whole bucket"));
        PutObjectRequest request = new PutObjectRequest(this.getBucketName(), key, file);
        new ObjectMetadataHolder().withContentLength(file.length()).withContentType(this.getName().getBaseName()).withServerSideEncryption(this.getServerSideEncryption()).sendWith(request);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Upload request [file=" + file + ",key=" + key + ",length=" + file.length() + ",type=" + this.getName().getBaseName() + "]"));
        }
        try {
            md5 = this.getTransferManager().upload(request).waitForUploadResult().getETag();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        try {
            newMetadata = new ObjectMetadataHolder(this.getService().getObjectMetadata(this.getBucketName(), this.getName().getS3KeyAs(FileType.FILE)));
        }
        catch (AmazonS3Exception e) {
            throw new IOException(e);
        }
        if (newMetadata.getContentLength() != file.length()) {
            throw new FileSystemException("Wrong content length after upload. Expected [" + file.length() + "] but have [" + newMetadata.getContentLength() + "]");
        }
        if (!md5.equalsIgnoreCase(newMetadata.getMD5Hash().orElse(null))) {
            throw new FileSystemException("Wrong MD5 for content after upload. Expected [" + md5 + "] but have [" + newMetadata.getMD5Hash() + "]");
        }
        this.objectMetadataHolder = null;
        this.doAttach(FileType.FILE, newMetadata);
        return md5;
    }

    private boolean getServerSideEncryption() {
        if (!this.getName().getPlatformFeatures().supportsServerSideEncryption()) {
            return false;
        }
        return new S3FileSystemOptions(this.getFileSystem().getFileSystemOptions()).getServerSideEncryption();
    }
}

