/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.github.vfss3.AbstractFileName;
import com.github.vfss3.operations.PlatformFeatures;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public class S3FileName
extends AbstractFileName {
    public static final String SCHEME = "s3";
    private final String endpoint;
    private final String urlPrefix;
    private final String pathPrefix;
    private final String bucket;
    private final String signingRegion;
    private final PlatformFeatures platformFeatures;
    private final String accessKey;
    private final String secretKey;

    public S3FileName(String endpoint, String urlPrefix, String pathPrefix, String bucket, String signingRegion, String path, FileType type, String accessKey, String secretKey, PlatformFeatures platformFeatures) {
        super(SCHEME, path, type);
        this.endpoint = Objects.requireNonNull(endpoint);
        if (bucket != null && (bucket.contains("/") || bucket.contains(" ") || bucket.trim().length() == 0)) {
            throw new IllegalArgumentException("Bucket name [" + bucket + "] has to be valid bucket name");
        }
        this.bucket = Objects.requireNonNull(bucket);
        this.signingRegion = Objects.requireNonNull(signingRegion);
        this.pathPrefix = pathPrefix;
        this.urlPrefix = urlPrefix;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.platformFeatures = Objects.requireNonNull(platformFeatures);
    }

    @Override
    public S3FileName createName(String absPath, FileType type) {
        return new S3FileName(this.endpoint, this.urlPrefix, this.pathPrefix, this.bucket, this.signingRegion, absPath, type, this.accessKey, this.secretKey, this.platformFeatures);
    }

    @Override
    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
        if (this.urlPrefix != null) {
            buffer.append(this.urlPrefix).append('.');
        }
        buffer.append(this.endpoint);
        if (this.pathPrefix != null) {
            buffer.append('/').append(this.pathPrefix);
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean hasPathPrefix() {
        return this.pathPrefix != null;
    }

    String getPathPrefix() {
        return this.pathPrefix;
    }

    String getUrlPrefix() {
        return this.urlPrefix;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getSigningRegion() {
        return this.signingRegion;
    }

    public boolean hasCredentials() {
        return this.accessKey != null && this.secretKey != null;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public PlatformFeatures getPlatformFeatures() {
        return this.platformFeatures;
    }

    public Optional<String> getS3Key() throws FileSystemException {
        if (this.type != FileType.FILE && this.type != FileType.FOLDER) {
            throw new FileSystemException("Not able to get key from imaginary file");
        }
        if (this.getPathDecoded().equals("/")) {
            return Optional.empty();
        }
        StringBuilder path = new StringBuilder(this.getPathDecoded());
        if (path.indexOf("/") == 0 && path.length() > 1) {
            path.deleteCharAt(0);
        }
        if (this.type == FileType.FOLDER) {
            path.append('/');
        }
        return Optional.of(path.toString());
    }

    public String getS3KeyAs(FileType fileType) throws FileSystemException {
        StringBuilder path = new StringBuilder(this.getPathDecoded());
        if (path.indexOf("/") == 0 && path.length() > 1) {
            path.deleteCharAt(0);
        }
        if (fileType == FileType.FOLDER) {
            path.append('/');
        }
        return path.toString();
    }

    @Override
    public String toString() {
        return "S3FileName{endpoint='" + this.endpoint + '\'' + ", urlPrefix='" + this.urlPrefix + '\'' + ", pathPrefix='" + this.pathPrefix + '\'' + ", bucket='" + this.bucket + '\'' + ", signingRegion='" + this.signingRegion + '\'' + ", platformFeatures=" + this.platformFeatures + ", accessKey='" + this.accessKey + '\'' + ", secretKey='" + (this.secretKey != null ? "***secret***" : "null") + '\'' + '}';
    }
}

