/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.github.vfss3.shaded.com.amazonaws.services.s3.internal.Mimetypes;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.CopyObjectRequest;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import com.github.vfss3.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import com.github.vfss3.shaded.com.amazonaws.util.DateUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;

class ObjectMetadataHolder {
    private final ObjectMetadata metadata;
    private final boolean virtual;

    ObjectMetadataHolder() {
        this.metadata = new ObjectMetadata();
        this.virtual = true;
    }

    ObjectMetadataHolder(ObjectMetadata metadata) {
        this(metadata, false);
    }

    private ObjectMetadataHolder(ObjectMetadata metadata, boolean virtual) {
        this.metadata = Objects.requireNonNull(metadata);
        this.virtual = virtual;
    }

    ObjectMetadataHolder(S3ObjectSummary summary) {
        this();
        this.metadata.setContentLength(Objects.requireNonNull(summary).getSize());
        this.metadata.setLastModified(summary.getLastModified());
        this.metadata.setHeader("ETag", summary.getETag());
    }

    ObjectMetadataHolder withZeroContentLength() {
        return this.withContentLength(0L);
    }

    ObjectMetadataHolder withContentLength(long length) {
        ObjectMetadata newMeta = this.metadata.clone();
        newMeta.setContentLength(length);
        return new ObjectMetadataHolder(newMeta, this.virtual);
    }

    ObjectMetadataHolder withContentType(String type) {
        ObjectMetadata newMeta = this.metadata.clone();
        newMeta.setContentType(Mimetypes.getInstance().getMimetype(type));
        return new ObjectMetadataHolder(newMeta, this.virtual);
    }

    ObjectMetadataHolder withLastModifiedNow() {
        ObjectMetadata newMeta = this.metadata.clone();
        newMeta.setLastModified(new Date());
        return new ObjectMetadataHolder(newMeta, this.virtual);
    }

    ObjectMetadataHolder withServerSideEncryption(boolean useEncryption) {
        ObjectMetadata newMeta = this.metadata.clone();
        if (useEncryption) {
            newMeta.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        }
        return new ObjectMetadataHolder(newMeta, this.virtual);
    }

    String getServerSideEncryption() {
        return this.metadata.getSSEAlgorithm();
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public Optional<String> getMD5Hash() {
        return Optional.ofNullable(this.metadata.getETag());
    }

    public long getContentLength() {
        return this.metadata.getContentLength();
    }

    public long getLastModified() {
        Date lastModified = this.metadata.getLastModified();
        return lastModified != null ? lastModified.getTime() : 0L;
    }

    public void sendWith(PutObjectRequest request) {
        request.setMetadata(this.deepMetadataClone());
    }

    public void sendWith(CopyObjectRequest request) {
        request.setNewObjectMetadata(this.deepMetadataClone());
    }

    private ObjectMetadata deepMetadataClone() {
        ObjectMetadata result = new ObjectMetadata();
        HashMap<String, Object> headers = new HashMap<String, Object>(this.metadata.getRawMetadata());
        headers.remove("X-Host");
        headers.remove("X-Req-Id");
        headers.forEach(result::setHeader);
        result.setUserMetadata(this.metadata.getUserMetadata());
        result.setExpirationTime(DateUtils.cloneDate(this.metadata.getExpirationTime()));
        result.setHttpExpiresDate(DateUtils.cloneDate(this.metadata.getHttpExpiresDate()));
        result.setRestoreExpirationTime(DateUtils.cloneDate(this.metadata.getRestoreExpirationTime()));
        if (this.metadata.getOngoingRestore() != null) {
            result.setOngoingRestore(this.metadata.getOngoingRestore());
        }
        result.setExpirationTimeRuleId(this.metadata.getExpirationTimeRuleId());
        return result;
    }
}

