/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.github.vfss3.ObjectMetadataHolder;
import com.github.vfss3.S3FileObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;

class ObjectContentHolder
implements Closeable {
    private final Log log = LogFactory.getLog(ObjectContentHolder.class);
    private Path file = Files.createTempFile("vfs.", ".s3", new FileAttribute[0]);
    private int openForRead = 0;
    private boolean openForWrite = false;
    private String md5;
    private long contentLength;

    public ObjectContentHolder() throws IOException {
        this.file.toFile().deleteOnExit();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initialized cache file " + this.file));
        }
    }

    public void populateData(InputStream data, ObjectMetadataHolder metadata) throws IOException {
        this.populateData(data, metadata.getContentLength(), metadata.getMD5Hash().orElseThrow(() -> new FileSystemException("Empty MD5 for the object")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateData(InputStream data, long contentLength, String md5) throws IOException {
        block17: {
            if (this.file == null) {
                throw new FileSystemException("Content holder was closed");
            }
            this.openForWrite = true;
            this.md5 = Objects.requireNonNull(md5);
            this.contentLength = contentLength;
            try (FileChannel target = FileChannel.open(this.file, StandardOpenOption.WRITE);){
                if (contentLength == 0L) {
                    target.truncate(0L);
                    break block17;
                }
                try (ReadableByteChannel source = Channels.newChannel(data);){
                    target.transferFrom(source, 0L, contentLength);
                }
            }
            finally {
                this.openForWrite = false;
            }
        }
    }

    public boolean sameData(ObjectMetadataHolder metadata) throws IOException {
        if (this.file == null) {
            throw new FileSystemException("Content holder was closed");
        }
        return metadata.getContentLength() == this.contentLength && this.md5 != null && this.md5.equalsIgnoreCase(metadata.getMD5Hash().orElse(null));
    }

    public InputStream getInputStream() throws FileSystemException {
        if (this.file == null) {
            throw new FileSystemException("Content holder was closed");
        }
        if (this.openForWrite) {
            throw new FileSystemException("Close write stream before using it for read");
        }
        try {
            return new UnlockOnCloseInputStream();
        }
        catch (IOException e) {
            this.log.error((Object)"Not able to get input stream for temporary file", (Throwable)e);
            throw new FileSystemException("Not able to get input stream for temporary file");
        }
    }

    public OutputStream getOutputStream(S3FileObject object) throws FileSystemException {
        if (this.file == null) {
            throw new FileSystemException("Content holder was closed");
        }
        if (this.openForRead > 0 || this.openForWrite) {
            throw new FileSystemException("Close stream before using it for write");
        }
        try {
            return new UploadOnCloseOutputStream(Objects.requireNonNull(object));
        }
        catch (IOException e) {
            this.log.error((Object)"Not able to get output stream for temporary file", (Throwable)e);
            throw new FileSystemException("Not able to get output stream for temporary file");
        }
    }

    @Override
    public void close() {
        if (this.file != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Close cache file " + this.file));
            }
            try {
                Files.deleteIfExists(this.file);
            }
            catch (IOException e) {
                this.log.warn((Object)("Error deleting temp file: " + this.file), (Throwable)e);
            }
            this.file = null;
        }
    }

    public String getFile() throws FileSystemException {
        if (this.file == null) {
            throw new FileSystemException("Content holder was closed");
        }
        return this.file.toFile().getAbsolutePath();
    }

    private class UnlockOnCloseInputStream
    extends MonitorInputStream {
        public UnlockOnCloseInputStream() throws IOException {
            super(Files.newInputStream(ObjectContentHolder.this.file, new OpenOption[0]));
            ObjectContentHolder.this.openForRead++;
        }

        protected void onClose() throws IOException {
            super.onClose();
            ObjectContentHolder.this.openForRead--;
        }
    }

    private class UploadOnCloseOutputStream
    extends MonitorOutputStream {
        private final S3FileObject object;

        UploadOnCloseOutputStream(S3FileObject object) throws IOException {
            super(Files.newOutputStream(ObjectContentHolder.this.file, new OpenOption[0]));
            this.object = object;
            ObjectContentHolder.this.openForWrite = true;
        }

        protected void onClose() throws IOException {
            super.onClose();
            try {
                if (ObjectContentHolder.this.log.isDebugEnabled()) {
                    ObjectContentHolder.this.log.debug((Object)("Start to upload file " + ObjectContentHolder.this.file));
                }
                ObjectContentHolder.this.md5 = this.object.upload(ObjectContentHolder.this.file.toFile());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                ObjectContentHolder.this.openForWrite = false;
            }
        }
    }
}

