/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import java.util.Objects;
import org.apache.commons.vfs2.FileSystemOptions;

class FileSystemKey
implements Comparable<FileSystemKey> {
    private static final FileSystemOptions EMPTY_OPTIONS = new FileSystemOptions();
    private final Comparable<?> key;
    private final FileSystemOptions fileSystemOptions;

    FileSystemKey(Comparable<?> key, FileSystemOptions fileSystemOptions) {
        this.key = Objects.requireNonNull(key);
        this.fileSystemOptions = fileSystemOptions != null ? fileSystemOptions : EMPTY_OPTIONS;
    }

    @Override
    public int compareTo(FileSystemKey o) {
        Comparable<?> comparable = this.key;
        int ret = comparable.compareTo(o.key);
        if (ret != 0) {
            return ret;
        }
        return this.fileSystemOptions.compareTo(o.fileSystemOptions);
    }

    public String toString() {
        return "FileSystemKey[key=" + this.key + ", fileSystemOptions=" + this.fileSystemOptions + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemKey that = (FileSystemKey)o;
        return this.key.equals(that.key) && this.fileSystemOptions.equals((Object)that.fileSystemOptions);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.fileSystemOptions);
    }
}

