/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;

public class DepthFileSelector
implements FileSelector {
    private final int maxDepth;
    private final int minDepth;

    public DepthFileSelector() {
        this(0, Integer.MAX_VALUE);
    }

    public DepthFileSelector(int depth) {
        this(0, depth);
    }

    public DepthFileSelector(int min, int max) {
        this.minDepth = min;
        this.maxDepth = max;
    }

    public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
        int depth = fileSelectInfo.getDepth();
        return depth >= this.minDepth && depth <= this.maxDepth;
    }

    public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
        return fileSelectInfo.getDepth() < this.maxDepth;
    }
}

