/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.github.vfss3.AbstractFileObject;
import com.github.vfss3.AbstractFileSystem;
import com.github.vfss3.FileContentThreadData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.MonitorRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

final class DefaultFileContent
implements FileContent {
    static final int STATE_CLOSED = 0;
    static final int STATE_OPENED = 1;
    private static final int WRITE_BUFFER_SIZE = 4096;
    private final AbstractFileObject fileObject;
    private Map<String, Object> attrs;
    private Map<String, Object> roAttrs;
    private FileContentInfo fileContentInfo;
    private final FileContentInfoFactory fileContentInfoFactory;
    private final ThreadLocal<FileContentThreadData> threadLocal = new ThreadLocal();
    private boolean resetAttributes;
    private int openStreams;

    public DefaultFileContent(AbstractFileObject file, FileContentInfoFactory fileContentInfoFactory) {
        this.fileObject = file;
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    private FileContentThreadData getOrCreateThreadData() {
        FileContentThreadData data = this.threadLocal.get();
        if (data == null) {
            data = new FileContentThreadData();
            this.threadLocal.set(data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            ++this.openStreams;
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            if (this.openStreams > 0) {
                --this.openStreams;
                if (this.openStreams < 1) {
                    this.fileObject.notifyAllStreamsClosed();
                }
            }
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamClosed();
    }

    public FileObject getFile() {
        return this.fileObject;
    }

    public long getSize() throws FileSystemException {
        if (!this.fileObject.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/get-size-not-file.error", (Object)this.fileObject);
        }
        try {
            return this.fileObject.doGetContentSize();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/get-size.error", (Throwable)exc, new Object[]{this.fileObject});
        }
    }

    public long getLastModifiedTime() throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-last-modified-no-exist.error", (Object)this.fileObject);
        }
        try {
            return this.fileObject.doGetLastModifiedTime();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", (Object)this.fileObject, (Throwable)e);
        }
    }

    public void setLastModifiedTime(long modTime) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-last-modified-no-exist.error", (Object)this.fileObject);
        }
        try {
            if (!this.fileObject.doSetLastModifiedTime(modTime)) {
                throw new FileSystemException("vfs.provider/set-last-modified.error", (Object)this.fileObject);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-last-modified.error", (Object)this.fileObject, (Throwable)e);
        }
    }

    public boolean hasAttribute(String attrName) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/exists-attributes-no-exist.error", (Object)this.fileObject);
        }
        this.getAttributes();
        return this.attrs.containsKey(attrName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAttributes() throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-attributes-no-exist.error", (Object)this.fileObject);
        }
        if (this.resetAttributes || this.roAttrs == null) {
            try {
                DefaultFileContent defaultFileContent = this;
                synchronized (defaultFileContent) {
                    this.attrs = this.fileObject.doGetAttributes();
                    this.roAttrs = Collections.unmodifiableMap(this.attrs);
                    this.resetAttributes = false;
                }
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/get-attributes.error", (Object)this.fileObject, (Throwable)e);
            }
        }
        return this.roAttrs;
    }

    public void resetAttributes() {
        this.resetAttributes = true;
    }

    public String[] getAttributeNames() throws FileSystemException {
        this.getAttributes();
        Set<String> names = this.attrs.keySet();
        return names.toArray(new String[names.size()]);
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        this.getAttributes();
        return this.attrs.get(attrName);
    }

    public void setAttribute(String attrName, Object value) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-attribute-no-exist.error", new Object[]{attrName, this.fileObject});
        }
        try {
            this.fileObject.doSetAttribute(attrName, value);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-attribute.error", (Throwable)e, new Object[]{attrName, this.fileObject});
        }
        if (this.attrs != null) {
            this.attrs.put(attrName, value);
        }
    }

    public void removeAttribute(String attrName) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/remove-attribute-no-exist.error", (Object)this.fileObject);
        }
        try {
            this.fileObject.doRemoveAttribute(attrName);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/remove-attribute.error", (Throwable)e, new Object[]{attrName, this.fileObject});
        }
        if (this.attrs != null) {
            this.attrs.remove(attrName);
        }
    }

    public Certificate[] getCertificates() throws FileSystemException {
        if (!this.fileObject.exists()) {
            throw new FileSystemException("vfs.provider/get-certificates-no-exist.error", (Object)this.fileObject);
        }
        try {
            Certificate[] certs = this.fileObject.doGetCertificates();
            if (certs != null) {
                return certs;
            }
            return new Certificate[0];
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-certificates.error", (Object)this.fileObject, (Throwable)e);
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        return this.buildInputStream(0);
    }

    public InputStream getInputStream(int bufferSize) throws FileSystemException {
        return this.buildInputStream(bufferSize);
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        RandomAccessContent rastr = this.fileObject.getRandomAccessContent(mode);
        FileRandomAccessContent rac = new FileRandomAccessContent(this.fileObject, rastr);
        this.getOrCreateThreadData().addRastr((RandomAccessContent)rac);
        this.streamOpened();
        return rac;
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        return this.buildOutputStream(bAppend, 0);
    }

    public OutputStream getOutputStream(int bufferSize) throws FileSystemException {
        return this.buildOutputStream(false, bufferSize);
    }

    public OutputStream getOutputStream(boolean bAppend, int bufferSize) throws FileSystemException {
        return this.buildOutputStream(bAppend, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws FileSystemException {
        FileSystemException caught = null;
        try {
            FileContentThreadData fileContentThreadData = this.getOrCreateThreadData();
            while (fileContentThreadData.getInstrsSize() > 0) {
                FileContentInputStream inputStream = (FileContentInputStream)((Object)fileContentThreadData.removeInstr(0));
                try {
                    inputStream.close();
                }
                catch (FileSystemException ex) {
                    caught = ex;
                }
            }
            while (fileContentThreadData.getRastrsSize() > 0) {
                FileRandomAccessContent randomAccessContent = (FileRandomAccessContent)((Object)fileContentThreadData.removeRastr(0));
                try {
                    randomAccessContent.close();
                }
                catch (FileSystemException ex) {
                    caught = ex;
                }
            }
            FileContentOutputStream outputStream = fileContentThreadData.getOutstr();
            if (outputStream != null) {
                fileContentThreadData.setOutstr(null);
                try {
                    outputStream.close();
                }
                catch (FileSystemException ex) {
                    caught = ex;
                }
            }
        }
        finally {
            this.threadLocal.remove();
        }
        if (caught != null) {
            throw caught;
        }
    }

    private InputStream buildInputStream(int bufferSize) throws FileSystemException {
        InputStream inputStream = this.fileObject.getInputStream();
        FileContentInputStream wrappedInputStream = bufferSize == 0 ? new FileContentInputStream(this.fileObject, inputStream) : new FileContentInputStream(this.fileObject, inputStream, bufferSize);
        this.getOrCreateThreadData().addInstr((InputStream)((Object)wrappedInputStream));
        this.streamOpened();
        return wrappedInputStream;
    }

    private OutputStream buildOutputStream(boolean bAppend, int bufferSize) throws FileSystemException {
        FileContentThreadData streams = this.getOrCreateThreadData();
        if (streams.getOutstr() != null) {
            throw new FileSystemException("vfs.provider/write-in-use.error", (Object)this.fileObject);
        }
        OutputStream outstr = this.fileObject.getOutputStream(bAppend);
        FileContentOutputStream wrapped = bufferSize == 0 ? new FileContentOutputStream(this.fileObject, outstr) : new FileContentOutputStream(this.fileObject, outstr, bufferSize);
        streams.setOutstr(wrapped);
        this.streamOpened();
        return wrapped;
    }

    private void endInput(FileContentInputStream instr) {
        FileContentThreadData fileContentThreadData = this.threadLocal.get();
        if (fileContentThreadData != null) {
            fileContentThreadData.removeInstr((InputStream)((Object)instr));
        }
        if (fileContentThreadData == null || !fileContentThreadData.hasStreams()) {
            this.threadLocal.remove();
        }
        this.streamClosed();
    }

    private void endRandomAccess(RandomAccessContent rac) {
        FileContentThreadData fileContentThreadData = this.threadLocal.get();
        if (fileContentThreadData != null) {
            fileContentThreadData.removeRastr(rac);
        }
        if (fileContentThreadData == null || !fileContentThreadData.hasStreams()) {
            this.threadLocal.remove();
        }
        this.streamClosed();
    }

    private void endOutput() throws Exception {
        FileContentThreadData fileContentThreadData = this.threadLocal.get();
        if (fileContentThreadData != null) {
            fileContentThreadData.setOutstr(null);
        }
        if (fileContentThreadData == null || !fileContentThreadData.hasStreams()) {
            this.threadLocal.remove();
        }
        this.streamClosed();
        this.fileObject.endOutput();
    }

    public boolean isOpen() {
        FileContentThreadData fileContentThreadData = this.threadLocal.get();
        if (fileContentThreadData != null && fileContentThreadData.hasStreams()) {
            return true;
        }
        this.threadLocal.remove();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpenGlobal() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            return this.openStreams > 0;
        }
    }

    public FileContentInfo getContentInfo() throws FileSystemException {
        if (this.fileContentInfo == null) {
            this.fileContentInfo = this.fileContentInfoFactory.create((FileContent)this);
        }
        return this.fileContentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(FileContent fileContent) throws IOException {
        try (OutputStream output = fileContent.getOutputStream();){
            long l = this.write(output);
            return l;
        }
    }

    public long write(FileObject file) throws IOException {
        return this.write(file.getContent());
    }

    public long write(OutputStream output) throws IOException {
        return this.write(output, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(OutputStream output, int bufferSize) throws IOException {
        long count = 0L;
        try (InputStream input = this.getInputStream();){
            byte[] buffer = new byte[bufferSize];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
        }
        return count;
    }

    final class FileContentOutputStream
    extends MonitorOutputStream {
        private final FileObject file;

        FileContentOutputStream(FileObject file, OutputStream outstr) {
            super(outstr);
            this.file = file;
        }

        FileContentOutputStream(FileObject file, OutputStream outstr, int bufferSize) {
            super(outstr, bufferSize);
            this.file = file;
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-outstr.error", (Object)this.file, (Throwable)e);
            }
        }

        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                try {
                    DefaultFileContent.this.endOutput();
                }
                catch (Exception e) {
                    throw new FileSystemException("vfs.provider/close-outstr.error", (Object)this.file, (Throwable)e);
                }
            }
        }
    }

    private final class FileRandomAccessContent
    extends MonitorRandomAccessContent {
        private final FileObject file;

        FileRandomAccessContent(FileObject file, RandomAccessContent content) {
            super(content);
            this.file = file;
        }

        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endRandomAccess((RandomAccessContent)this);
            }
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-rac.error", (Object)this.file, (Throwable)e);
            }
        }
    }

    private final class FileContentInputStream
    extends MonitorInputStream {
        private final FileObject file;

        FileContentInputStream(FileObject file, InputStream instr) {
            super(instr);
            this.file = file;
        }

        FileContentInputStream(FileObject file, InputStream instr, int bufferSize) {
            super(instr, bufferSize);
            this.file = file;
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-instr.error", (Object)this.file, (Throwable)e);
            }
        }

        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endInput(this);
            }
        }
    }
}

