/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.github.vfss3.FileSystemKey;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.VfsComponent;

abstract class CachingFileProvider
extends AbstractFileProvider {
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.globalLock.readLock();
    private final Lock writeLock = this.globalLock.writeLock();
    private final Map<FileSystemKey, FileSystem> fileSystems = new TreeMap<FileSystemKey, FileSystem>();
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected abstract FileSystem doCreateFileSystem(FileName var1, FileSystemOptions var2) throws FileSystemException;

    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName name;
        try {
            name = this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        }
        catch (FileSystemException exc) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", (Object)uri, (Throwable)exc);
        }
        return this.findFile(name, fileSystemOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject findFile(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = this.getContext().getFileSystemManager().resolveName(name, "/");
        FileSystem fs = this.findFileSystem((Comparable<?>)rootName, fileSystemOptions);
        if (fs == null) {
            this.writeLock.lock();
            try {
                fs = this.findFileSystem((Comparable<?>)rootName, fileSystemOptions);
                if (fs == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Create new file system for [key=" + rootName + ",options=" + fileSystemOptions + "]"));
                    }
                    fs = this.doCreateFileSystem(rootName, fileSystemOptions);
                    this.addFileSystem((Comparable<?>)rootName, fs);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return fs.resolveFile(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem findFileSystem(Comparable<?> rootName, FileSystemOptions fileSystemProps) {
        FileSystemKey treeKey = new FileSystemKey(rootName, fileSystemProps);
        this.readLock.lock();
        try {
            FileSystem fileSystem = this.fileSystems.get(treeKey);
            return fileSystem;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void addFileSystem(Comparable<?> key, FileSystem fs) throws FileSystemException {
        this.addComponent(fs);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Add new file system [key=" + key + ",options=" + fs.getFileSystemOptions() + "]"));
        }
        FileSystemKey treeKey = new FileSystemKey(key, fs.getFileSystemOptions());
        this.fileSystems.put(treeKey, fs);
    }

    public void freeUnusedResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileSystem(FileSystem fileSystem) {
        this.writeLock.lock();
        try {
            LinkedList<FileSystemKey> keys = new LinkedList<FileSystemKey>();
            for (Map.Entry<FileSystemKey, FileSystem> entry : this.fileSystems.entrySet()) {
                if (!entry.getValue().equals(fileSystem)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Remove file system " + entry.getKey()));
                }
                keys.add(entry.getKey());
            }
            keys.forEach(this.fileSystems::remove);
        }
        finally {
            this.writeLock.unlock();
        }
        this.removeComponent(fileSystem);
        if (fileSystem instanceof VfsComponent) {
            VfsComponent component = (VfsComponent)fileSystem;
            component.close();
        }
    }
}

