/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.github.vfss3.AbstractVfsComponent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs2.events.AbstractFileChangeEvent;
import org.apache.commons.vfs2.events.ChangedEvent;
import org.apache.commons.vfs2.events.CreateEvent;
import org.apache.commons.vfs2.events.DeleteEvent;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;

abstract class AbstractFileSystem
extends AbstractVfsComponent
implements FileSystem {
    private static final Log LOG = LogFactory.getLog(AbstractFileSystem.class);
    private final FileName rootName;
    private final String rootURI;
    private final Collection<Capability> caps = new HashSet<Capability>();
    private FileObject parentLayer;
    private final Map<FileName, ArrayList<FileListener>> listenerMap = new HashMap<FileName, ArrayList<FileListener>>();
    private final FileSystemOptions fileSystemOptions;
    private final AtomicInteger openStreams = new AtomicInteger(0);

    protected AbstractFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) {
        this.parentLayer = parentLayer;
        this.rootName = rootName;
        this.fileSystemOptions = fileSystemOptions;
        DefaultFileSystemConfigBuilder builder = DefaultFileSystemConfigBuilder.getInstance();
        String uri = builder.getRootURI(fileSystemOptions);
        if (uri == null) {
            uri = rootName.getURI();
        }
        this.rootURI = uri;
    }

    @Override
    public void init() throws FileSystemException {
        this.addCapabilities(this.caps);
    }

    @Override
    public void close() {
        this.doCloseCommunicationLink();
        this.parentLayer = null;
    }

    protected void doCloseCommunicationLink() {
    }

    protected abstract FileObject createFile(FileName var1) throws Exception;

    protected abstract void addCapabilities(Collection<Capability> var1);

    public FileName getRootName() {
        return this.rootName;
    }

    public String getRootURI() {
        return this.rootURI;
    }

    protected void putFileToCache(FileObject file) {
        this.getCache().putFile(file);
    }

    private FilesCache getCache() {
        FilesCache files = this.getContext().getFileSystemManager().getFilesCache();
        if (files == null) {
            throw new RuntimeException(Messages.getString((String)"vfs.provider/files-cache-missing.error"));
        }
        return files;
    }

    protected FileObject getFileFromCache(FileName name) {
        return this.getCache().getFile((FileSystem)this, name);
    }

    protected void removeFileFromCache(FileName name) {
        this.getCache().removeFile((FileSystem)this, name);
    }

    public boolean hasCapability(Capability capability) {
        return this.caps.contains(capability);
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        throw new FileSystemException("vfs.provider/get-attribute-not-supported.error");
    }

    public void setAttribute(String attrName, Object value) throws FileSystemException {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    public FileObject getParentLayer() throws FileSystemException {
        return this.parentLayer;
    }

    public FileObject getRoot() throws FileSystemException {
        return this.resolveFile(this.rootName);
    }

    public FileObject resolveFile(String nameStr) throws FileSystemException {
        FileName name = this.getFileSystemManager().resolveName(this.rootName, nameStr);
        return this.resolveFile(name);
    }

    public FileObject resolveFile(FileName name) throws FileSystemException {
        FileObject file;
        if (!this.rootName.getRootURI().equals(name.getRootURI())) {
            throw new FileSystemException("vfs.provider/mismatched-fs-for-name.error", new Object[]{name, this.rootName, name.getRootURI()});
        }
        try {
            file = this.createFile(name);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/resolve-file.error", (Object)name, (Throwable)e);
        }
        file = this.decorateFileObject(file);
        return Objects.requireNonNull(file);
    }

    protected FileObject decorateFileObject(FileObject file) throws FileSystemException {
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_CALL)) {
            file = new OnCallRefreshFileObject(file);
        }
        if (this.getFileSystemManager().getFileObjectDecoratorConst() != null) {
            try {
                file = (FileObject)this.getFileSystemManager().getFileObjectDecoratorConst().newInstance(file);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", (Object)this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
        }
        return file;
    }

    public File replicateFile(FileObject file, FileSelector selector) throws FileSystemException {
        if (!FileObjectUtils.exists((FileObject)file)) {
            throw new FileSystemException("vfs.provider/replicate-missing-file.error", (Object)file.getName());
        }
        try {
            return this.doReplicateFile(file, selector);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/replicate-file.error", (Object)file.getName(), (Throwable)e);
        }
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    public FileSystemManager getFileSystemManager() {
        return this.getContext().getFileSystemManager();
    }

    public double getLastModTimeAccuracy() {
        return 0.0;
    }

    protected File doReplicateFile(FileObject file, FileSelector selector) throws Exception {
        return this.getContext().getReplicator().replicateFile(file, selector);
    }

    public void addJunction(String junctionPoint, FileObject targetFile) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", (Object)this.rootName);
    }

    public void removeJunction(String junctionPoint) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", (Object)this.rootName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FileObject file, FileListener listener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<Object> listeners = this.listenerMap.get(file.getName());
            if (listeners == null) {
                listeners = new ArrayList();
                this.listenerMap.put(file.getName(), listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FileObject file, FileListener listener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> listeners = this.listenerMap.get(file.getName());
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.listenerMap.remove(file.getName());
                }
            }
        }
    }

    public void fireFileCreated(FileObject file) {
        this.fireEvent((AbstractFileChangeEvent)new CreateEvent(file));
    }

    public void fireFileDeleted(FileObject file) {
        this.fireEvent((AbstractFileChangeEvent)new DeleteEvent(file));
    }

    public void fireFileChanged(FileObject file) {
        this.fireEvent((AbstractFileChangeEvent)new ChangedEvent(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(AbstractFileChangeEvent event) {
        FileListener[] fileListeners = null;
        FileObject file = event.getFile();
        FileListener[] fileListenerArray = this.listenerMap;
        synchronized (this.listenerMap) {
            ArrayList<FileListener> listeners = this.listenerMap.get(file.getName());
            if (listeners != null) {
                fileListeners = listeners.toArray(new FileListener[listeners.size()]);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (fileListeners != null) {
                for (FileListener fileListener : fileListeners) {
                    try {
                        event.notify(fileListener);
                    }
                    catch (Exception e) {
                        String message = Messages.getString((String)"vfs.provider/notify-listener.warn", (Object)file);
                        VfsLog.warn((Log)this.getLogger(), (Log)LOG, (String)message, (Throwable)e);
                    }
                }
            }
            return;
        }
    }

    void fileObjectHanded(FileObject fileObject) {
    }

    void fileObjectDestroyed(FileObject fileObject) {
    }

    void streamOpened() {
        this.openStreams.incrementAndGet();
    }

    void streamClosed() {
        if (this.openStreams.decrementAndGet() == 0) {
            this.notifyAllStreamsClosed();
        }
    }

    protected void notifyAllStreamsClosed() {
    }

    public boolean isOpen() {
        return this.openStreams.get() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileSystem that = (AbstractFileSystem)o;
        return this.rootName.equals(that.rootName) && this.fileSystemOptions.equals((Object)that.fileSystemOptions);
    }

    public int hashCode() {
        return Objects.hash(this.rootName, this.fileSystemOptions);
    }
}

