/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfss3;

import com.github.vfss3.AbstractFileName;
import com.github.vfss3.AbstractFileSystem;
import com.github.vfss3.DefaultFileContent;
import com.github.vfss3.DefaultFileSelectorInfo;
import com.github.vfss3.FileObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileUtil;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.operations.DefaultFileOperations;
import org.apache.commons.vfs2.operations.FileOperations;
import org.apache.commons.vfs2.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.RandomAccessMode;

abstract class AbstractFileObject<AFS extends AbstractFileSystem>
implements FileObject {
    private final Log log = LogFactory.getLog(AbstractFileObject.class);
    private static final FileName[] EMPTY_FILE_ARRAY = new FileName[0];
    private static final int INITIAL_LIST_SIZE = 5;
    private AbstractFileName fileName;
    private final AFS fileSystem;
    private FileContent content;
    private boolean attached;
    private FileType type;
    private FileObject parent;
    private FileName[] children;
    private List<Object> objects;
    private FileOperations operations;

    private static void traverse(DefaultFileSelectorInfo fileInfo, FileSelector selector, boolean depthwise, List<FileObject> selected) throws Exception {
        FileObject file = fileInfo.getFile();
        int index = selected.size();
        if (file.getType().hasChildren() && selector.traverseDescendents((FileSelectInfo)fileInfo)) {
            FileObject[] children;
            int curDepth = fileInfo.getDepth();
            fileInfo.setDepth(curDepth + 1);
            for (FileObject child : children = file.getChildren()) {
                fileInfo.setFile(child);
                AbstractFileObject.traverse(fileInfo, selector, depthwise, selected);
            }
            fileInfo.setFile(file);
            fileInfo.setDepth(curDepth);
        }
        if (selector.includeFile((FileSelectInfo)fileInfo)) {
            if (depthwise) {
                selected.add(file);
            } else {
                selected.add(index, file);
            }
        }
    }

    protected AbstractFileObject(AbstractFileName name, AFS fileSystem) {
        this.fileName = name;
        this.fileSystem = fileSystem;
        ((AbstractFileSystem)fileSystem).fileObjectHanded(this);
    }

    protected final void attach() throws FileSystemException {
        if (this.isAttached()) {
            return;
        }
        try {
            this.doAttach();
            this.setAttached(true);
            if (this.parent == null) {
                FileName name = this.fileName.getParent();
                if (name == null) {
                    this.setParent(null);
                } else {
                    this.setParent(((AbstractFileSystem)this.fileSystem).resolveFile(name));
                }
            }
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/get-type.error", (Throwable)exc, new Object[]{this.fileName});
        }
    }

    public boolean canRenameTo(FileObject newfile) {
        return this.fileSystem == newfile.getFileSystem();
    }

    protected void childrenChanged(FileName childName, FileType newType) throws Exception {
        if (this.children != null && childName != null && newType != null) {
            ArrayList<FileName> list = new ArrayList<FileName>(Arrays.asList(this.children));
            if (newType.equals((Object)FileType.IMAGINARY)) {
                list.remove(childName);
            } else {
                list.add(childName);
            }
            this.children = new FileName[list.size()];
            list.toArray(this.children);
        }
        this.onChildrenChanged(childName, newType);
    }

    public void close() throws FileSystemException {
        FileSystemException exc = null;
        if (this.content != null) {
            try {
                this.content.close();
                this.content = null;
            }
            catch (FileSystemException e) {
                exc = e;
            }
        }
        try {
            this.detach();
        }
        catch (Exception e) {
            exc = new FileSystemException("vfs.provider/close.error", (Object)this.fileName, (Throwable)e);
        }
        if (exc != null) {
            throw exc;
        }
    }

    public int compareTo(FileObject file) {
        if (file == null) {
            return 1;
        }
        return this.toString().compareToIgnoreCase(file.toString());
    }

    public void copyFrom(FileObject file, FileSelector selector) throws FileSystemException {
        if (!FileObjectUtils.exists(file)) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", (Object)file);
        }
        ArrayList files = new ArrayList();
        file.findFiles(selector, false, files);
        for (FileObject srcFile : files) {
            String relPath = file.getName().getRelativeName(srcFile.getName());
            FileObject destFile = this.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
            if (FileObjectUtils.exists(destFile) && destFile.getType() != srcFile.getType()) {
                destFile.deleteAll();
            }
            try {
                if (srcFile.getType().hasContent()) {
                    FileUtil.copyContent((FileObject)srcFile, (FileObject)destFile);
                    continue;
                }
                if (!srcFile.getType().hasChildren()) continue;
                destFile.createFolder();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/copy-file.error", (Throwable)e, new Object[]{srcFile, destFile});
            }
        }
    }

    public void createFile() throws FileSystemException {
        try {
            if (this.exists() && !this.isFile()) {
                throw new FileSystemException("vfs.provider/create-file.error", (Object)this.fileName);
            }
            if (!this.exists()) {
                this.getOutputStream().close();
                this.endOutput();
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/create-file.error", (Object)this.fileName, (Throwable)e);
        }
    }

    public void createFolder() throws FileSystemException {
        try {
            if (this.getType().hasChildren()) {
                return;
            }
            FileObject parent = this.getParent();
            if (parent != null && !parent.exists()) {
                parent.createFolder();
            }
            if (this.exists()) {
                throw new FileSystemException("vfs.provider/create-folder-mismatched-type.error", (Object)this.fileName);
            }
            this.doCreateFolder();
            this.handleCreate(FileType.FOLDER);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/create-folder.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    public boolean delete() throws FileSystemException {
        return this.delete(Selectors.SELECT_SELF) > 0;
    }

    public int delete(FileSelector selector) throws FileSystemException {
        int nuofDeleted = 0;
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        this.findFiles(selector, true, files);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Found files to delete " + files.toString()));
        }
        for (FileObject fileObject : files) {
            AbstractFileObject file = FileObjectUtils.getAbstractFileObject(fileObject);
            if (file == null || this.checkBeforeDelete(file) || !file.deleteSelf()) continue;
            ++nuofDeleted;
        }
        return nuofDeleted;
    }

    public int deleteAll() throws FileSystemException {
        return this.delete(Selectors.SELECT_ALL);
    }

    private boolean deleteSelf() throws FileSystemException {
        try {
            this.doDelete();
            this.handleDelete();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/delete.error", (Throwable)exc, new Object[]{this.fileName});
        }
        return true;
    }

    private void detach() throws Exception {
        if (this.isAttached()) {
            try {
                this.doDetach();
            }
            finally {
                this.setFileType(null);
                this.setAttached(false);
                this.setParent(null);
                this.removeChildrenCache();
            }
        }
    }

    protected void doAttach() throws Exception {
    }

    protected FileContent doCreateFileContent() throws FileSystemException {
        return new DefaultFileContent(this, this.getFileContentInfoFactory());
    }

    protected void doCreateFolder() throws Exception {
        throw new FileSystemException("vfs.provider/create-folder-not-supported.error");
    }

    protected void doDelete() throws Exception {
        throw new FileSystemException("vfs.provider/delete-not-supported.error");
    }

    protected void doDetach() throws Exception {
    }

    protected Map<String, Object> doGetAttributes() throws Exception {
        return Collections.emptyMap();
    }

    protected Certificate[] doGetCertificates() throws Exception {
        return null;
    }

    protected abstract long doGetContentSize() throws Exception;

    protected abstract InputStream doGetInputStream() throws Exception;

    protected long doGetLastModifiedTime() throws Exception {
        throw new FileSystemException("vfs.provider/get-last-modified-not-supported.error");
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        throw new FileSystemException("vfs.provider/write-not-supported.error");
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        throw new FileSystemException("vfs.provider/random-access-not-supported.error");
    }

    protected abstract FileType doGetType() throws Exception;

    protected boolean doIsExecutable() throws Exception {
        return false;
    }

    protected boolean doIsHidden() throws Exception {
        return false;
    }

    protected boolean doIsReadable() throws Exception {
        return true;
    }

    protected boolean doIsSameFile(FileObject destFile) throws FileSystemException {
        return false;
    }

    protected boolean doIsSymbolicLink() throws Exception {
        return false;
    }

    protected boolean doIsWriteable() throws Exception {
        return true;
    }

    protected boolean checkBeforeDelete(FileObject file) throws FileSystemException {
        return file.getType().hasChildren() && file.getChildren().length != 0;
    }

    protected abstract String[] doListChildren() throws Exception;

    protected FileObject[] doListChildrenResolved() throws Exception {
        return null;
    }

    protected void doRemoveAttribute(String attrName) throws Exception {
        throw new FileSystemException("vfs.provider/remove-attribute-not-supported.error");
    }

    protected void doRename(FileObject newFile) throws Exception {
        throw new FileSystemException("vfs.provider/rename-not-supported.error");
    }

    protected void doSetAttribute(String attrName, Object value) throws Exception {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    protected boolean doSetExecutable(boolean executable, boolean ownerOnly) throws Exception {
        return false;
    }

    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        throw new FileSystemException("vfs.provider/set-last-modified-not-supported.error");
    }

    protected boolean doSetReadable(boolean readable, boolean ownerOnly) throws Exception {
        return false;
    }

    protected boolean doSetWritable(boolean writable, boolean ownerOnly) throws Exception {
        return false;
    }

    protected void endOutput() throws Exception {
        if (this.getType() == FileType.IMAGINARY) {
            this.handleCreate(FileType.FILE);
        } else {
            this.onChange();
        }
    }

    public boolean exists() throws FileSystemException {
        return this.getType() != FileType.IMAGINARY;
    }

    private FileName[] extractNames(FileObject[] objects) {
        if (objects == null) {
            return null;
        }
        FileName[] names = new FileName[objects.length];
        for (int iterObjects = 0; iterObjects < objects.length; ++iterObjects) {
            names[iterObjects] = objects[iterObjects].getName();
        }
        return names;
    }

    protected void finalize() throws Throwable {
        ((AbstractFileSystem)this.fileSystem).fileObjectDestroyed(this);
        super.finalize();
    }

    public FileObject[] findFiles(FileSelector selector) throws FileSystemException {
        List<FileObject> list = this.listFiles(selector);
        return list == null ? null : list.toArray(new FileObject[0]);
    }

    public void findFiles(FileSelector selector, boolean depthwise, List<FileObject> selected) throws FileSystemException {
        try {
            if (this.exists()) {
                DefaultFileSelectorInfo info = new DefaultFileSelectorInfo();
                info.setBaseFolder(this);
                info.setDepth(0);
                info.setFile(this);
                AbstractFileObject.traverse(info, selector, depthwise, selected);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/find-files.error", (Object)this.fileName, (Throwable)e);
        }
    }

    protected AFS getAbstractFileSystem() {
        return this.fileSystem;
    }

    public FileObject getChild(String name) throws FileSystemException {
        FileObject[] children;
        for (FileObject element : children = this.getChildren()) {
            FileName child = element.getName();
            if (!child.getBaseName().equals(name)) continue;
            return this.resolveFile(child);
        }
        return null;
    }

    public FileObject[] getChildren() throws FileSystemException {
        String[] files;
        FileObject[] childrenObjects;
        if (!((AbstractFileSystem)this.fileSystem).hasCapability(Capability.LIST_CHILDREN)) {
            throw new FileNotFolderException((Object)this.fileName);
        }
        this.attach();
        if (this.children != null) {
            return this.resolveFiles(this.children);
        }
        try {
            childrenObjects = this.doListChildrenResolved();
            this.children = this.extractNames(childrenObjects);
        }
        catch (FileSystemException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/list-children.error", (Throwable)exc, new Object[]{this.fileName});
        }
        if (childrenObjects != null) {
            return childrenObjects;
        }
        try {
            files = this.doListChildren();
        }
        catch (FileSystemException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/list-children.error", (Throwable)exc, new Object[]{this.fileName});
        }
        if (files == null) {
            throw new FileNotFolderException((Object)this.fileName);
        }
        if (files.length == 0) {
            this.children = EMPTY_FILE_ARRAY;
        } else {
            FileName[] cache = new FileName[files.length];
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                cache[i] = ((AbstractFileSystem)this.fileSystem).getFileSystemManager().resolveName((FileName)this.fileName, file, NameScope.CHILD);
            }
            this.children = cache;
        }
        return this.resolveFiles(this.children);
    }

    public FileContent getContent() throws FileSystemException {
        this.attach();
        if (this.content == null) {
            this.content = this.doCreateFileContent();
        }
        return this.content;
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return ((AbstractFileSystem)this.fileSystem).getFileSystemManager().getFileContentInfoFactory();
    }

    public FileOperations getFileOperations() throws FileSystemException {
        if (this.operations == null) {
            this.operations = new DefaultFileOperations((FileObject)this);
        }
        return this.operations;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public InputStream getInputStream() throws FileSystemException {
        try {
            return this.doGetInputStream();
        }
        catch (FileNotFoundException exc) {
            throw new FileNotFoundException((Object)this.fileName, (Throwable)exc);
        }
        catch (java.io.FileNotFoundException exc) {
            throw new FileNotFoundException((Object)this.fileName, (Throwable)exc);
        }
        catch (FileSystemException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/read.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    public FileName getName() {
        return this.fileName;
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        FileObject parent;
        if (bAppend && !((AbstractFileSystem)this.fileSystem).hasCapability(Capability.APPEND_CONTENT)) {
            throw new FileSystemException("vfs.provider/write-append-not-supported.error", (Object)this.fileName);
        }
        if (this.getType() == FileType.IMAGINARY && (parent = this.getParent()) != null && !parent.exists()) {
            parent.createFolder();
        }
        try {
            return this.doGetOutputStream(bAppend);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/write.error", (Throwable)exc, new Object[]{this.fileName});
        }
    }

    public FileObject getParent() throws FileSystemException {
        if (this.fileName.compareTo(((AbstractFileSystem)this.fileSystem).getRootName()) == 0) {
            if (((AbstractFileSystem)this.fileSystem).getParentLayer() == null) {
                return null;
            }
            return ((AbstractFileSystem)this.fileSystem).getParentLayer().getParent();
        }
        this.attach();
        return this.parent;
    }

    protected void setParent(FileObject parent) {
        this.parent = parent;
    }

    public String getPublicURIString() {
        return this.fileName.getFriendlyURI();
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        if (mode.requestRead()) {
            if (!((AbstractFileSystem)this.fileSystem).hasCapability(Capability.RANDOM_ACCESS_READ)) {
                throw new FileSystemException("vfs.provider/random-access-read-not-supported.error");
            }
            if (!this.isReadable()) {
                throw new FileSystemException("vfs.provider/read-not-readable.error", (Object)this.fileName);
            }
        }
        if (mode.requestWrite()) {
            if (!((AbstractFileSystem)this.fileSystem).hasCapability(Capability.RANDOM_ACCESS_WRITE)) {
                throw new FileSystemException("vfs.provider/random-access-write-not-supported.error");
            }
            if (!this.isWriteable()) {
                throw new FileSystemException("vfs.provider/write-read-only.error", (Object)this.fileName);
            }
        }
        try {
            return this.doGetRandomAccessContent(mode);
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/random-access.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    public FileType getType() throws FileSystemException {
        try {
            this.attach();
            if (this.type == null) {
                this.setFileType(this.doGetType());
            }
            if (this.type == null) {
                this.setFileType(FileType.IMAGINARY);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-type.error", (Throwable)e, new Object[]{this.fileName});
        }
        return this.type;
    }

    public URL getURL() throws FileSystemException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException, FileSystemException {
                    StringBuilder buf = new StringBuilder();
                    String scheme = UriParser.extractScheme((String[])VFS.getManager().getSchemes(), (String)AbstractFileObject.this.fileName.getURI(), (StringBuilder)buf);
                    return new URL(scheme, "", -1, buf.toString(), (URLStreamHandler)new DefaultURLStreamHandler(AbstractFileObject.this.fileSystem.getContext(), AbstractFileObject.this.fileSystem.getFileSystemOptions()));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new FileSystemException("vfs.provider/get-url.error", (Object)this.fileName, (Throwable)e.getException());
        }
    }

    protected void handleChanged() throws Exception {
        ((AbstractFileSystem)this.fileSystem).fireFileChanged(this);
    }

    final void handleCreate(FileType newType) throws Exception {
        if (this.isAttached()) {
            this.injectType(newType);
            this.removeChildrenCache();
            this.onChange();
        }
        this.notifyParent(this.getName(), newType);
        ((AbstractFileSystem)this.fileSystem).fireFileCreated(this);
    }

    final void handleDelete() throws Exception {
        if (this.isAttached()) {
            this.injectType(FileType.IMAGINARY);
            this.removeChildrenCache();
            this.onChange();
        }
        this.notifyParent(this.getName(), FileType.IMAGINARY);
        ((AbstractFileSystem)this.fileSystem).fireFileDeleted(this);
    }

    public void holdObject(Object strongRef) {
        if (this.objects == null) {
            this.objects = new ArrayList<Object>(5);
        }
        this.objects.add(strongRef);
    }

    protected void injectType(FileType fileType) {
        this.setFileType(fileType);
    }

    public boolean isAttached() {
        return this.attached;
    }

    protected void setAttached(boolean attached) {
        this.attached = attached;
    }

    public boolean isContentOpen() {
        if (this.content == null) {
            return false;
        }
        return this.content.isOpen();
    }

    public boolean isExecutable() throws FileSystemException {
        try {
            return this.exists() ? this.doIsExecutable() : false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-executable.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    public boolean isFile() throws FileSystemException {
        return FileType.FILE.equals((Object)this.getType());
    }

    public boolean isFolder() throws FileSystemException {
        return FileType.FOLDER.equals((Object)this.getType());
    }

    public boolean isHidden() throws FileSystemException {
        try {
            return this.exists() ? this.doIsHidden() : false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-hidden.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    public boolean isReadable() throws FileSystemException {
        try {
            return this.exists() ? this.doIsReadable() : false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-readable.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    protected final boolean isSameFile(FileObject destFile) throws FileSystemException {
        return this.doIsSameFile(destFile);
    }

    public boolean isSymbolicLink() throws FileSystemException {
        try {
            return this.exists() ? this.doIsSymbolicLink() : false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-symbolic-link.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    public boolean isWriteable() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsWriteable();
            }
            FileObject parent = this.getParent();
            if (parent != null) {
                return parent.isWriteable();
            }
            return true;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-writeable.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    public Iterator<FileObject> iterator() {
        try {
            return this.listFiles(Selectors.SELECT_ALL).iterator();
        }
        catch (FileSystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<FileObject> listFiles(FileSelector selector) throws FileSystemException {
        if (!this.exists() || selector == null) {
            return null;
        }
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        this.findFiles(selector, true, list);
        return list;
    }

    public void moveTo(FileObject destFile) throws FileSystemException {
        if (this.canRenameTo(destFile)) {
            if (!this.getParent().isWriteable()) {
                throw new FileSystemException("vfs.provider/rename-parent-read-only.error", new Object[]{this.getName(), this.getParent().getName()});
            }
        } else if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/rename-read-only.error", (Object)this.getName());
        }
        if (destFile.exists() && !this.isSameFile(destFile)) {
            destFile.deleteAll();
        }
        if (this.canRenameTo(destFile)) {
            try {
                FileType srcType = this.getType();
                this.doRename(destFile);
                FileObjectUtils.getAbstractFileObject(destFile).handleCreate(srcType);
                destFile.close();
                this.handleDelete();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exc) {
                throw new FileSystemException("vfs.provider/rename.error", (Throwable)exc, new Object[]{this.getName(), destFile.getName()});
            }
        } else {
            destFile.copyFrom((FileObject)this, Selectors.SELECT_SELF);
            if ((destFile.getType().hasContent() && destFile.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE) || destFile.getType().hasChildren() && destFile.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER)) && ((AbstractFileSystem)this.fileSystem).hasCapability(Capability.GET_LAST_MODIFIED)) {
                destFile.getContent().setLastModifiedTime(this.getContent().getLastModifiedTime());
            }
            this.deleteSelf();
        }
    }

    protected void notifyAllStreamsClosed() {
    }

    private void notifyParent(FileName childName, FileType newType) throws Exception {
        FileObject resolveParent = this.getParent();
        if (resolveParent != null) {
            FileObjectUtils.getAbstractFileObject(resolveParent).childrenChanged(childName, newType);
        }
    }

    protected void onChange() throws Exception {
    }

    protected void onChildrenChanged(FileName child, FileType newType) throws Exception {
    }

    public void refresh() throws FileSystemException {
        try {
            this.detach();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/resync.error", (Object)this.fileName, (Throwable)e);
        }
    }

    private void removeChildrenCache() {
        this.children = null;
    }

    private FileObject resolveFile(FileName child) throws FileSystemException {
        return ((AbstractFileSystem)this.fileSystem).resolveFile(child);
    }

    public FileObject resolveFile(String path) throws FileSystemException {
        FileName otherName = ((AbstractFileSystem)this.fileSystem).getFileSystemManager().resolveName((FileName)this.fileName, path);
        return ((AbstractFileSystem)this.fileSystem).resolveFile(otherName);
    }

    public FileObject resolveFile(String name, NameScope scope) throws FileSystemException {
        return ((AbstractFileSystem)this.fileSystem).resolveFile(((AbstractFileSystem)this.fileSystem).getFileSystemManager().resolveName((FileName)this.fileName, name, scope));
    }

    private FileObject[] resolveFiles(FileName[] children) throws FileSystemException {
        if (children == null) {
            return null;
        }
        FileObject[] objects = new FileObject[children.length];
        for (int iterChildren = 0; iterChildren < children.length; ++iterChildren) {
            objects[iterChildren] = this.resolveFile(children[iterChildren]);
        }
        return objects;
    }

    public boolean setExecutable(boolean readable, boolean ownerOnly) throws FileSystemException {
        try {
            return this.exists() ? this.doSetExecutable(readable, ownerOnly) : false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/set-executable.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    private void setFileType(FileType type) {
        if (type != null && type != FileType.IMAGINARY) {
            try {
                this.fileName.setType(type);
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.type = type;
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) throws FileSystemException {
        try {
            return this.exists() ? this.doSetReadable(readable, ownerOnly) : false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/set-readable.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    public boolean setWritable(boolean readable, boolean ownerOnly) throws FileSystemException {
        try {
            return this.exists() ? this.doSetWritable(readable, ownerOnly) : false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/set-writeable.error", (Object)this.fileName, (Throwable)exc);
        }
    }

    public String toString() {
        return this.fileName.getURI();
    }
}

