/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ContainerCredentialsFetcher;
import com.github.vfss3.shaded.com.amazonaws.auth.AWSCredentials;
import com.github.vfss3.shaded.com.amazonaws.auth.ContainerCredentialsProvider;
import com.github.vfss3.shaded.com.amazonaws.internal.CredentialsEndpointProvider;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ContainerCredentialsProvider
implements AWSCredentialsProvider {
    static final String ECS_CONTAINER_CREDENTIALS_PATH = "AWS_CONTAINER_CREDENTIALS_RELATIVE_URI";
    static final String CONTAINER_CREDENTIALS_FULL_URI = "AWS_CONTAINER_CREDENTIALS_FULL_URI";
    static final String CONTAINER_AUTHORIZATION_TOKEN = "AWS_CONTAINER_AUTHORIZATION_TOKEN";
    private static final Set<String> ALLOWED_FULL_URI_HOSTS = ContainerCredentialsProvider.allowedHosts();
    private static final String ECS_CREDENTIALS_ENDPOINT = "http://169.254.170.2";
    private final ContainerCredentialsFetcher credentialsFetcher;

    @Deprecated
    public ContainerCredentialsProvider() {
        this(new ContainerCredentialsProvider.ECSCredentialsEndpointProvider());
    }

    public ContainerCredentialsProvider(CredentialsEndpointProvider credentialsEndpointProvider) {
        this.credentialsFetcher = new ContainerCredentialsFetcher(credentialsEndpointProvider);
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsFetcher.getCredentials();
    }

    @Override
    public void refresh() {
        this.credentialsFetcher.refresh();
    }

    public Date getCredentialsExpiration() {
        return this.credentialsFetcher.getCredentialsExpiration();
    }

    private static Set<String> allowedHosts() {
        HashSet<String> hosts = new HashSet<String>();
        hosts.add("127.0.0.1");
        hosts.add("localhost");
        return Collections.unmodifiableSet(hosts);
    }

    static /* synthetic */ Set access$000() {
        return ALLOWED_FULL_URI_HOSTS;
    }
}

