/* The following code was generated by JFlex 1.4.1 on 9/17/22 11:37 AM */

/*
 * 11/24/2015
 *
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;
import java.util.Stack;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for TypeScript files.  Currently it is a clone of
 * {@code JavaScriptTokenMaker}, but it should diverge over time to match
 * the added features of TypeScript.
 *
 * This implementation was created using
 * <a href="https://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>), so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>TypeScriptTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.9
 */

public class TypeScriptTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int JS_STRING = 1;
  public static final int E4X = 6;
  public static final int E4X_INTAG = 10;
  public static final int E4X_PI = 8;
  public static final int JS_MLC = 3;
  public static final int JS_CHAR = 2;
  public static final int JS_EOL_COMMENT = 5;
  public static final int E4X_COMMENT = 7;
  public static final int JS_DOCCOMMENT = 4;
  public static final int E4X_DTD = 9;
  public static final int JS_TEMPLATE_LITERAL = 14;
  public static final int E4X_INATTR_SINGLE = 12;
  public static final int E4X_INATTR_DOUBLE = 11;
  public static final int JS_TEMPLATE_LITERAL_EXPR = 15;
  public static final int YYINITIAL = 0;
  public static final int E4X_CDATA = 13;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\75\1\2\1\0\1\1\1\11\22\0\1\75\1\36\1\77"+
    "\1\12\1\15\1\35\1\40\1\107\2\106\1\17\1\30\1\27\1\24"+
    "\1\25\1\16\1\5\7\7\2\4\1\42\1\76\1\31\1\32\1\34"+
    "\1\37\1\45\1\103\1\6\1\101\1\102\1\23\1\22\2\3\1\112"+
    "\2\3\1\21\1\3\1\111\5\3\1\104\3\3\1\20\2\3\1\100"+
    "\1\13\1\105\1\33\1\14\1\113\1\46\1\47\1\53\1\65\1\54"+
    "\1\70\1\57\1\61\1\56\1\3\1\64\1\55\1\44\1\60\1\62"+
    "\1\66\1\73\1\52\1\50\1\51\1\10\1\71\1\63\1\72\1\67"+
    "\1\110\1\74\1\41\1\26\1\43\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\13\0\2\1\3\0\1\2\1\3\1\4\1\5\2\6"+
    "\1\5\1\2\3\7\1\5\1\10\1\5\7\7\1\5"+
    "\1\2\22\5\1\11\1\12\2\5\1\13\1\1\1\14"+
    "\1\15\1\16\1\1\1\17\1\20\1\21\1\1\1\22"+
    "\5\1\1\23\10\1\1\24\3\1\2\5\1\25\1\26"+
    "\1\27\1\30\1\1\1\31\5\1\1\32\2\1\1\33"+
    "\1\1\1\34\1\35\1\36\2\37\1\40\1\41\1\42"+
    "\1\43\1\1\1\44\4\1\1\45\1\46\1\47\1\50"+
    "\1\1\1\51\1\1\1\52\1\2\1\53\1\6\1\54"+
    "\1\53\1\54\1\53\1\55\1\53\1\5\2\0\1\56"+
    "\1\57\3\7\1\0\1\60\1\7\1\5\1\61\36\5"+
    "\2\62\7\5\1\62\14\5\1\63\1\64\1\65\1\66"+
    "\4\0\1\67\2\0\1\70\32\0\1\71\1\26\1\72"+
    "\1\73\1\27\5\0\1\74\2\0\1\75\1\76\1\2"+
    "\1\54\1\0\2\55\1\5\1\77\1\100\3\5\1\101"+
    "\40\5\1\101\27\5\64\0\1\102\2\0\1\103\5\0"+
    "\1\104\1\2\1\105\7\5\1\106\5\5\1\107\1\5"+
    "\1\110\25\5\1\0\1\1\1\0\1\111\15\0\1\112"+
    "\45\0\1\113\4\0\1\114\1\0\1\115\2\0\1\116"+
    "\1\0\1\117\1\2\4\5\1\62\16\5\1\62\1\5"+
    "\15\0\1\112\20\0\1\112\20\0\1\2\4\5\1\120"+
    "\13\5\33\0\10\5\1\112\4\0\1\112\12\0\3\5"+
    "\6\0\1\5\2\0\1\121\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[646];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\114\0\230\0\344\0\u0130\0\u017c\0\u01c8\0\u0214"+
    "\0\u0260\0\u02ac\0\u02f8\0\u0344\0\u0390\0\u03dc\0\u0428\0\u0474"+
    "\0\u04c0\0\u050c\0\u0558\0\u05a4\0\u05f0\0\u063c\0\u0688\0\u0558"+
    "\0\u06d4\0\u0720\0\u076c\0\u07b8\0\u0558\0\u0558\0\u0804\0\u0850"+
    "\0\u089c\0\u08e8\0\u0558\0\u0934\0\u0980\0\u09cc\0\u0a18\0\u0a64"+
    "\0\u0ab0\0\u0afc\0\u0b48\0\u0b94\0\u0be0\0\u0c2c\0\u0c78\0\u0cc4"+
    "\0\u0d10\0\u0d5c\0\u0da8\0\u0df4\0\u0e40\0\u0e8c\0\u0ed8\0\u0f24"+
    "\0\u0f70\0\u0558\0\u0558\0\u0fbc\0\u1008\0\u0558\0\u1054\0\u0558"+
    "\0\u10a0\0\u0558\0\u10ec\0\u0558\0\u10a0\0\u0558\0\u1138\0\u0558"+
    "\0\u1184\0\u11d0\0\u121c\0\u1268\0\u12b4\0\u0558\0\u1300\0\u134c"+
    "\0\u1398\0\u13e4\0\u1430\0\u147c\0\u14c8\0\u1514\0\u0558\0\u1560"+
    "\0\u15ac\0\u15f8\0\u1644\0\u1690\0\u0558\0\u16dc\0\u1728\0\u0558"+
    "\0\u1774\0\u0558\0\u17c0\0\u180c\0\u1858\0\u18a4\0\u18f0\0\u0558"+
    "\0\u193c\0\u1988\0\u0558\0\u19d4\0\u0558\0\u0558\0\u0558\0\u1a20"+
    "\0\u1a6c\0\u1ab8\0\u0558\0\u0558\0\u0558\0\u1b04\0\u0558\0\u1b50"+
    "\0\u1b9c\0\u1be8\0\u1c34\0\u0558\0\u10a0\0\u1c80\0\u0558\0\u1ccc"+
    "\0\u0558\0\u1d18\0\u0558\0\u1d64\0\u1db0\0\u1db0\0\u1db0\0\u1dfc"+
    "\0\u1e48\0\u1e94\0\u1ee0\0\u1f2c\0\u1f78\0\u1fc4\0\u2010\0\u0558"+
    "\0\u205c\0\u1fc4\0\u20a8\0\u20f4\0\u20a8\0\u0558\0\u2140\0\u218c"+
    "\0\u21d8\0\u2224\0\u2270\0\u22bc\0\u2308\0\u2354\0\u23a0\0\u23ec"+
    "\0\u2438\0\u2484\0\u24d0\0\u251c\0\u2568\0\u25b4\0\u2600\0\u264c"+
    "\0\u2698\0\u26e4\0\u2730\0\u277c\0\u27c8\0\u2814\0\u2860\0\u28ac"+
    "\0\u28f8\0\u2944\0\u2990\0\u29dc\0\u2a28\0\u2a74\0\u2ac0\0\u2b0c"+
    "\0\u05a4\0\u2b58\0\u2ba4\0\u2bf0\0\u2c3c\0\u2c88\0\u2cd4\0\u2d20"+
    "\0\u2d6c\0\u2db8\0\u2e04\0\u2e50\0\u2e9c\0\u2ee8\0\u2f34\0\u2f80"+
    "\0\u2fcc\0\u3018\0\u3064\0\u30b0\0\u30fc\0\u0558\0\u3148\0\u3194"+
    "\0\u0558\0\u31e0\0\u322c\0\u3278\0\u32c4\0\u0558\0\u3310\0\u335c"+
    "\0\u0558\0\u33a8\0\u33f4\0\u3440\0\u348c\0\u34d8\0\u3524\0\u3570"+
    "\0\u35bc\0\u3608\0\u3654\0\u36a0\0\u36ec\0\u3738\0\u3784\0\u37d0"+
    "\0\u381c\0\u3868\0\u38b4\0\u3900\0\u394c\0\u3998\0\u39e4\0\u3a30"+
    "\0\u3a7c\0\u3ac8\0\u3b14\0\u3b60\0\u3bac\0\u3bf8\0\u0558\0\u0558"+
    "\0\u3c44\0\u3c90\0\u3cdc\0\u3d28\0\u3d74\0\u0558\0\u3dc0\0\u3e0c"+
    "\0\u0558\0\u0558\0\u3e58\0\u3ea4\0\u3ef0\0\u1db0\0\u3f3c\0\u3f88"+
    "\0\u3fd4\0\u4020\0\u406c\0\u40b8\0\u4104\0\u05a4\0\u4150\0\u419c"+
    "\0\u41e8\0\u4234\0\u4280\0\u42cc\0\u4318\0\u4364\0\u43b0\0\u43fc"+
    "\0\u4448\0\u4494\0\u44e0\0\u452c\0\u4578\0\u45c4\0\u4610\0\u465c"+
    "\0\u46a8\0\u46f4\0\u4740\0\u478c\0\u47d8\0\u4824\0\u4870\0\u48bc"+
    "\0\u4908\0\u4954\0\u49a0\0\u49ec\0\u4a38\0\u4a84\0\u4ad0\0\u4b1c"+
    "\0\u4b68\0\u4bb4\0\u4c00\0\u4c4c\0\u4c98\0\u4ce4\0\u4d30\0\u4d7c"+
    "\0\u4dc8\0\u4e14\0\u4e60\0\u4eac\0\u4ef8\0\u4f44\0\u4f90\0\u4fdc"+
    "\0\u5028\0\u5074\0\u50c0\0\u510c\0\u5158\0\u51a4\0\u51f0\0\u523c"+
    "\0\u5288\0\u52d4\0\u5320\0\u536c\0\u53b8\0\u5404\0\u5450\0\u549c"+
    "\0\u54e8\0\u5534\0\u5580\0\u55cc\0\u5618\0\u5664\0\u56b0\0\u56fc"+
    "\0\u5748\0\u5794\0\u57e0\0\u582c\0\u5878\0\u58c4\0\u5910\0\u595c"+
    "\0\u59a8\0\u59f4\0\u5a40\0\u5a8c\0\u5ad8\0\u5b24\0\u5b70\0\u5bbc"+
    "\0\u5c08\0\u5c54\0\u5ca0\0\u5cec\0\u5d38\0\u5d84\0\u5dd0\0\u5e1c"+
    "\0\u5e68\0\u5eb4\0\u5f00\0\u5f4c\0\u5f98\0\u5fe4\0\u6030\0\u607c"+
    "\0\u60c8\0\u6114\0\u6160\0\u61ac\0\u61f8\0\u0558\0\u6244\0\u6290"+
    "\0\u62dc\0\u6328\0\u6374\0\u0558\0\u63c0\0\u0558\0\u640c\0\u6458"+
    "\0\u64a4\0\u64f0\0\u653c\0\u6588\0\u65d4\0\u05a4\0\u6620\0\u666c"+
    "\0\u66b8\0\u6704\0\u6750\0\u05a4\0\u679c\0\u05a4\0\u67e8\0\u6834"+
    "\0\u6880\0\u68cc\0\u6918\0\u6964\0\u69b0\0\u69fc\0\u6a48\0\u6a94"+
    "\0\u6ae0\0\u6b2c\0\u6b78\0\u6bc4\0\u6c10\0\u6c5c\0\u6ca8\0\u6cf4"+
    "\0\u6d40\0\u6d8c\0\u6dd8\0\u3194\0\u0558\0\u6e24\0\u6e70\0\u6ebc"+
    "\0\u6f08\0\u6f54\0\u6fa0\0\u6fec\0\u7038\0\u7084\0\u70d0\0\u711c"+
    "\0\u7168\0\u71b4\0\u7200\0\u724c\0\u0558\0\u7298\0\u72e4\0\u7330"+
    "\0\u737c\0\u73c8\0\u7414\0\u7460\0\u74ac\0\u74f8\0\u7544\0\u7590"+
    "\0\u75dc\0\u7628\0\u7674\0\u76c0\0\u770c\0\u7758\0\u77a4\0\u77f0"+
    "\0\u783c\0\u7888\0\u78d4\0\u7920\0\u796c\0\u79b8\0\u7a04\0\u7a50"+
    "\0\u7a9c\0\u7ae8\0\u7b34\0\u7b80\0\u7bcc\0\u7c18\0\u7c64\0\u7cb0"+
    "\0\u7cfc\0\u7d48\0\u7d94\0\u7de0\0\u7e2c\0\u7e78\0\u7ec4\0\u7f10"+
    "\0\u7f5c\0\u0558\0\u7fa8\0\u7ff4\0\u8040\0\u808c\0\u0558\0\u80d8"+
    "\0\u8124\0\u8170\0\u81bc\0\u8208\0\u452c\0\u8254\0\u82a0\0\u82ec"+
    "\0\u8338\0\u8384\0\u83d0\0\u841c\0\u8468\0\u84b4\0\u8500\0\u854c"+
    "\0\u8598\0\u85e4\0\u8630\0\u867c\0\u86c8\0\u6e70\0\u8714\0\u8760"+
    "\0\u87ac\0\u87f8\0\u8844\0\u8890\0\u88dc\0\u8928\0\u8974\0\u89c0"+
    "\0\u8a0c\0\u8a58\0\u8aa4\0\u8af0\0\u8b3c\0\u8b88\0\u8bd4\0\u8c20"+
    "\0\u8c6c\0\u8cb8\0\u8d04\0\u8d50\0\u8d9c\0\u8de8\0\u8e34\0\u8e80"+
    "\0\u8ecc\0\u8f18\0\u8f64\0\u8fb0\0\u8ffc\0\u9048\0\u9094\0\u90e0"+
    "\0\u912c\0\u9178\0\u91c4\0\u7d94\0\u9210\0\u925c\0\u92a8\0\u7f10"+
    "\0\u92f4\0\u9340\0\u8040\0\u938c\0\u93d8\0\u9424\0\u9470\0\u94bc"+
    "\0\u9508\0\u05a4\0\u9554\0\u95a0\0\u95ec\0\u9638\0\u9684\0\u96d0"+
    "\0\u971c\0\u9768\0\u97b4\0\u9800\0\u984c\0\u9898\0\u98e4\0\u9930"+
    "\0\u997c\0\u99c8\0\u9a14\0\u9a60\0\u9aac\0\u9af8\0\u9b44\0\u9b90"+
    "\0\u9bdc\0\u9c28\0\u9c74\0\u9cc0\0\u9d0c\0\u9d58\0\u9da4\0\u9df0"+
    "\0\u9e3c\0\u9e88\0\u9ed4\0\u9f20\0\u9f6c\0\u9fb8\0\ua004\0\ua050"+
    "\0\ua09c\0\ua0e8\0\ua134\0\ua180\0\ua1cc\0\ua218\0\ua264\0\ua2b0"+
    "\0\ua2fc\0\ua348\0\ua394\0\ua3e0\0\ua42c\0\u7330\0\ua478\0\ua4c4"+
    "\0\ua510\0\ua55c\0\ua5a8\0\ua5f4\0\ua640\0\ua68c\0\ua6d8\0\ua724"+
    "\0\ua770\0\ua7bc\0\ua808\0\ua854\0\ua8a0\0\ua8ec\0\ua938\0\ua984"+
    "\0\ua9d0\0\uaa1c\0\uaa68\0\uaab4\0\u0558\0\uab00";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[646];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\24\1\25"+
    "\1\27\1\30\2\21\2\24\1\31\1\32\4\24\1\33"+
    "\1\34\1\35\1\36\1\37\1\40\1\41\1\32\1\42"+
    "\2\32\1\43\1\44\1\45\2\43\1\46\1\47\1\50"+
    "\1\51\1\52\1\53\1\54\1\55\1\56\1\57\1\60"+
    "\1\61\1\62\1\24\1\63\1\64\1\24\1\65\1\66"+
    "\1\67\1\70\1\71\2\24\1\35\1\22\1\36\1\72"+
    "\1\35\4\24\2\35\1\73\1\24\1\74\1\75\1\76"+
    "\2\77\1\100\10\77\1\101\63\77\1\102\14\77\2\103"+
    "\1\104\10\103\1\105\73\103\1\106\4\103\2\107\1\110"+
    "\14\107\1\111\41\107\1\112\1\107\1\113\4\107\1\114"+
    "\23\107\2\115\1\116\14\115\1\117\11\115\1\120\13\115"+
    "\1\121\13\115\1\122\1\115\1\123\4\115\1\124\3\115"+
    "\1\125\17\115\2\126\1\127\56\126\1\130\1\126\1\131"+
    "\4\126\1\132\23\126\1\133\1\134\1\135\26\133\1\136"+
    "\6\133\1\137\34\133\1\22\1\140\15\133\2\141\1\142"+
    "\21\141\1\143\34\141\1\144\1\141\1\145\4\141\1\146"+
    "\23\141\2\147\1\150\34\147\1\151\54\147\2\152\1\153"+
    "\26\152\1\154\2\152\1\155\43\152\1\156\4\152\1\157"+
    "\6\152\1\160\1\161\1\0\13\160\1\162\13\160\1\43"+
    "\1\160\1\163\40\160\1\22\1\160\1\164\7\160\1\165"+
    "\4\160\77\166\1\167\14\166\107\170\1\167\4\170\105\171"+
    "\1\172\6\171\2\173\1\174\10\173\1\175\1\173\1\176"+
    "\75\173\1\177\2\200\1\201\12\200\1\202\10\200\1\203"+
    "\65\200\1\21\2\0\6\21\1\0\4\21\2\0\4\21"+
    "\20\0\30\21\5\0\4\21\3\0\3\21\2\0\1\22"+
    "\73\0\1\22\132\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\26\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\205\2\0\1\205"+
    "\2\25\1\205\1\25\1\205\1\0\4\205\2\0\1\205"+
    "\1\206\1\207\1\210\1\0\1\211\16\0\10\205\1\210"+
    "\1\206\7\205\1\207\2\205\1\207\3\205\5\0\1\205"+
    "\1\207\2\205\3\0\3\205\1\0\1\205\2\0\1\205"+
    "\1\212\1\213\1\205\1\213\1\205\1\0\4\205\2\0"+
    "\1\214\1\206\1\207\1\210\1\0\1\211\16\0\10\205"+
    "\1\210\1\206\7\205\1\207\2\205\1\207\1\205\1\214"+
    "\1\205\5\0\1\205\1\207\2\205\3\0\3\205\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\12\24\1\215\13\24\5\0"+
    "\4\24\3\0\3\24\1\0\13\216\1\217\2\216\1\220"+
    "\1\221\12\216\1\222\61\216\32\0\1\43\105\0\1\43"+
    "\5\0\1\43\65\0\2\211\1\0\1\211\134\0\1\43"+
    "\1\0\1\223\112\0\1\224\1\43\62\0\1\225\27\0"+
    "\1\226\1\43\42\0\1\225\50\0\1\43\1\0\1\227"+
    "\111\0\1\43\5\0\1\43\105\0\1\43\6\0\1\43"+
    "\52\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\14\24\1\230\11\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\1\231"+
    "\2\21\1\231\1\21\1\231\1\0\4\21\2\0\4\231"+
    "\20\0\1\231\1\21\26\231\5\0\4\231\3\0\3\231"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\1\24\1\232\1\233"+
    "\7\24\1\234\2\24\1\235\10\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\4\24\1\236"+
    "\7\24\1\237\4\24\1\240\4\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\5\24\1\241\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\3\24"+
    "\1\242\7\24\1\243\1\24\1\244\3\24\1\245\4\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\4\24\1\246\6\24\1\247\5\24\1\250\4\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\6\24\1\251\17\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\1\252\6\24\1\253"+
    "\3\24\1\254\1\255\11\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\1\256\1\24\1\257"+
    "\4\24\1\260\2\24\1\261\10\24\1\262\1\263\1\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\6\24\1\264\5\24\1\265\11\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\266\1\21\2\24"+
    "\1\267\7\24\1\270\7\24\1\271\3\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\14\24"+
    "\1\272\11\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\5\24\1\273\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\274\5\24\1\275\17\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\22\24\1\271\3\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\10\24\1\276\2\24"+
    "\1\277\12\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\6\24\1\300\5\24\1\301\11\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\5\24"+
    "\1\302\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\1\303\3\24\1\304\21\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\10\24"+
    "\1\305\15\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\5\24\1\306\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\307\6\24\1\310\1\311"+
    "\3\24\1\312\11\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\312\13\24\1\313\11\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\314\25\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\12\24\1\315\13\24\5\0"+
    "\4\24\3\0\3\24\1\0\2\77\1\0\10\77\1\0"+
    "\63\77\1\0\14\77\2\316\1\0\5\316\1\317\61\316"+
    "\1\320\21\316\2\103\1\0\10\103\1\0\73\103\1\0"+
    "\4\103\2\107\1\0\14\107\1\0\41\107\1\0\1\107"+
    "\1\0\4\107\1\0\23\107\16\0\1\321\146\0\1\322"+
    "\125\0\1\323\101\0\1\324\4\0\1\325\35\0\2\115"+
    "\1\0\14\115\1\0\11\115\1\0\13\115\1\0\13\115"+
    "\1\0\1\115\1\0\4\115\1\0\3\115\1\0\17\115"+
    "\16\0\1\326\100\0\1\327\2\0\1\327\1\0\1\327"+
    "\5\0\1\330\1\0\4\327\10\0\1\331\7\0\1\327"+
    "\1\0\26\327\5\0\4\327\3\0\3\327\45\0\1\332"+
    "\1\0\1\333\1\334\1\335\1\336\1\337\1\340\1\341"+
    "\1\342\1\343\1\344\1\345\3\0\1\346\1\347\1\350"+
    "\1\0\1\351\1\352\73\0\1\353\125\0\1\354\101\0"+
    "\1\355\4\0\1\356\102\0\1\357\46\0\2\126\1\0"+
    "\56\126\1\0\1\126\1\0\4\126\1\0\23\126\51\0"+
    "\1\360\125\0\1\361\101\0\1\362\4\0\1\363\35\0"+
    "\2\133\1\0\26\133\1\0\6\133\1\0\34\133\2\0"+
    "\16\133\1\134\1\0\26\133\1\0\6\133\1\0\34\133"+
    "\1\22\1\0\15\133\3\0\1\364\2\0\1\364\1\0"+
    "\1\364\3\0\1\364\1\0\1\365\1\0\4\364\12\0"+
    "\1\366\1\367\2\0\1\364\1\0\1\364\1\0\26\364"+
    "\5\0\4\364\3\0\3\364\1\0\75\137\1\0\1\370"+
    "\15\137\2\141\1\0\21\141\1\0\34\141\1\0\1\141"+
    "\1\0\4\141\1\0\23\141\24\0\1\371\140\0\1\372"+
    "\125\0\1\373\101\0\1\374\4\0\1\375\35\0\2\147"+
    "\1\0\34\147\1\0\54\147\34\0\1\376\57\0\2\152"+
    "\1\0\26\152\1\0\2\152\1\0\43\152\1\0\4\152"+
    "\1\0\6\152\36\0\1\377\55\0\2\160\1\0\13\160"+
    "\1\0\13\160\1\0\1\160\1\0\40\160\1\0\1\160"+
    "\1\0\7\160\1\0\5\160\1\161\1\0\13\160\1\0"+
    "\13\160\1\0\1\160\1\0\40\160\1\22\1\160\1\0"+
    "\7\160\1\0\4\160\34\0\1\163\57\0\77\166\1\0"+
    "\14\166\107\170\1\0\4\170\105\171\1\0\6\171\105\0"+
    "\1\u0100\6\0\2\173\1\0\10\173\1\0\1\173\1\0"+
    "\75\173\75\0\1\u0101\17\0\2\200\1\0\12\200\1\0"+
    "\10\200\1\0\65\200\74\0\1\u0102\17\0\1\21\2\0"+
    "\5\21\1\u0103\1\0\4\21\2\0\4\21\20\0\30\21"+
    "\5\0\4\21\3\0\3\21\1\0\1\205\2\0\6\205"+
    "\1\0\4\205\2\0\4\205\20\0\30\205\5\0\4\205"+
    "\3\0\3\205\1\0\1\205\2\0\1\205\2\u0104\1\205"+
    "\1\u0104\1\205\1\0\4\205\2\0\4\205\1\u0105\3\0"+
    "\1\u0105\13\0\30\205\5\0\4\205\3\0\3\205\1\0"+
    "\1\205\2\0\1\205\2\211\1\205\1\211\1\205\1\0"+
    "\4\205\2\0\2\205\1\207\1\210\20\0\10\205\1\210"+
    "\10\205\1\207\2\205\1\207\3\205\5\0\1\205\1\207"+
    "\2\205\3\0\3\205\1\0\1\205\2\0\1\205\2\212"+
    "\1\205\1\212\1\205\1\0\4\205\2\0\2\205\1\207"+
    "\1\210\1\0\1\211\16\0\10\205\1\210\10\205\1\207"+
    "\2\205\1\207\3\205\5\0\1\205\1\207\2\205\3\0"+
    "\3\205\1\0\1\205\2\0\1\205\1\212\1\213\1\205"+
    "\1\213\1\205\1\0\4\205\2\0\1\205\1\u0106\1\207"+
    "\1\210\1\0\1\211\16\0\10\205\1\210\1\u0106\7\205"+
    "\1\207\2\205\1\207\3\205\5\0\1\205\1\207\2\205"+
    "\3\0\3\205\1\0\1\205\2\0\1\205\4\u0107\1\205"+
    "\1\0\4\205\2\0\2\205\2\u0107\20\0\2\205\2\u0107"+
    "\3\205\2\u0107\10\205\1\u0107\2\205\1\u0107\3\205\5\0"+
    "\3\u0107\1\205\3\0\3\205\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\6\24\1\u0108\17\24\5\0\4\24\3\0\3\24"+
    "\1\0\13\216\1\217\2\216\1\u0109\77\216\1\0\111\216"+
    "\17\0\1\u010a\75\0\1\225\27\0\1\226\43\0\1\225"+
    "\47\0\2\43\113\0\1\43\1\0\1\32\57\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\17\24\1\u010b\6\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\231\1\0\4\21"+
    "\2\0\4\231\20\0\1\231\1\21\26\231\5\0\4\231"+
    "\3\0\3\231\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\2\24"+
    "\1\u010c\23\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\21\24\1\u010d\4\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\21\24"+
    "\1\u010e\4\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\1\u010f\25\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\6\24\1\u0110"+
    "\17\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\14\24\1\u0111\11\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\3\24\1\u0112"+
    "\22\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\20\24\1\u0113\5\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\1\u0114\3\24"+
    "\1\u0115\21\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\14\24\1\u0116\11\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\10\24"+
    "\1\u0117\15\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\12\24\1\u0118\13\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\5\24\1\u0119\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\1\u011a\20\24\1\271\4\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\4\24\1\u011b\3\24"+
    "\1\u011c\15\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\20\24\1\u011d\5\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\3\24"+
    "\1\u011e\22\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\2\24\1\u011f\1\u0120\22\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\1\u0121\25\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\1\u0122\25\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\12\24\1\u0123"+
    "\13\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\5\24\1\u0124\20\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\5\24\1\u0125"+
    "\20\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\2\24\1\u011f\23\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\5\24\1\u0126\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\26\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\u0127\25\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\3\24\1\u0128\14\24\1\u0129"+
    "\5\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\3\24\1\271\22\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\12\24\1\u012a"+
    "\13\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\20\24\1\u012b\5\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\2\24\1\u012c\1\24\20\0\1\24\1\21"+
    "\26\24\5\0\4\24\3\0\1\24\1\u012d\1\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\2\24\1\u012e\1\u012f\22\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u0130\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\u0131\1\21\7\24\1\u0132\16\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u0133\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\15\24\1\271\10\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u0134\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\10\24\1\u0135\15\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\24\1\u0136\5\24\1\u0137\12\24\1\u0138\3\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\5\24"+
    "\1\u0139\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\26\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\24\1\u013a\24\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\4\24\1\u013b\1\u013c\20\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\10\24\1\u013d\3\24"+
    "\1\u013e\11\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\6\24\1\u013f\17\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\12\24"+
    "\1\u0140\13\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\7\24\1\u0141\16\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\14\24"+
    "\1\u0142\11\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\12\24\1\u0143\13\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\4\24"+
    "\1\271\21\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\7\24\1\u0144\1\u0145\15\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\26\24\5\0\4\24\3\0\1\24\1\271\1\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\22\24\1\u0146\3\24\5\0"+
    "\4\24\3\0\3\24\5\0\4\u0147\12\0\2\u0147\22\0"+
    "\2\u0147\3\0\2\u0147\10\0\1\u0147\2\0\1\u0147\10\0"+
    "\3\u0147\14\0\4\u0148\12\0\2\u0148\22\0\2\u0148\3\0"+
    "\2\u0148\10\0\1\u0148\2\0\1\u0148\10\0\3\u0148\61\0"+
    "\1\u0149\125\0\1\u014a\116\0\1\u014b\102\0\1\u014c\36\0"+
    "\34\327\1\331\57\327\3\0\1\327\2\0\1\327\1\0"+
    "\1\327\7\0\4\327\10\0\1\331\7\0\1\327\1\0"+
    "\26\327\5\0\4\327\3\0\3\327\55\0\1\u014d\1\0"+
    "\1\u014e\3\0\1\u014f\41\0\1\u0150\36\0\1\u0151\3\0"+
    "\1\u0152\1\0\1\u0153\120\0\1\u0154\41\0\1\u0155\40\0"+
    "\1\u0156\2\0\1\u0157\1\0\1\u0158\116\0\1\u0159\1\u015a"+
    "\4\0\1\u015b\100\0\1\u015c\105\0\1\u015d\6\0\1\u015e"+
    "\4\0\1\u015f\111\0\1\u0160\10\0\1\u0161\1\u0162\75\0"+
    "\1\u0163\1\0\1\u0164\114\0\1\u0165\1\u0166\110\0\1\u0167"+
    "\104\0\1\u0168\123\0\1\u0169\111\0\1\u016a\47\0\1\u016b"+
    "\35\0\1\u016c\3\0\1\u016d\117\0\1\u016e\103\0\1\u016f"+
    "\5\0\1\u0170\110\0\1\u0171\125\0\1\u0172\116\0\1\u0173"+
    "\102\0\1\u0174\107\0\1\u0175\3\0\1\u0176\107\0\1\u0177"+
    "\125\0\1\u0178\116\0\1\u0179\102\0\1\u017a\41\0\6\364"+
    "\3\0\1\364\3\0\6\364\14\0\1\364\1\0\1\364"+
    "\1\0\26\364\5\0\4\364\3\0\3\364\4\0\1\u017b"+
    "\2\0\1\u017b\1\0\1\u017b\3\0\1\u017b\3\0\4\u017b"+
    "\16\0\1\u017b\1\0\1\u017b\1\0\26\u017b\5\0\4\u017b"+
    "\3\0\3\u017b\25\0\1\u017c\53\0\1\u017d\47\0\1\u017e"+
    "\130\0\1\u017f\125\0\1\u0180\116\0\1\u0181\102\0\1\u0182"+
    "\62\0\1\u0183\123\0\1\u0184\57\0\1\21\2\0\1\21"+
    "\4\u0185\1\21\1\0\4\21\2\0\2\21\2\u0185\20\0"+
    "\2\21\2\u0185\3\21\2\u0185\10\21\1\u0185\2\21\1\u0185"+
    "\3\21\5\0\3\u0185\1\21\3\0\3\21\1\0\1\205"+
    "\2\0\1\205\2\u0104\1\205\1\u0104\1\205\1\0\4\205"+
    "\2\0\2\205\1\207\1\205\20\0\21\205\1\207\2\205"+
    "\1\207\3\205\5\0\1\205\1\207\2\205\3\0\3\205"+
    "\5\0\2\u0104\1\0\1\u0104\104\0\1\205\2\0\1\205"+
    "\4\u0107\1\205\1\0\4\205\2\0\1\205\1\u0106\2\u0107"+
    "\20\0\2\205\2\u0107\3\205\2\u0107\1\u0106\7\205\1\u0107"+
    "\2\205\1\u0107\3\205\5\0\3\u0107\1\205\3\0\3\205"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\2\24\1\257\23\24"+
    "\5\0\4\24\3\0\3\24\45\0\1\u0109\11\0\2\u0109"+
    "\52\0\1\u0186\75\0\1\21\2\0\5\24\1\u0135\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\26\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\3\24\1\u0187\22\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\12\24\1\u0188"+
    "\13\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\10\24\1\264\15\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\1\u0189\25\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\7\24\1\u018a\16\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\6\24\1\u010e\17\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\6\24\1\312\17\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\3\24\1\u018b\22\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\10\24\1\265\15\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\4\24\1\u018c\21\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u0120\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\5\24\1\u018d\20\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\6\24\1\u018e\17\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\12\24\1\u018f\13\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\14\24\1\u0190\11\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\2\24\1\271\23\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\6\24\1\u0191\17\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\5\24\1\u0192\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\26\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\6\24\1\271\17\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\5\24\1\u0134\20\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\2\24\1\u011c\23\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\4\24\1\u010e\21\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\2\24\1\264\1\u0193\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\13\24\1\u0194\12\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\u0195\25\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\271\1\21\26\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\7\24\1\u0196"+
    "\16\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\6\24\1\u0197\17\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\14\24\1\u0198"+
    "\11\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\11\24\1\u010e\14\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\7\24\1\u0199"+
    "\4\24\1\u0198\11\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\10\24\1\u019a\15\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\1\u019b\25\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\3\24\1\u019c\22\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\6\24"+
    "\1\u019d\17\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\14\24\1\271\11\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\1\24"+
    "\1\u019e\24\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\7\24\1\271\16\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\10\24"+
    "\1\u019f\15\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\13\24\1\271\12\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\7\24"+
    "\1\u011f\16\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\5\24\1\u01a0\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\26\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\6\24\1\u01a1"+
    "\17\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\1\u01a2\25\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\1\24\1\u01a3\24\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\7\24\1\u018b\16\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\2\24\1\u01a4\23\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\16\24\1\u01a5\7\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\23\24\1\u01a6\2\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u01a7\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\7\24\1\u0145\16\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\5\24\1\u01a8\20\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\2\24\1\u0119\23\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\u018c\25\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\u01a9\25\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\1\u01aa"+
    "\25\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\17\24\1\271\6\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\10\24\1\u01ab"+
    "\15\24\5\0\4\24\3\0\3\24\5\0\4\u01ac\12\0"+
    "\2\u01ac\22\0\2\u01ac\3\0\2\u01ac\10\0\1\u01ac\2\0"+
    "\1\u01ac\10\0\3\u01ac\14\0\4\u01ad\12\0\2\u01ad\22\0"+
    "\2\u01ad\3\0\2\u01ad\10\0\1\u01ad\2\0\1\u01ad\10\0"+
    "\3\u01ad\76\0\1\u01ae\52\0\1\u01af\130\0\1\u01b0\125\0"+
    "\1\u014b\103\0\1\u01b1\4\0\1\u01b2\134\0\1\u01b3\106\0"+
    "\1\u01b4\77\0\1\u01b5\5\0\1\u01b6\104\0\1\u01b7\116\0"+
    "\1\u01b8\116\0\1\u01b9\107\0\1\u01ba\105\0\1\u01bb\115\0"+
    "\1\u01bc\121\0\1\u01bd\117\0\1\u01be\105\0\1\u01bf\3\0"+
    "\1\u01c0\122\0\1\u01c1\114\0\1\u01c2\73\0\1\u01c3\2\0"+
    "\1\u01c4\21\0\1\u01c5\75\0\1\u01c6\104\0\1\u01c7\125\0"+
    "\1\u01c8\5\0\1\u01c9\35\0\1\u01ca\157\0\1\u01cb\105\0"+
    "\1\u01cc\2\0\1\u01cd\14\0\1\u01ce\105\0\1\u01cf\106\0"+
    "\1\u01d0\4\0\1\u01d1\113\0\1\u01d2\103\0\1\u01d3\7\0"+
    "\1\u01d4\115\0\1\u01d5\75\0\1\u01d6\127\0\1\u01d7\103\0"+
    "\1\u01d8\15\0\1\u01d9\1\0\1\u01da\72\0\1\u01db\116\0"+
    "\1\u01dc\117\0\1\u01dd\3\0\1\u01de\103\0\1\u01df\2\0"+
    "\1\u0157\110\0\1\u01e0\113\0\1\u01e1\127\0\1\u01e2\52\0"+
    "\1\u01e3\130\0\1\u01e4\125\0\1\u0173\47\0\1\u01e5\161\0"+
    "\1\u01e6\123\0\1\u01e7\52\0\1\u01e8\130\0\1\u01e9\125\0"+
    "\1\u0179\42\0\6\u017b\3\0\1\u017b\3\0\6\u017b\14\0"+
    "\1\u017b\1\0\1\u017b\1\0\26\u017b\5\0\4\u017b\3\0"+
    "\3\u017b\25\0\1\u01ea\170\0\1\u01eb\100\0\1\u01ec\52\0"+
    "\1\u01ed\130\0\1\u01ee\125\0\1\u0181\63\0\1\u01ef\67\0"+
    "\1\21\2\0\1\21\4\u01f0\1\21\1\0\4\21\2\0"+
    "\2\21\2\u01f0\20\0\2\21\2\u01f0\3\21\2\u01f0\10\21"+
    "\1\u01f0\2\21\1\u01f0\3\21\5\0\3\u01f0\1\21\3\0"+
    "\3\21\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\4\24\1\u01f1"+
    "\21\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\5\24\1\271\20\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\16\24\1\271"+
    "\7\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\6\24\1\u01f2\17\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\10\24\1\u0188"+
    "\15\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\3\24\1\u010e\22\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\13\24\1\u01f3"+
    "\12\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\2\24\1\u01f4\23\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\15\24\1\u01f5"+
    "\10\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\14\24\1\63\11\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\4\24\1\u01f6"+
    "\21\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\10\24\1\u01f7\15\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\20\24\1\u01f8"+
    "\5\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\12\24\1\u01f9\13\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\4\24\1\264"+
    "\21\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\6\24\1\u01fa\17\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\12\24\1\u01fb"+
    "\13\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\26\24\5\0\4\24\3\0\1\24\1\u0196"+
    "\1\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\1\u01fc\25\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\4\24\1\u01fd\21\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\6\24\1\u0122\17\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\23\24\1\u011f\2\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\11\24\1\u01fe\14\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u011f\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\5\24\1\u01ff\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\26\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\7\24\1\u0112\16\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\6\24\1\u0200\17\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\1\u0201\25\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\1\u01a1\25\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\6\24\1\u0202"+
    "\17\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\3\24\1\u0203\22\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\7\24\1\u0204"+
    "\16\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\3\24\1\277\22\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\12\24\1\u0205"+
    "\13\24\5\0\4\24\3\0\3\24\43\0\1\u01b0\5\0"+
    "\1\u014b\46\0\6\u01af\1\0\1\u0206\1\0\1\u0206\2\u01af"+
    "\1\u0206\4\u01af\2\u0206\1\0\2\u0206\1\0\1\u0206\2\0"+
    "\4\u0206\1\0\2\u0206\1\u01af\1\u0206\26\u01af\2\0\1\u0206"+
    "\1\0\1\u0206\4\u01af\3\u0206\3\u01af\17\0\1\u0207\144\0"+
    "\1\u0208\125\0\1\u0209\106\0\1\u01c0\1\0\1\u020a\45\0"+
    "\1\u020b\164\0\1\u020c\76\0\1\u020d\120\0\1\u020e\116\0"+
    "\1\u020f\105\0\1\u01c0\117\0\1\u01bf\105\0\1\u0210\120\0"+
    "\1\u0211\115\0\1\u0157\122\0\1\u0212\101\0\1\u01bd\125\0"+
    "\1\u01bd\105\0\1\u0213\124\0\1\u0214\36\0\1\u0215\113\0"+
    "\1\u0216\160\0\1\u0217\106\0\1\u0218\113\0\1\u0219\132\0"+
    "\1\u021a\70\0\1\u01bd\127\0\1\u021b\77\0\1\u021c\123\0"+
    "\1\u021d\121\0\1\u021e\116\0\1\u01c0\102\0\1\u021f\123\0"+
    "\1\u01bd\111\0\1\u0220\102\0\1\u0221\116\0\1\u0222\106\0"+
    "\1\u0223\120\0\1\u0224\124\0\1\u01bd\101\0\1\u01bd\112\0"+
    "\1\u0225\107\0\1\u0226\122\0\1\u0211\104\0\1\u01ca\136\0"+
    "\1\u0227\73\0\1\u0228\14\0\1\u0229\101\0\1\u01c0\115\0"+
    "\1\u022a\105\0\1\u022b\105\0\1\u01e4\5\0\1\u0173\46\0"+
    "\6\u01e3\1\0\1\u022c\1\0\1\u022c\2\u01e3\1\u022c\4\u01e3"+
    "\2\u022c\1\0\2\u022c\1\0\1\u022c\2\0\4\u022c\1\0"+
    "\2\u022c\1\u01e3\1\u022c\26\u01e3\2\0\1\u022c\1\0\1\u022c"+
    "\4\u01e3\3\u022c\3\u01e3\17\0\1\u022d\146\0\1\u022e\122\0"+
    "\1\u022f\75\0\1\u01e9\5\0\1\u0179\46\0\6\u01e8\1\0"+
    "\1\u0230\1\0\1\u0230\2\u01e8\1\u0230\4\u01e8\2\u0230\1\0"+
    "\2\u0230\1\0\1\u0230\2\0\4\u0230\1\0\2\u0230\1\u01e8"+
    "\1\u0230\26\u01e8\2\0\1\u0230\1\0\1\u0230\4\u01e8\3\u0230"+
    "\3\u01e8\17\0\1\u0231\177\0\1\u0232\53\0\1\u01ee\5\0"+
    "\1\u0181\46\0\6\u01ed\1\0\1\u0233\1\0\1\u0233\2\u01ed"+
    "\1\u0233\4\u01ed\2\u0233\1\0\2\u0233\1\0\1\u0233\2\0"+
    "\4\u0233\1\0\2\u0233\1\u01ed\1\u0233\26\u01ed\2\0\1\u0233"+
    "\1\0\1\u0233\4\u01ed\3\u0233\3\u01ed\17\0\1\u0234\75\0"+
    "\1\21\2\0\1\21\4\u0235\1\21\1\0\4\21\2\0"+
    "\2\21\2\u0235\20\0\2\21\2\u0235\3\21\2\u0235\10\21"+
    "\1\u0235\2\21\1\u0235\3\21\5\0\3\u0235\1\21\3\0"+
    "\3\21\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\1\u0236\25\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\u0237\25\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\4\24\1\u0238\21\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\10\24\1\u0239\15\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\12\24\1\u023a\13\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\12\24\1\u023b\13\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\6\24\1\u0196\17\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\204\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\17\24\1\u011c\6\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\u023c\1\21\26\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\10\24\1\u023d"+
    "\15\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\12\24\1\u023e\13\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\22\24\1\u023f"+
    "\3\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\11\24\1\u0113\14\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\7\24\1\264"+
    "\16\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\2\24\1\u0240"+
    "\1\24\20\0\1\24\1\21\26\24\5\0\4\24\3\0"+
    "\2\24\1\u0241\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\11\24"+
    "\1\u011f\14\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\5\24\1\u0242\20\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\10\24"+
    "\1\u0243\15\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\7\24\1\u0244\16\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\10\24"+
    "\1\u0245\15\24\5\0\4\24\3\0\3\24\17\0\1\u01af"+
    "\151\0\1\u0246\121\0\1\u01d7\111\0\1\u01bd\110\0\1\u0157"+
    "\120\0\1\u0222\105\0\1\u0247\111\0\1\u0248\111\0\1\u01c0"+
    "\111\0\1\u0249\123\0\1\u01d8\120\0\1\u01c0\115\0\1\u024a"+
    "\110\0\1\u024b\103\0\1\u024c\117\0\1\u024d\104\0\1\u024e"+
    "\114\0\1\u024f\114\0\1\u0250\114\0\1\u0251\112\0\1\u01bd"+
    "\130\0\1\u020b\77\0\1\u0252\113\0\1\u0253\121\0\1\u0254"+
    "\105\0\1\u0157\107\0\1\u0158\117\0\1\u01bd\107\0\1\u0255"+
    "\115\0\1\u0256\117\0\1\u0257\47\0\1\u0258\151\0\1\u0259"+
    "\121\0\1\u025a\113\0\1\u025b\105\0\1\u025c\123\0\1\u025d"+
    "\53\0\1\u01e3\157\0\1\u025e\115\0\1\u025f\45\0\1\u01e8"+
    "\200\0\1\u0260\26\0\1\u01ed\75\0\1\21\2\0\1\21"+
    "\4\24\1\21\1\0\4\21\2\0\2\21\2\24\20\0"+
    "\2\21\2\24\3\21\2\24\10\21\1\24\2\21\1\24"+
    "\3\21\5\0\3\24\1\21\3\0\3\21\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\5\24\1\264\20\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\12\24"+
    "\1\u010e\13\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\14\24\1\u0261\11\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\6\24"+
    "\1\u0262\17\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\5\24\1\u011f\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\26\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\6\24\1\u0263"+
    "\17\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\3\24\1\u01f8\22\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\204"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\5\24\1\u011d"+
    "\20\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\204\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\1\u0264\25\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\7\24\1\u0265\16\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\12\24\1\u0266\13\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\3\24\1\u0267\22\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\14\24\1\u0268\11\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\21\24\1\271\4\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u0244\22\24\5\0\4\24\3\0\3\24"+
    "\53\0\1\u0269\121\0\1\u0253\101\0\1\u026a\117\0\1\u026b"+
    "\115\0\1\u026c\117\0\1\u026d\113\0\1\u026e\105\0\1\u01df"+
    "\107\0\1\u026f\132\0\1\u0270\74\0\1\u01cb\3\0\1\u0271"+
    "\117\0\1\u0272\115\0\1\u0223\104\0\1\u01c0\112\0\1\u0157"+
    "\120\0\1\u01bd\124\0\1\u0273\100\0\1\u0274\115\0\1\u021b"+
    "\107\0\1\u0157\115\0\1\u0275\112\0\1\u0276\112\0\1\u022b"+
    "\124\0\1\u020a\103\0\1\u0277\41\0\26\u025f\1\u01bd\65\u025f"+
    "\104\0\1\u0278\7\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\12\24"+
    "\1\u0279\13\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\12\24\1\264\13\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\12\24"+
    "\1\u027a\13\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\5\24\1\u011f\20\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\14\24"+
    "\1\u027b\11\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\3\24\1\u0196\22\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\204\2\24\2\0\4\24\20\0\1\24\1\21\6\24"+
    "\1\u0145\17\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\204\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\12\24\1\271\13\24\5\0\4\24"+
    "\3\0\3\24\63\0\1\u026c\104\0\1\u021b\127\0\1\u01bd"+
    "\114\0\1\u01bd\100\0\1\u026b\111\0\1\u01d1\114\0\1\u027c"+
    "\47\0\1\u027d\162\0\1\u027e\102\0\1\u01be\113\0\1\u0275"+
    "\116\0\1\u027f\113\0\1\u026b\120\0\1\u0280\140\0\1\u0281"+
    "\10\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\10\24\1\u0282\15\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\204\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u011c\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\204\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\1\u0266\25\24\5\0"+
    "\4\24\3\0\3\24\51\0\1\u01d8\116\0\1\u0283\121\0"+
    "\1\u021b\106\0\1\u01d7\105\0\1\u0284\145\0\1\u0285\13\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\204\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\26\24\5\0\4\24\3\0"+
    "\1\u0267\2\24\52\0\1\u0286\117\0\1\u025f\106\0\1\u01bd"+
    "\11\0\1\u0222\31\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[43852];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\13\0\2\1\3\0\2\1\1\11\4\1\1\11\4\1"+
    "\2\11\4\1\1\11\26\1\2\11\2\1\1\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\1\1\1\11\1\1"+
    "\1\11\5\1\1\11\10\1\1\11\5\1\1\11\2\1"+
    "\1\11\1\1\1\11\5\1\1\11\2\1\1\11\1\1"+
    "\3\11\3\1\3\11\1\1\1\11\4\1\1\11\2\1"+
    "\1\11\1\1\1\11\1\1\1\11\12\1\2\0\1\11"+
    "\4\1\1\0\1\11\67\1\1\11\2\1\1\11\4\0"+
    "\1\11\2\0\1\11\32\0\3\1\2\11\5\0\1\11"+
    "\2\0\2\11\2\1\1\0\101\1\64\0\1\1\2\0"+
    "\1\11\5\0\1\11\1\1\1\11\45\1\1\0\1\11"+
    "\1\0\1\1\15\0\1\11\45\0\1\1\4\0\1\1"+
    "\1\0\1\11\2\0\1\1\1\0\1\11\26\1\15\0"+
    "\1\1\20\0\1\1\20\0\21\1\33\0\11\1\4\0"+
    "\1\1\12\0\3\1\6\0\1\1\2\0\1\11\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[646];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specifying we're in a JavaScript multiline comment.
	 */
	static final int INTERNAL_IN_JS_MLC				= -8;

	/**
	 * Token type specifying we're in a JavaScript documentation comment.
	 */
	static final int INTERNAL_IN_JS_COMMENT_DOCUMENTATION = -9;

	/**
	 * Token type specifying we're in an invalid multi-line JS string.
	 */
	static final int INTERNAL_IN_JS_STRING_INVALID	= -10;

	/**
	 * Token type specifying we're in a valid multi-line JS string.
	 */
	static final int INTERNAL_IN_JS_STRING_VALID		= -11;

	/**
	 * Token type specifying we're in an invalid multi-line JS single-quoted string.
	 */
	static final int INTERNAL_IN_JS_CHAR_INVALID	= -12;

	/**
	 * Token type specifying we're in a valid multi-line JS single-quoted string.
	 */
	static final int INTERNAL_IN_JS_CHAR_VALID		= -13;

	static final int INTERNAL_E4X = -14;

	static final int INTERNAL_E4X_INTAG = -15;

	static final int INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION = -16;

	static final int INTERNAL_IN_E4X_COMMENT = -17;

	static final int INTERNAL_E4X_DTD = -18;

	static final int INTERNAL_E4X_DTD_INTERNAL = -19;

	static final int INTERNAL_E4X_ATTR_SINGLE = -20;

	static final int INTERNAL_E4X_ATTR_DOUBLE = -21;

	static final int INTERNAL_E4X_MARKUP_CDATA = -22;

	/**
	 * Token type specifying we're in a valid multi-line template literal.
	 */
	static final int INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID = -23;

	/**
	 * Token type specifying we're in an invalid multi-line template literal.
	 */
	static final int INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID = -24;

	/**
	 * When in the JS_STRING state, whether the current string is valid.
	 */
	private boolean validJSString;

	/**
	 * Whether we're in an internal DTD.  Only valid if in an e4x DTD.
	 */
	private boolean e4x_inInternalDtd;

	/**
	 * The previous e4x state.  Only valid if in an e4x state.
	 */
	private int e4x_prevState;

	/**
	 * Whether e4x is being highlighted.
	 */
	private static boolean e4xSupported;

	/**
	 * Language state set on JS tokens.  Must be 0.
	 */
	private static final int LANG_INDEX_DEFAULT	= 0;

	/**
	 * Language state set on E4X tokens.
	 */
	private static final int LANG_INDEX_E4X = 1;

	private Stack<Boolean> varDepths;

	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public TypeScriptTokenMaker() {
		super();
	}


	static {
		e4xSupported = true;
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the closest {@link TokenTypes} "standard" token type for a given
	 * "internal" token type (e.g. one whose value is <code>&lt; 0</code>).
	 */
	 @Override
	public int getClosestStandardTokenTypeForInternalType(int type) {
		switch (type) {
			case INTERNAL_IN_JS_MLC:
				return TokenTypes.COMMENT_MULTILINE;
			case INTERNAL_IN_JS_COMMENT_DOCUMENTATION:
				return TokenTypes.COMMENT_DOCUMENTATION;
			case INTERNAL_IN_JS_STRING_INVALID:
			case INTERNAL_IN_JS_STRING_VALID:
			case INTERNAL_IN_JS_CHAR_INVALID:
			case INTERNAL_IN_JS_CHAR_VALID:
				return TokenTypes.LITERAL_STRING_DOUBLE_QUOTE;
			case INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID:
				return TokenTypes.LITERAL_BACKQUOTE;
			case INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID:
				return TokenTypes.ERROR_STRING_DOUBLE;
		}
		return type;
	}


	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	@Override
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;
		validJSString = true;
		e4x_prevState = YYINITIAL;
		e4x_inInternalDtd = false;
		int languageIndex = LANG_INDEX_DEFAULT;

		// Start off in the proper state.
		int state = YYINITIAL;
		switch (initialTokenType) {
			case INTERNAL_IN_JS_MLC:
				state = JS_MLC;
				break;
			case INTERNAL_IN_JS_COMMENT_DOCUMENTATION:
				state = JS_DOCCOMMENT;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_STRING_INVALID:
				state = JS_STRING;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_STRING_VALID:
				state = JS_STRING;
				break;
			case INTERNAL_IN_JS_CHAR_INVALID:
				state = JS_CHAR;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_CHAR_VALID:
				state = JS_CHAR;
				break;
			case INTERNAL_E4X:
				state = E4X;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_INTAG:
				state = E4X_INTAG;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION:
				state = E4X_PI;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD:
				state = E4X_DTD;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD_INTERNAL:
				state = E4X_DTD;
				e4x_inInternalDtd = true;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_SINGLE:
				state = E4X_INATTR_SINGLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_DOUBLE:
				state = E4X_INATTR_DOUBLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_CDATA:
				state = E4X_CDATA;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID:
				state = JS_TEMPLATE_LITERAL;
				validJSString = true;
				break;
			case INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID:
				state = JS_TEMPLATE_LITERAL;
				validJSString = false;
				break;
			default:
				if (initialTokenType<-1024) { // INTERNAL_IN_E4X_COMMENT - prevState
					int main = -(-initialTokenType & 0xffffff00);
					switch (main) {
						default: // Should never happen
						case INTERNAL_IN_E4X_COMMENT:
							state = E4X_COMMENT;
							break;
					}
					e4x_prevState = -initialTokenType&0xff;
					languageIndex = LANG_INDEX_E4X;
				}
				else { // Shouldn't happen
					state = Token.NULL;
				}
		}

		setLanguageIndex(languageIndex);
		start = text.offset;
		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Returns whether e4x is being highlighted.
	 *
	 * @return Whether e4x is being highlighted.
	 * @see #setE4xSupported(boolean)
	 */
	public static boolean isE4xSupported() {
		return e4xSupported;
	}


	/**
	 * Sets whether e4x should be highlighted.  A repaint should be forced on
	 * all <code>RSyntaxTextArea</code>s editing JavaScript if this property
	 * is changed to see the difference.
	 *
	 * @param supported Whether e4x should be highlighted.
	 * @see #isE4xSupported()
	 */
	public static void setE4xSupported(boolean supported) {
		e4xSupported = supported;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public TypeScriptTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public TypeScriptTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 172) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 35:
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_SINGLE);
          }
        case 82: break;
        case 48:
          { int start = zzStartRead;
										int operatorLen = yycharat(0)=='+' ? 2 : 1;
										int yylen = yylength(); // Cache before first addToken() invalidates it
										//System.out.println("'" + yytext() + "': " + yylength() + ", " + (operatorLen+1));
										addToken(zzStartRead,zzStartRead+operatorLen-1, Token.OPERATOR);
										if (yylen>operatorLen+1) {
											//System.out.println((start+operatorLen) + ", " + (zzMarkedPos-2));
											addToken(start+operatorLen,zzMarkedPos-2, Token.WHITESPACE);
										}
										zzStartRead = zzCurrentPos = zzMarkedPos = zzMarkedPos - 1;
										if (isE4xSupported()) {
											// Scanning will continue with "<" as markup tag start
											yybegin(E4X, LANG_INDEX_E4X);
										}
										// Found e4x (or syntax error) but option not enabled;
										// Scanning will continue at "<" as operator
          }
        case 83: break;
        case 34:
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_DOUBLE);
          }
        case 84: break;
        case 43:
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 85: break;
        case 80:
          { addToken(Token.RESERVED_WORD_2);
          }
        case 86: break;
        case 27:
          { addToken(start,zzStartRead-1, Token.MARKUP_DTD); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
          }
        case 87: break;
        case 40:
          { int type = validJSString ? Token.LITERAL_BACKQUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 88: break;
        case 3:
          { addToken(Token.WHITESPACE);
          }
        case 89: break;
        case 18:
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
          }
        case 90: break;
        case 72:
          { addToken(Token.FUNCTION);
          }
        case 91: break;
        case 56:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_MARKUP); start = zzMarkedPos;
          }
        case 92: break;
        case 42:
          { if (!varDepths.empty()) {
								varDepths.pop();
								if (varDepths.empty()) {
									addToken(start,zzStartRead, Token.VARIABLE);
									start = zzMarkedPos;
									yybegin(JS_TEMPLATE_LITERAL);
								}
							}
          }
        case 93: break;
        case 39:
          { /* Skip valid '$' that is not part of template literal expression start */
          }
        case 94: break;
        case 11:
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_TEMPLATE_LITERAL);
          }
        case 95: break;
        case 51:
          { /* Skip all escaped chars. */
          }
        case 96: break;
        case 12:
          { addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 97: break;
        case 77:
          { start = zzStartRead; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 98: break;
        case 68:
          { int temp=zzStartRead; yybegin(E4X); addToken(start,zzStartRead-1, Token.MARKUP_CDATA); addToken(temp,zzMarkedPos-1, Token.MARKUP_CDATA_DELIMITER);
          }
        case 99: break;
        case 61:
          { addToken(start, zzStartRead - 1, Token.LITERAL_BACKQUOTE);
								start = zzMarkedPos-2;
								if (varDepths==null) {
									varDepths = new Stack<>();
								}
								else {
									varDepths.clear();
								}
								varDepths.push(Boolean.TRUE);
								yybegin(JS_TEMPLATE_LITERAL_EXPR);
          }
        case 100: break;
        case 62:
          { varDepths.push(Boolean.TRUE);
          }
        case 101: break;
        case 53:
          { /* Invalid latin-1 character \xXX */ validJSString = false;
          }
        case 102: break;
        case 69:
          { addToken(Token.COMMENT_MULTILINE);
          }
        case 103: break;
        case 59:
          { start = zzMarkedPos-2; yybegin(E4X_PI);
          }
        case 104: break;
        case 36:
          { yybegin(E4X_INTAG); addToken(start,zzStartRead, Token.MARKUP_TAG_ATTRIBUTE_VALUE);
          }
        case 105: break;
        case 14:
          { int type = validJSString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 106: break;
        case 63:
          { boolean highlightedAsRegex = false;
										if (firstToken==null) {
											addToken(Token.REGEX);
											highlightedAsRegex = true;
										}
										else {
											// If this is *likely* to be a regex, based on
											// the previous token, highlight it as such.
											Token t = firstToken.getLastNonCommentNonWhitespaceToken();
											if (RSyntaxUtilities.regexCanFollowInJavaScript(t)) {
												addToken(Token.REGEX);
												highlightedAsRegex = true;
											}
										}
										// If it doesn't *appear* to be a regex, highlight it as
										// individual tokens.
										if (!highlightedAsRegex) {
											int temp = zzStartRead + 1;
											addToken(zzStartRead, zzStartRead, Token.OPERATOR);
											zzStartRead = zzCurrentPos = zzMarkedPos = temp;
										}
          }
        case 107: break;
        case 20:
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 108: break;
        case 24:
          { yybegin(YYINITIAL, LANG_INDEX_DEFAULT); addToken(Token.IDENTIFIER);
          }
        case 109: break;
        case 52:
          { /* Invalid Unicode character \\uXXXX */ validJSString = false;
          }
        case 110: break;
        case 41:
          { // TODO: This isn't right.  The expression and its depth should continue to the next line.
							addToken(start,zzStartRead-1, Token.VARIABLE); addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID); return firstToken;
          }
        case 111: break;
        case 79:
          { int temp = zzStartRead; addToken(start,zzStartRead-1, Token.MARKUP_DTD); start = temp; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 112: break;
        case 71:
          { if(e4xSupported){ addToken(Token.RESERVED_WORD);} else {addToken(Token.IDENTIFIER);}
          }
        case 113: break;
        case 66:
          { int count = yylength();
									addToken(zzStartRead,zzStartRead+1, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-2), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 114: break;
        case 67:
          { int temp = zzMarkedPos; addToken(start,zzStartRead+2, Token.MARKUP_COMMENT); start = temp; yybegin(e4x_prevState);
          }
        case 115: break;
        case 7:
          { addToken(Token.OPERATOR);
          }
        case 116: break;
        case 60:
          { yybegin(E4X); addToken(start,zzStartRead+1, Token.MARKUP_PROCESSING_INSTRUCTION);
          }
        case 117: break;
        case 55:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_DOCUMENTATION);
          }
        case 118: break;
        case 19:
          { addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_IN_JS_COMMENT_DOCUMENTATION); return firstToken;
          }
        case 119: break;
        case 26:
          { addToken(start,zzStartRead-1, Token.MARKUP_PROCESSING_INSTRUCTION); addEndToken(INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
          }
        case 120: break;
        case 5:
          { addToken(Token.IDENTIFIER);
          }
        case 121: break;
        case 73:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 122: break;
        case 49:
          { addToken(isE4xSupported() ? Token.MARKUP_TAG_ATTRIBUTE : Token.ERROR_IDENTIFIER);
          }
        case 123: break;
        case 76:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 124: break;
        case 64:
          { start = zzMarkedPos-3; yybegin(JS_DOCCOMMENT);
          }
        case 125: break;
        case 9:
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_STRING);
          }
        case 126: break;
        case 58:
          { start = zzMarkedPos-2; e4x_inInternalDtd = false; yybegin(E4X_DTD);
          }
        case 127: break;
        case 25:
          { addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
          }
        case 128: break;
        case 10:
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_CHAR);
          }
        case 129: break;
        case 29:
          { e4x_inInternalDtd = true;
          }
        case 130: break;
        case 75:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_DOCUMENTATION); start = zzMarkedPos;
          }
        case 131: break;
        case 47:
          { start = zzMarkedPos-2; yybegin(JS_MLC);
          }
        case 132: break;
        case 45:
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 133: break;
        case 81:
          { addToken(Token.MARKUP_CDATA_DELIMITER); start = zzMarkedPos; yybegin(E4X_CDATA);
          }
        case 134: break;
        case 32:
          { addToken(Token.MARKUP_TAG_DELIMITER); /* Not valid but we'll still accept it */
          }
        case 135: break;
        case 2:
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 136: break;
        case 78:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addHyperlinkToken(temp,zzMarkedPos-1, Token.MARKUP_COMMENT); start = zzMarkedPos;
          }
        case 137: break;
        case 33:
          { yybegin(E4X); addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 138: break;
        case 23:
          { addToken(Token.MARKUP_ENTITY_REFERENCE);
          }
        case 139: break;
        case 70:
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 140: break;
        case 4:
          { addNullToken(); return firstToken;
          }
        case 141: break;
        case 50:
          { addToken(Token.RESERVED_WORD);
          }
        case 142: break;
        case 13:
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
									addEndToken(INTERNAL_IN_JS_STRING_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_STRING_INVALID);
								}
								return firstToken;
          }
        case 143: break;
        case 54:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 144: break;
        case 65:
          { addToken(Token.DATA_TYPE);
          }
        case 145: break;
        case 22:
          { addToken(Token.MARKUP_TAG_DELIMITER); yybegin(E4X_INTAG);
          }
        case 146: break;
        case 8:
          { addToken(Token.SEPARATOR);
          }
        case 147: break;
        case 38:
          { if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_BACKQUOTE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID);
								}
								return firstToken;
          }
        case 148: break;
        case 31:
          { addToken(Token.MARKUP_TAG_ATTRIBUTE);
          }
        case 149: break;
        case 16:
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_INVALID);
								}
								return firstToken;
          }
        case 150: break;
        case 74:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_KEYWORD); start = zzMarkedPos;
          }
        case 151: break;
        case 17:
          { int type = validJSString ? Token.LITERAL_CHAR : Token.ERROR_CHAR; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 152: break;
        case 46:
          { start = zzMarkedPos-2; yybegin(JS_EOL_COMMENT);
          }
        case 153: break;
        case 21:
          { addEndToken(INTERNAL_E4X); return firstToken;
          }
        case 154: break;
        case 57:
          { int count = yylength();
									addToken(zzStartRead,zzStartRead, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-1), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 155: break;
        case 44:
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 156: break;
        case 28:
          { if (!e4x_inInternalDtd) { yybegin(E4X); addToken(start,zzStartRead, Token.MARKUP_DTD); }
          }
        case 157: break;
        case 6:
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 158: break;
        case 30:
          { e4x_inInternalDtd = false;
          }
        case 159: break;
        case 37:
          { if (validJSString) {
									addToken(start, zzStartRead - 1, Token.LITERAL_BACKQUOTE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID);
								}
								else {
									addToken(start,zzStartRead - 1, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID);
								}
								return firstToken;
          }
        case 160: break;
        case 15:
          { addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 161: break;
        case 1:
          {
          }
        case 162: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JS_STRING: {
              addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
            }
            case 647: break;
            case E4X: {
              addEndToken(INTERNAL_E4X); return firstToken;
            }
            case 648: break;
            case E4X_INTAG: {
              addToken(start,zzStartRead-1, INTERNAL_E4X_INTAG); return firstToken;
            }
            case 649: break;
            case E4X_PI: {
              addToken(start,zzStartRead-1, Token.MARKUP_PROCESSING_INSTRUCTION); addEndToken(INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
            }
            case 650: break;
            case JS_MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
            }
            case 651: break;
            case JS_CHAR: {
              addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
            }
            case 652: break;
            case JS_EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 653: break;
            case E4X_COMMENT: {
              addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
            }
            case 654: break;
            case JS_DOCCOMMENT: {
              yybegin(YYINITIAL); addToken(start,zzEndRead, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_IN_JS_COMMENT_DOCUMENTATION); return firstToken;
            }
            case 655: break;
            case E4X_DTD: {
              addToken(start,zzStartRead-1, Token.MARKUP_DTD); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
            }
            case 656: break;
            case JS_TEMPLATE_LITERAL: {
              if (validJSString) {
									addToken(start, zzStartRead - 1, Token.LITERAL_BACKQUOTE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID);
								}
								else {
									addToken(start,zzStartRead - 1, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID);
								}
								return firstToken;
            }
            case 657: break;
            case E4X_INATTR_SINGLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_SINGLE); return firstToken;
            }
            case 658: break;
            case E4X_INATTR_DOUBLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_DOUBLE); return firstToken;
            }
            case 659: break;
            case JS_TEMPLATE_LITERAL_EXPR: {
              // TODO: This isn't right.  The expression and its depth should continue to the next line.
							addToken(start,zzStartRead-1, Token.VARIABLE); addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID); return firstToken;
            }
            case 660: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 661: break;
            case E4X_CDATA: {
              addToken(start,zzStartRead-1, Token.MARKUP_CDATA); addEndToken(INTERNAL_E4X_MARKUP_CDATA); return firstToken;
            }
            case 662: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
