/* The following code was generated by JFlex 1.4.1 on 3/11/12 12:58 AM */

/*
 * 01/26/2008
 *
 * PerlTokenMaker.java - Scanner for Perl
 *
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for Perl.<p>
 *
 * This implementation was created using
 * <a href="https://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>), so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>PerlTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class PerlTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int HEREDOC_EOF_SINGLE_QUOTED = 5;
  public static final int HEREDOC_EOT_SINGLE_QUOTED = 7;
  public static final int HEREDOC_EOT_UNQUOTED = 6;
  public static final int STRING = 1;
  public static final int BACKTICKS = 3;
  public static final int YYINITIAL = 0;
  public static final int HEREDOC_EOF_UNQUOTED = 4;
  public static final int CHAR_LITERAL = 2;
  public static final int POD = 8;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\12\1\11\1\0\1\12\1\6\22\0\1\12\1\46\1\102"+
    "\1\7\1\26\1\24\1\50\1\53\1\21\1\25\1\33\1\41\1\22"+
    "\1\17\1\20\1\32\1\3\1\61\1\62\1\61\1\61\3\5\2\2"+
    "\1\22\1\22\1\42\1\43\1\45\1\47\1\23\3\4\1\15\1\16"+
    "\1\104\5\1\1\14\2\1\1\103\4\1\1\105\3\1\1\13\2\1"+
    "\1\21\1\10\1\21\1\44\1\1\1\31\1\60\1\70\1\35\1\40"+
    "\1\57\1\74\1\72\1\56\1\65\1\101\1\71\1\37\1\67\1\73"+
    "\1\55\1\54\1\76\1\64\1\34\1\66\1\75\1\63\1\77\1\36"+
    "\1\100\1\1\1\27\1\52\1\30\1\51\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\11\0\1\1\1\2\2\3\1\1\1\4\1\5\1\6"+
    "\1\7\1\2\1\10\1\2\1\1\1\7\1\10\1\1"+
    "\1\11\2\7\5\2\10\7\1\12\24\2\1\13\1\14"+
    "\1\15\1\16\3\14\1\17\1\14\1\20\1\21\1\22"+
    "\1\14\1\23\3\14\1\24\1\14\1\25\5\14\1\26"+
    "\1\14\1\27\1\14\1\30\2\14\1\31\1\14\1\32"+
    "\1\3\1\33\1\32\1\33\1\32\1\34\1\32\1\4"+
    "\1\35\1\36\1\1\1\0\1\36\1\0\3\36\3\0"+
    "\1\7\1\0\2\2\2\0\22\2\1\37\1\2\1\40"+
    "\2\2\1\40\4\2\10\0\1\7\7\2\1\40\31\2"+
    "\1\1\1\0\1\2\2\0\1\2\1\37\6\2\1\40"+
    "\2\2\1\37\1\40\14\2\1\1\3\0\1\2\1\15"+
    "\1\41\1\14\1\0\2\41\1\0\1\20\1\42\1\14"+
    "\1\0\2\42\1\0\1\14\1\43\1\14\1\0\2\43"+
    "\1\0\3\14\10\0\1\33\1\0\2\34\1\0\1\44"+
    "\1\0\1\2\2\0\14\2\1\40\6\2\1\37\15\2"+
    "\15\0\33\2\1\37\1\2\1\0\2\45\7\2\1\40"+
    "\10\2\1\1\3\0\5\2\1\0\1\1\5\0\1\46"+
    "\1\0\1\46\11\0\1\45\10\2\1\37\26\2\4\0"+
    "\1\47\5\0\1\37\11\2\1\37\5\2\1\37\17\2"+
    "\1\0\4\45\2\2\1\37\1\2\1\0\2\45\1\50"+
    "\1\51\5\0\16\2\1\37\2\2\1\52\1\53\6\0"+
    "\2\2\1\37\25\2\1\45\2\2\3\0\1\37\7\2"+
    "\7\0\14\2\1\0\4\2\1\54\1\55\1\0\10\2"+
    "\1\0\1\2\1\0\4\2\1\0\12\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[601];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\106\0\214\0\322\0\u0118\0\u015e\0\u01a4\0\u01ea"+
    "\0\u0230\0\u0276\0\u02bc\0\u0302\0\u0348\0\u038e\0\u03d4\0\u038e"+
    "\0\u041a\0\u0460\0\u04a6\0\u038e\0\u038e\0\u04ec\0\u0532\0\u0578"+
    "\0\u05be\0\u038e\0\u0604\0\u064a\0\u0690\0\u06d6\0\u071c\0\u0762"+
    "\0\u07a8\0\u07ee\0\u0834\0\u087a\0\u08c0\0\u0906\0\u094c\0\u038e"+
    "\0\u0992\0\u038e\0\u09d8\0\u0a1e\0\u0a64\0\u0aaa\0\u0af0\0\u0b36"+
    "\0\u0b7c\0\u0bc2\0\u0c08\0\u0c4e\0\u0c94\0\u0cda\0\u0d20\0\u0d66"+
    "\0\u0dac\0\u0df2\0\u0e38\0\u0e7e\0\u0ec4\0\u0f0a\0\u038e\0\u0f50"+
    "\0\u0f96\0\u038e\0\u0fdc\0\u1022\0\u1068\0\u038e\0\u10ae\0\u10f4"+
    "\0\u038e\0\u038e\0\u113a\0\u038e\0\u1180\0\u11c6\0\u120c\0\u038e"+
    "\0\u1252\0\u038e\0\u1298\0\u12de\0\u1324\0\u136a\0\u13b0\0\u038e"+
    "\0\u13f6\0\u038e\0\u143c\0\u038e\0\u1482\0\u14c8\0\u038e\0\u150e"+
    "\0\u1554\0\u1554\0\u1554\0\u159a\0\u15e0\0\u1626\0\u166c\0\u16b2"+
    "\0\u16f8\0\u173e\0\u1784\0\u17ca\0\u1810\0\u1856\0\u189c\0\u0276"+
    "\0\u038e\0\u17ca\0\u18e2\0\u1928\0\u196e\0\u1928\0\u19b4\0\u19fa"+
    "\0\u1a40\0\u1a86\0\u1acc\0\u1b12\0\u1b58\0\u1b9e\0\u1be4\0\u1c2a"+
    "\0\u1c70\0\u1cb6\0\u1cfc\0\u1d42\0\u1d88\0\u1dce\0\u1e14\0\u1e5a"+
    "\0\u1ea0\0\u1ee6\0\u1f2c\0\u1f72\0\u1fb8\0\u1ffe\0\u2044\0\u208a"+
    "\0\u20d0\0\u2116\0\u02bc\0\u215c\0\u21a2\0\u21e8\0\u222e\0\u2274"+
    "\0\u22ba\0\u2300\0\u2346\0\u238c\0\u23d2\0\u2418\0\u245e\0\u24a4"+
    "\0\u24ea\0\u2530\0\u2576\0\u25bc\0\u2602\0\u2648\0\u268e\0\u26d4"+
    "\0\u271a\0\u2760\0\u27a6\0\u27ec\0\u2832\0\u2878\0\u28be\0\u2904"+
    "\0\u294a\0\u2990\0\u29d6\0\u2a1c\0\u2a62\0\u2aa8\0\u2aee\0\u2b34"+
    "\0\u2b7a\0\u2bc0\0\u2c06\0\u2c4c\0\u2c92\0\u2cd8\0\u2d1e\0\u2d64"+
    "\0\u2daa\0\u2df0\0\u2e36\0\u2e7c\0\u2ec2\0\u2f08\0\u2f4e\0\u02bc"+
    "\0\u2f94\0\u2fda\0\u3020\0\u3066\0\u30ac\0\u30f2\0\u3138\0\u317e"+
    "\0\u31c4\0\u320a\0\u3250\0\u3296\0\u32dc\0\u3322\0\u3368\0\u33ae"+
    "\0\u33f4\0\u343a\0\u3480\0\u34c6\0\u350c\0\u3552\0\u3598\0\u35de"+
    "\0\u3624\0\u366a\0\u36b0\0\u36f6\0\u038e\0\u373c\0\u3782\0\u37c8"+
    "\0\u038e\0\u3782\0\u380e\0\u038e\0\u3854\0\u389a\0\u38e0\0\u038e"+
    "\0\u389a\0\u3926\0\u396c\0\u39b2\0\u39f8\0\u3a3e\0\u038e\0\u39f8"+
    "\0\u3a84\0\u3aca\0\u3b10\0\u3b56\0\u3b9c\0\u3be2\0\u3c28\0\u3c6e"+
    "\0\u3cb4\0\u3cfa\0\u3d40\0\u3d86\0\u3dcc\0\u3e12\0\u1554\0\u3e58"+
    "\0\u3e9e\0\u3ee4\0\u3f2a\0\u3f70\0\u3fb6\0\u3ffc\0\u4042\0\u4088"+
    "\0\u40ce\0\u4114\0\u415a\0\u41a0\0\u41e6\0\u422c\0\u4272\0\u42b8"+
    "\0\u26d4\0\u42fe\0\u4344\0\u438a\0\u43d0\0\u4416\0\u445c\0\u44a2"+
    "\0\u44e8\0\u452e\0\u4574\0\u45ba\0\u4600\0\u4646\0\u468c\0\u46d2"+
    "\0\u4718\0\u320a\0\u475e\0\u47a4\0\u47ea\0\u4830\0\u4876\0\u48bc"+
    "\0\u4902\0\u4948\0\u498e\0\u49d4\0\u4a1a\0\u4a60\0\u4aa6\0\u4aec"+
    "\0\u4b32\0\u4b78\0\u4bbe\0\u4c04\0\u4c4a\0\u4c90\0\u4cd6\0\u4d1c"+
    "\0\u4d62\0\u4da8\0\u4dee\0\u4e34\0\u4e7a\0\u4ec0\0\u4f06\0\u4f4c"+
    "\0\u4f92\0\u4fd8\0\u501e\0\u5064\0\u50aa\0\u50f0\0\u5136\0\u517c"+
    "\0\u51c2\0\u5208\0\u524e\0\u5294\0\u52da\0\u5320\0\u5366\0\u26d4"+
    "\0\u53ac\0\u53f2\0\u5438\0\u547e\0\u54c4\0\u550a\0\u5550\0\u5596"+
    "\0\u55dc\0\u5622\0\u5668\0\u56ae\0\u56f4\0\u573a\0\u5780\0\u57c6"+
    "\0\u580c\0\u5852\0\u5898\0\u58de\0\u5924\0\u596a\0\u59b0\0\u59f6"+
    "\0\u5a3c\0\u5a82\0\u5ac8\0\u5b0e\0\u5b54\0\u5b9a\0\u5be0\0\u5c26"+
    "\0\u5c6c\0\u5cb2\0\u5cf8\0\u5d3e\0\u1252\0\u5d84\0\u13b0\0\u5dca"+
    "\0\u5e10\0\u5e56\0\u5e9c\0\u5ee2\0\u5f28\0\u5f6e\0\u5fb4\0\u5ffa"+
    "\0\u6040\0\u6086\0\u60cc\0\u6112\0\u6158\0\u619e\0\u61e4\0\u622a"+
    "\0\u6270\0\u2c4c\0\u62b6\0\u62fc\0\u6342\0\u6388\0\u63ce\0\u6414"+
    "\0\u645a\0\u64a0\0\u64e6\0\u652c\0\u6572\0\u65b8\0\u65fe\0\u6644"+
    "\0\u668a\0\u66d0\0\u6716\0\u675c\0\u67a2\0\u67e8\0\u682e\0\u6874"+
    "\0\u68ba\0\u6900\0\u6946\0\u698c\0\u038e\0\u69d2\0\u6a18\0\u6a5e"+
    "\0\u6aa4\0\u6aea\0\u6b30\0\u6b76\0\u6bbc\0\u6c02\0\u6c48\0\u6c8e"+
    "\0\u6cd4\0\u6d1a\0\u6d60\0\u6da6\0\u6dec\0\u6e32\0\u6e78\0\u6ebe"+
    "\0\u6f04\0\u6f4a\0\u2a62\0\u6f90\0\u6fd6\0\u701c\0\u7062\0\u70a8"+
    "\0\u70ee\0\u7134\0\u717a\0\u71c0\0\u7206\0\u724c\0\u7292\0\u72d8"+
    "\0\u731e\0\u7364\0\u73aa\0\u73f0\0\u7436\0\u747c\0\u74c2\0\u7508"+
    "\0\u754e\0\u7594\0\u75da\0\u7620\0\u7666\0\u76ac\0\u038e\0\u038e"+
    "\0\u76f2\0\u7738\0\u777e\0\u77c4\0\u780a\0\u7850\0\u7896\0\u78dc"+
    "\0\u7922\0\u7968\0\u79ae\0\u79f4\0\u7a3a\0\u7a80\0\u7ac6\0\u7b0c"+
    "\0\u7b52\0\u7b98\0\u7bde\0\u31c4\0\u7c24\0\u7c6a\0\u038e\0\u038e"+
    "\0\u7cb0\0\u7cf6\0\u7d3c\0\u7d82\0\u7dc8\0\u7e0e\0\u7e54\0\u7e9a"+
    "\0\u2878\0\u7ee0\0\u7f26\0\u7f6c\0\u7fb2\0\u7ff8\0\u803e\0\u8084"+
    "\0\u80ca\0\u8110\0\u8156\0\u819c\0\u81e2\0\u8228\0\u826e\0\u82b4"+
    "\0\u82fa\0\u8340\0\u8386\0\u83cc\0\u8412\0\u8458\0\u849e\0\u84e4"+
    "\0\u852a\0\u8570\0\u85b6\0\u85fc\0\u8642\0\u8688\0\u86ce\0\u8714"+
    "\0\u875a\0\u87a0\0\u87e6\0\u882c\0\u8872\0\u88b8\0\u88fe\0\u8944"+
    "\0\u898a\0\u89d0\0\u8a16\0\u8a5c\0\u8aa2\0\u8ae8\0\u8b2e\0\u8b74"+
    "\0\u8bba\0\u8c00\0\u8c46\0\u8c8c\0\u8cd2\0\u8d18\0\u8d5e\0\u8da4"+
    "\0\u8dea\0\u8e30\0\u8e76\0\u8ebc\0\u038e\0\u038e\0\u8f02\0\u8f48"+
    "\0\u8f8e\0\u8fd4\0\u901a\0\u9060\0\u90a6\0\u90ec\0\u9132\0\u9178"+
    "\0\u91be\0\u9204\0\u924a\0\u9290\0\u92d6\0\u931c\0\u9362\0\u93a8"+
    "\0\u93ee\0\u9434\0\u947a\0\u94c0\0\u9506\0\u954c\0\u9592\0\u95d8"+
    "\0\u961e";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[601];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\12\1\13\1\14\1\15\1\13\1\14\1\16\1\17"+
    "\1\12\1\20\1\21\4\13\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\2\24\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\50\1\45\1\52"+
    "\1\53\1\54\1\55\1\56\1\57\2\14\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\1\70\1\71"+
    "\1\72\1\73\1\74\1\75\1\76\1\77\3\13\10\100"+
    "\1\101\1\102\11\100\2\103\1\104\1\105\53\100\1\106"+
    "\3\100\10\107\1\110\1\111\41\107\1\112\32\107\10\113"+
    "\1\101\1\114\11\113\2\115\1\116\1\117\2\113\1\120"+
    "\54\113\10\121\1\101\1\122\4\121\1\123\4\121\2\124"+
    "\1\125\1\126\57\121\10\127\1\101\1\130\4\127\1\131"+
    "\67\127\10\121\1\101\1\132\4\121\1\133\4\121\2\124"+
    "\1\125\1\126\57\121\10\127\1\101\1\134\4\127\1\135"+
    "\67\127\11\136\1\137\31\136\1\140\42\136\6\12\1\0"+
    "\2\12\2\0\4\12\4\0\1\12\2\0\1\12\5\0"+
    "\5\12\13\0\26\12\1\0\4\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\26\13\1\0\3\13\2\141\2\14\1\141\1\14"+
    "\1\0\2\141\2\0\1\141\1\142\1\143\1\144\1\0"+
    "\1\145\2\0\1\141\2\0\1\141\5\0\3\141\1\142"+
    "\1\143\13\0\3\141\1\144\1\141\2\14\11\141\1\143"+
    "\5\141\1\0\1\141\1\143\3\141\1\146\1\147\1\141"+
    "\1\147\1\0\2\141\2\0\1\150\1\142\1\143\1\144"+
    "\1\0\1\145\2\0\1\141\2\0\1\141\5\0\2\141"+
    "\1\150\1\142\1\143\13\0\3\141\1\144\1\141\2\147"+
    "\11\141\1\143\5\141\1\0\1\141\1\143\1\141\106\0"+
    "\11\151\1\0\34\151\1\152\37\151\12\0\1\21\112\0"+
    "\1\50\23\0\1\50\1\0\1\50\42\0\2\145\1\0"+
    "\1\145\53\0\2\145\23\0\1\12\1\153\2\12\1\153"+
    "\1\12\1\0\2\12\2\0\4\153\4\0\1\12\2\0"+
    "\1\154\1\155\4\0\5\153\13\0\5\153\2\12\17\153"+
    "\1\0\3\153\1\0\1\156\2\0\1\156\6\0\4\156"+
    "\7\0\1\157\1\155\4\0\5\156\2\0\1\50\10\0"+
    "\5\156\2\0\17\156\1\0\3\156\1\0\1\156\2\0"+
    "\1\156\6\0\4\156\7\0\1\157\1\155\4\0\5\156"+
    "\13\0\5\156\2\0\17\156\1\0\3\156\1\12\1\153"+
    "\2\160\1\153\1\160\1\0\2\160\2\0\4\153\4\161"+
    "\1\160\2\161\1\162\1\163\1\0\3\161\5\153\13\161"+
    "\5\153\2\160\17\153\1\161\3\153\10\164\1\165\21\164"+
    "\2\0\7\164\1\166\42\164\43\0\1\50\7\0\1\50"+
    "\26\0\1\50\3\0\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\3\0\1\167\1\0"+
    "\1\13\1\170\1\13\1\171\1\13\5\0\1\172\3\0"+
    "\1\173\1\0\1\174\1\175\1\176\1\177\4\13\1\200"+
    "\1\201\1\202\6\13\1\203\1\204\1\13\1\205\1\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\3\13\1\206\1\13"+
    "\13\0\1\13\1\207\1\210\1\13\1\211\3\13\1\212"+
    "\2\13\1\213\12\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\13\1\214\24\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\215\1\216\3\13\13\0\1\13\1\217"+
    "\1\13\1\220\1\221\4\13\1\222\14\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\1\13\1\223\1\13"+
    "\1\224\5\13\1\225\2\13\1\226\4\13\1\227\4\13"+
    "\1\0\3\13\41\0\1\50\1\0\1\50\104\0\1\230"+
    "\1\50\105\0\1\50\5\0\1\50\2\0\1\231\1\232"+
    "\1\233\1\234\5\0\1\235\2\0\1\236\3\0\1\237"+
    "\54\0\1\50\105\0\1\50\1\0\1\240\103\0\1\50"+
    "\5\0\1\50\77\0\1\50\4\0\1\50\2\0\1\50"+
    "\26\0\1\50\3\0\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\1\13\1\241\2\13\1\242\3\13\1\243\1\244\7\13"+
    "\1\245\4\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\1\13"+
    "\1\246\3\13\13\0\1\247\7\13\1\250\10\13\1\251"+
    "\4\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\3\13\1\252\22\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\253\1\13\1\254\1\255\1\13\13\0\1\13\1\256"+
    "\2\13\1\257\2\13\1\260\7\13\1\261\2\13\1\223"+
    "\3\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\1\13\1\262"+
    "\1\13\1\263\1\13\13\0\12\13\1\264\1\13\1\265"+
    "\2\13\1\266\6\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\3\13\1\267\1\270\21\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\3\13\1\271\1\272"+
    "\4\13\1\273\1\13\1\274\12\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\1\13\1\275\15\13\1\276"+
    "\1\223\5\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\3\13\1\277\4\13\1\300\1\301\14\13\1\0"+
    "\3\13\1\12\5\13\1\0\1\12\1\302\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\3\0\1\303\1\0\1\304"+
    "\4\13\5\0\1\305\3\0\1\306\1\0\4\13\1\307"+
    "\10\13\1\274\6\13\1\310\1\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\3\13\1\311\1\13\13\0\11\13\1\312"+
    "\14\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\3\13\1\313\5\13\1\314\14\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\3\13\1\315\1\13\13\0\1\13\1\316"+
    "\1\13\1\317\4\13\1\320\2\13\1\321\12\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\1\13\1\322"+
    "\1\13\1\323\22\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\13\1\324\1\13\1\325\1\13\13\0\1\13\1\326"+
    "\7\13\1\327\14\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\225\1\216\3\13\13\0\12\13\1\330\1\331\3\13"+
    "\1\332\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\10\13\1\333\10\13\1\334\4\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\2\13\1\335\1\13"+
    "\1\336\3\13\1\337\15\13\1\0\3\13\1\12\5\13"+
    "\1\0\1\12\1\340\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\3\0\1\341\1\0\5\13\5\0\1\342\3\0"+
    "\1\343\1\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\13\1\344\24\13\1\0\3\13\10\100"+
    "\2\0\11\100\2\0\1\100\1\0\53\100\1\0\3\100"+
    "\11\345\1\0\74\345\1\0\1\346\2\0\1\346\6\0"+
    "\4\346\7\0\1\347\1\350\4\0\5\346\13\0\5\346"+
    "\2\0\17\346\1\0\3\346\10\100\2\0\11\100\2\0"+
    "\1\100\1\347\53\100\1\0\3\100\1\0\1\346\2\351"+
    "\1\346\1\351\1\0\2\351\2\0\4\346\7\351\1\352"+
    "\1\353\1\0\3\351\5\346\13\351\5\346\2\351\17\346"+
    "\1\351\3\346\10\107\2\0\41\107\1\0\32\107\11\354"+
    "\1\0\74\354\10\113\2\0\11\113\2\0\1\113\1\0"+
    "\2\113\1\0\54\113\1\0\1\355\2\0\1\355\6\0"+
    "\4\355\7\0\1\356\1\357\4\0\5\355\13\0\5\355"+
    "\2\0\17\355\1\0\3\355\10\113\2\0\11\113\2\0"+
    "\1\113\1\356\2\113\1\0\54\113\1\0\1\355\2\360"+
    "\1\355\1\360\1\0\2\360\2\0\4\355\7\360\1\361"+
    "\1\362\1\0\3\360\5\355\13\360\5\355\2\360\17\355"+
    "\1\360\3\355\10\121\2\0\11\121\2\0\1\121\1\0"+
    "\67\121\2\0\11\121\2\0\1\121\1\0\54\121\1\363"+
    "\2\121\1\0\1\364\2\0\1\364\6\0\4\364\7\0"+
    "\1\365\1\366\4\0\5\364\13\0\5\364\2\0\17\364"+
    "\1\0\3\364\10\121\2\0\11\121\2\0\1\121\1\365"+
    "\57\121\1\0\1\364\2\367\1\364\1\367\1\0\2\367"+
    "\2\0\4\364\7\367\1\370\1\371\1\0\3\367\5\364"+
    "\13\367\5\364\2\367\17\364\1\367\3\364\10\127\2\0"+
    "\104\127\2\0\71\127\1\372\2\127\10\121\2\0\11\121"+
    "\2\0\1\121\1\0\54\121\1\373\2\121\10\127\2\0"+
    "\71\127\1\374\2\127\11\136\1\0\31\136\1\0\42\136"+
    "\35\0\1\375\16\0\1\376\1\377\1\u0100\1\u0101\5\0"+
    "\1\u0102\2\0\1\u0103\3\0\1\u0104\11\0\6\141\1\0"+
    "\2\141\2\0\4\141\4\0\1\141\2\0\1\141\5\0"+
    "\5\141\13\0\26\141\1\0\5\141\2\u0105\1\141\1\u0105"+
    "\1\0\2\141\2\0\4\141\1\u0106\3\0\1\141\2\0"+
    "\1\141\5\0\5\141\1\u0106\12\0\5\141\2\u0105\17\141"+
    "\1\0\5\141\2\145\1\141\1\145\1\0\2\141\2\0"+
    "\2\141\1\143\1\144\4\0\1\141\2\0\1\141\5\0"+
    "\4\141\1\143\13\0\3\141\1\144\1\141\2\145\11\141"+
    "\1\143\5\141\1\0\1\141\1\143\3\141\2\146\1\141"+
    "\1\146\1\0\2\141\2\0\2\141\1\143\1\144\1\0"+
    "\1\145\2\0\1\141\2\0\1\141\5\0\4\141\1\143"+
    "\13\0\3\141\1\144\1\141\2\146\11\141\1\143\5\141"+
    "\1\0\1\141\1\143\3\141\1\146\1\147\1\141\1\147"+
    "\1\0\2\141\2\0\1\141\1\u0107\1\143\1\144\1\0"+
    "\1\145\2\0\1\141\2\0\1\141\5\0\3\141\1\u0107"+
    "\1\143\13\0\3\141\1\144\1\141\2\147\11\141\1\143"+
    "\5\141\1\0\1\141\1\143\3\141\4\u0108\1\0\2\141"+
    "\2\0\2\141\2\u0108\4\0\1\141\2\0\1\141\5\0"+
    "\1\141\1\u0108\2\141\1\u0108\13\0\3\141\4\u0108\5\141"+
    "\1\u0108\3\141\1\u0108\5\141\1\0\1\141\1\u0108\1\141"+
    "\11\151\1\0\74\151\11\152\1\0\74\152\1\12\5\153"+
    "\1\0\2\12\2\0\4\153\4\0\1\12\2\0\1\12"+
    "\5\0\5\153\13\0\26\153\1\0\3\153\1\12\1\153"+
    "\2\12\1\153\1\12\1\0\2\12\2\0\4\153\4\0"+
    "\1\12\2\0\1\12\1\155\4\0\5\153\13\0\5\153"+
    "\2\12\17\153\1\0\3\153\1\0\1\u0109\2\0\1\u0109"+
    "\6\0\4\u0109\15\0\5\u0109\13\0\5\u0109\2\0\17\u0109"+
    "\1\0\3\u0109\1\0\5\156\5\0\4\156\15\0\5\156"+
    "\13\0\26\156\1\0\3\156\1\0\1\156\2\0\1\156"+
    "\6\0\4\156\10\0\1\155\4\0\5\156\13\0\5\156"+
    "\2\0\17\156\1\0\3\156\1\0\1\u0109\2\0\1\u0109"+
    "\2\0\2\161\2\0\4\u0109\10\161\1\0\4\161\5\u0109"+
    "\13\161\5\u0109\2\0\17\u0109\1\161\3\u0109\10\164\1\165"+
    "\21\164\1\u010a\64\164\1\0\74\164\32\167\1\u010b\53\167"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\4\13\1\u010c\21\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\3\13"+
    "\1\320\22\13\1\0\3\13\46\172\1\u010d\37\172\52\173"+
    "\1\u010e\33\173\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\3\13\1\u010f\1\13"+
    "\13\0\10\13\1\u0110\15\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\1\13\1\u0111\3\13\13\0\10\13\1\246\15\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\11\13"+
    "\1\u0112\1\13\1\u0113\5\13\1\u0114\4\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\3\13\1\u0115\1\13\13\0\3\13"+
    "\1\u0116\6\13\1\u0117\1\u0118\3\13\1\u0119\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\4\13\1\272"+
    "\21\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\17\13\1\310\6\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\4\13\1\246\14\13\1\u011a\4\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\14\13\1\u011b"+
    "\11\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\10\13\1\246\15\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\u011c\4\13\13\0\13\13\1\u011d\12\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\1\13\1\u011e\24\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\1\310\4\13\13\0"+
    "\17\13\1\u011f\6\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\4\13\1\u0120\13\0\1\13\1\u0121\6\13\1\u0122\2\13"+
    "\1\u0123\12\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\3\13"+
    "\1\u0124\1\13\13\0\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\24\13\1\u0125\1\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\1\223\25\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\10\13\1\223"+
    "\15\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\12\13\1\u0126\13\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\20\13\1\u0127\5\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\13\1\u0128\3\13\13\0\16\13\1\310"+
    "\7\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\17\13\1\u0129\6\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\u012a\4\13\13\0\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\1\u012b\4\13\13\0\17\13\1\u012c\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\3\13\1\u012d\1\13\13\0"+
    "\20\13\1\u012e\5\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\3\13\1\310\22\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\13\13\1\u012f\12\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\13\13\1\307"+
    "\12\13\1\0\3\13\12\0\1\u0130\3\0\1\u0131\12\0"+
    "\1\u0132\11\0\1\50\7\0\1\u0133\26\0\1\u0134\60\0"+
    "\1\u0135\113\0\1\u0136\101\0\1\u0137\121\0\1\u0138\100\0"+
    "\1\u0139\76\0\1\u013a\1\u013b\102\0\1\u013c\73\0\1\50"+
    "\1\0\1\45\40\0\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\1\310\4\13"+
    "\13\0\1\310\25\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\13\1\u013d\3\13\13\0\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\1\13\1\u013e\7\13\1\u013f"+
    "\14\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\1\225\25\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\1\u0140"+
    "\4\13\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\12\13\1\310\13\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\3\13\1\u0141\22\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\4\13\1\310\13\0\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\10\13"+
    "\1\310\15\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\2\13"+
    "\1\310\2\13\13\0\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\4\13\1\u0142\21\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\1\310\2\13\1\267"+
    "\5\13\1\u0143\14\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\u0144\4\13\13\0\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\20\13\1\310\5\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\1\13\1\u0140\3\13\13\0\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\4\13"+
    "\1\u0145\21\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\4\13"+
    "\1\u0146\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\13\1\u0147\3\13\13\0\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\4\13\1\u0148\21\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\4\13\1\u0149"+
    "\21\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\1\310\4\13"+
    "\13\0\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\4\13"+
    "\1\223\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\13\1\310\3\13\13\0\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\3\13\1\u014a\1\13\13\0\26\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\1\u014b\1\u014c\2\13\1\u014d"+
    "\13\0\4\13\1\u014e\2\13\1\u014f\2\13\1\u0150\4\13"+
    "\1\u0151\1\310\1\13\1\u0152\1\u0153\2\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\17\13\1\u0119\6\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\17\13"+
    "\1\u0154\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\4\13"+
    "\1\u0120\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\13\1\u0155\3\13\13\0\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\4\13\1\55\13\0\12\13\1\310\13\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\3\13\1\u0156\1\13"+
    "\13\0\26\13\1\0\3\13\1\12\5\13\1\0\1\12"+
    "\1\340\2\0\4\13\4\0\1\12\2\0\1\12\3\0"+
    "\1\341\1\0\5\13\5\0\1\342\3\0\1\343\1\0"+
    "\21\13\1\u0157\4\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\3\13\1\u0158\7\13\1\u0159\12\13\1\0"+
    "\3\13\6\302\1\u015a\1\302\1\u015b\2\u015a\4\302\4\u015a"+
    "\1\302\2\u015a\1\302\5\u015a\5\302\13\u015a\26\302\1\u015a"+
    "\3\302\32\303\1\u015c\53\303\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\16\13\1\u015d\7\13\1\0\3\13\46\305\1\u015c"+
    "\37\305\52\306\1\u015c\33\306\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\1\310\25\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\3\13\1\u015e\22\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\17\13\1\u015f\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\24\13\1\265"+
    "\1\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\3\13\1\u0145"+
    "\1\13\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\13\1\u0160\24\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\12\13\1\u0161\13\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\12\13\1\u0162"+
    "\13\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\3\13\1\307\22\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\12\13\1\330\13\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\12\13\1\223\13\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\2\13\1\u012a\2\13\13\0"+
    "\26\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\17\13\1\u0155\6\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\13\1\u0163\24\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\10\13\1\u0164\15\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\3\13\1\u0165\1\13\13\0"+
    "\26\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\11\13\1\u0166\14\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\4\13\1\u0167\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\u0168\2\13\1\u0169\1\u016a\13\0\1\u016b"+
    "\11\13\1\u016c\13\13\1\0\3\13\1\12\5\13\1\0"+
    "\1\12\1\u016d\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\3\0\1\u016e\1\0\5\13\5\0\1\u016f\3\0\1\u0170"+
    "\1\0\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\1\13\1\u0171\24\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\11\13\1\u0172\14\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\10\13\1\201\1\u0173"+
    "\5\13\1\u0174\6\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\11\13\1\u0175\14\13\1\0\3\13\6\340"+
    "\1\u0176\1\340\1\u0177\2\u0176\4\340\4\u0176\1\340\2\u0176"+
    "\1\340\5\u0176\5\340\13\u0176\26\340\1\u0176\3\340\32\341"+
    "\1\u0178\53\341\46\342\1\u0179\37\342\52\343\1\u017a\33\343"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\11\13\1\201\14\13"+
    "\1\0\3\13\1\0\5\346\5\0\4\346\15\0\5\346"+
    "\13\0\26\346\1\0\3\346\1\0\1\346\2\0\1\346"+
    "\6\0\4\346\10\0\1\350\4\0\5\346\13\0\5\346"+
    "\2\0\17\346\1\0\3\346\1\0\1\u017b\2\0\1\u017b"+
    "\6\0\4\u017b\15\0\5\u017b\13\0\5\u017b\2\0\17\u017b"+
    "\1\0\3\u017b\1\0\1\u017b\2\0\1\u017b\2\0\2\351"+
    "\2\0\4\u017b\10\351\1\0\4\351\5\u017b\13\351\5\u017b"+
    "\2\0\17\u017b\1\351\3\u017b\1\0\5\355\5\0\4\355"+
    "\15\0\5\355\13\0\26\355\1\0\3\355\1\0\1\355"+
    "\2\0\1\355\6\0\4\355\10\0\1\357\4\0\5\355"+
    "\13\0\5\355\2\0\17\355\1\0\3\355\1\0\1\u017c"+
    "\2\0\1\u017c\6\0\4\u017c\15\0\5\u017c\13\0\5\u017c"+
    "\2\0\17\u017c\1\0\3\u017c\1\0\1\u017c\2\0\1\u017c"+
    "\2\0\2\360\2\0\4\u017c\10\360\1\0\4\360\5\u017c"+
    "\13\360\5\u017c\2\0\17\u017c\1\360\3\u017c\10\121\2\0"+
    "\11\121\2\0\1\121\1\0\55\121\1\u017d\1\121\1\0"+
    "\5\364\5\0\4\364\15\0\5\364\13\0\26\364\1\0"+
    "\3\364\1\0\1\364\2\0\1\364\6\0\4\364\10\0"+
    "\1\366\4\0\5\364\13\0\5\364\2\0\17\364\1\0"+
    "\3\364\1\0\1\u017e\2\0\1\u017e\6\0\4\u017e\15\0"+
    "\5\u017e\13\0\5\u017e\2\0\17\u017e\1\0\3\u017e\1\0"+
    "\1\u017e\2\0\1\u017e\2\0\2\367\2\0\4\u017e\10\367"+
    "\1\0\4\367\5\u017e\13\367\5\u017e\2\0\17\u017e\1\367"+
    "\3\u017e\10\127\2\0\72\127\1\u017f\1\127\10\121\2\0"+
    "\11\121\2\0\1\121\1\0\56\121\1\u017d\10\127\2\0"+
    "\73\127\1\u017f\75\0\1\u0180\65\0\1\u0181\113\0\1\u0182"+
    "\101\0\1\u0183\121\0\1\u0184\100\0\1\u0185\76\0\1\u0186"+
    "\1\u0187\102\0\1\u0188\30\0\2\141\2\u0105\1\141\1\u0105"+
    "\1\0\2\141\2\0\2\141\1\143\1\141\4\0\1\141"+
    "\2\0\1\141\5\0\4\141\1\143\13\0\5\141\2\u0105"+
    "\11\141\1\143\5\141\1\0\1\141\1\143\1\141\2\0"+
    "\2\u0105\1\0\1\u0105\53\0\2\u0105\23\0\2\141\4\u0108"+
    "\1\0\2\141\2\0\1\141\1\u0107\2\u0108\4\0\1\141"+
    "\2\0\1\141\5\0\1\141\1\u0108\1\141\1\u0107\1\u0108"+
    "\13\0\3\141\4\u0108\5\141\1\u0108\3\141\1\u0108\5\141"+
    "\1\0\1\141\1\u0108\1\141\1\0\5\u0109\5\0\4\u0109"+
    "\11\0\1\161\3\0\5\u0109\13\0\26\u0109\1\0\3\u0109"+
    "\34\0\5\u010a\13\0\2\u010a\2\0\1\u010a\4\0\1\u010a"+
    "\1\0\1\u010a\2\0\1\u010a\2\0\1\u010a\10\0\32\u010b"+
    "\1\u0189\53\u010b\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\3\13\1\u018a\1\13"+
    "\13\0\26\13\1\0\3\13\46\u010d\1\u0189\37\u010d\52\u010e"+
    "\1\u0189\33\u010e\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\11\13"+
    "\1\u018b\14\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\11\13\1\u018c\14\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\15\13\1\u018d\10\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\20\13\1\246\5\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\1\13\1\u0155\3\13"+
    "\13\0\10\13\1\u018e\5\13\1\u014b\4\13\1\u018f\2\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\12\13"+
    "\1\u0190\13\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\3\13\1\u0191\22\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\15\13\1\u0192\10\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\1\u0193\4\13\13\0\1\u0194\1\13"+
    "\1\u0195\13\13\1\u0196\1\u0197\6\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\13\1\u0155\3\13\13\0\1\13\1\307"+
    "\14\13\1\u014b\7\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\4\13\1\u0198\13\0\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\1\u0199\4\13\13\0\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\u019a\1\u019b\3\13\13\0\1\13\1\u019c"+
    "\6\13\1\u018e\1\13\1\u019d\10\13\1\u018f\2\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\3\13\1\u019e\1\13\13\0"+
    "\26\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\1\u019f\4\13"+
    "\13\0\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\12\13\1\u01a0\4\13\1\u0115\6\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\11\13\1\251\14\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\1\310"+
    "\12\13\1\307\7\13\1\201\2\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\1\13\1\u01a1\24\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\1\13\1\u0119"+
    "\24\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\3\13\1\u01a2"+
    "\1\13\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\246\25\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\4\13\1\246\21\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\11\13\1\u01a3\14\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\4\13"+
    "\1\u01a4\21\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\16\13\1\u01a5\7\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\12\13\1\u01a6\13\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\15\13\1\310\10\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\3\13"+
    "\1\u0175\22\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\11\13\1\u01a7\14\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\1\13\1\u01a8\3\13\13\0\1\13\1\u019c\24\13"+
    "\1\0\3\13\12\0\1\u0130\16\0\1\u0132\21\0\1\u0133"+
    "\26\0\1\u0134\106\0\1\u01a9\20\0\1\u01aa\105\0\1\u01ab"+
    "\105\0\1\u01ac\127\0\1\u01ad\124\0\1\u013c\106\0\1\u01ae"+
    "\62\0\1\u01af\2\0\1\u01ad\124\0\1\u01b0\120\0\1\u01b1"+
    "\50\0\1\u01b2\134\0\1\u01ad\21\0\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\15\13\1\u01b3\10\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\12\13\1\u01b4\13\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\17\13\1\u01b5"+
    "\6\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\2\13\1\310\23\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\17\13\1\u0192\6\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\13\1\223\3\13\13\0\26\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\1\u01b6\4\13\13\0\12\13"+
    "\1\310\13\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\3\13\1\223\5\13\1\u01b7\14\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\3\13\1\310\1\13\13\0\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\1\u01b8\4\13\13\0"+
    "\1\u01b9\1\13\1\u0195\13\13\1\u0196\1\u0197\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\3\13\1\u0125"+
    "\22\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\10\13\1\u01ba\15\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\17\13\1\u01bb\6\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\21\13\1\u01bc\4\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\3\13\1\246"+
    "\22\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\7\13\1\310\16\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\13\1\223\24\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\4\13\1\u01bd\13\0\26\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\3\13\1\u01be\22\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\21\13"+
    "\1\u01bf\4\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\4\13\1\u0166\21\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\21\13\1\u01c0\4\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\11\13\1\u01c1\14\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\4\13\1\55\13\0"+
    "\26\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\12\13\1\u0145\13\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\3\13\1\u0192\1\13\13\0\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\17\13\1\u01c2\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\3\13\1\u01c3"+
    "\22\13\1\0\3\13\10\u015a\1\u015c\75\u015a\6\12\1\0"+
    "\2\12\2\0\4\12\4\0\1\12\2\0\1\12\5\0"+
    "\5\u015b\13\0\2\u015b\2\12\1\u015b\4\12\1\u015b\1\12"+
    "\1\u015b\2\12\1\u015b\2\12\1\u015b\4\12\1\0\3\12"+
    "\34\0\5\u015c\13\0\2\u015c\2\0\1\u015c\4\0\1\u015c"+
    "\1\0\1\u015c\2\0\1\u015c\2\0\1\u015c\10\0\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\272\1\u0155\3\13\13\0\10\13\1\u01c4"+
    "\5\13\1\u014b\7\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\265\4\13\13\0\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\4\13\1\310\13\0\13\13\1\u01c5\12\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\14\13\1\310"+
    "\11\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\1\13\1\310\24\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\u01c6\1\310\1\13\1\u01c7\1\13\13\0\1\u01c8\1\13"+
    "\1\u01c9\13\13\1\u01ca\1\u01cb\6\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\13\1\u012c\3\13\13\0\26\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\3\13\1\u01cc"+
    "\7\13\1\u01cd\1\13\1\310\10\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\3\13\1\u01ce\22\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\13\13\1\225"+
    "\12\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\1\u012c\4\13"+
    "\13\0\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\2\13\1\u01cf\23\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\3\13\1\u01d0\5\13\1\u01d1\14\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\3\13"+
    "\1\256\22\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\4\13\1\u0163\21\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\11\13\1\u01d2\14\13\1\0\3\13"+
    "\6\u016d\1\u01d3\1\u016d\1\u01d4\2\u01d3\4\u016d\4\u01d3\1\u016d"+
    "\2\u01d3\1\u016d\3\u01d3\1\0\1\u01d3\5\u016d\13\u01d3\26\u016d"+
    "\1\u01d3\3\u016d\32\u016e\1\u01d5\53\u016e\32\u016f\1\0\13\u016f"+
    "\1\u01d6\37\u016f\32\u0170\1\0\17\u0170\1\u01d7\33\u0170\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\12\13\1\u01d8\13\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\3\13\1\u01d9\1\13\13\0"+
    "\26\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\12\13\1\u01da\13\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\12\13\1\u01db\13\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\12\13\1\225\13\13\1\0"+
    "\3\13\10\u0176\1\u01dc\75\u0176\6\u0177\1\u01dc\1\u0177\1\u01dd"+
    "\2\u01dc\4\u0177\4\u01dc\1\u0177\2\u01dc\1\u0177\5\u01dc\5\u0177"+
    "\13\u01dc\26\u0177\1\u01dc\3\u0177\32\u0178\1\u01de\53\u0178\46\u0179"+
    "\1\u01de\37\u0179\52\u017a\1\u01de\33\u017a\1\0\5\u017b\5\0"+
    "\4\u017b\11\0\1\351\3\0\5\u017b\13\0\26\u017b\1\0"+
    "\3\u017b\1\0\5\u017c\5\0\4\u017c\11\0\1\360\3\0"+
    "\5\u017c\13\0\26\u017c\1\0\3\u017c\1\0\5\u017e\5\0"+
    "\4\u017e\11\0\1\367\3\0\5\u017e\13\0\26\u017e\1\0"+
    "\3\u017e\66\0\1\u01df\57\0\1\u01e0\124\0\1\u0188\106\0"+
    "\1\u01e1\62\0\1\u01e2\2\0\1\u01e0\124\0\1\u01e3\120\0"+
    "\1\u01e4\50\0\1\u01e5\134\0\1\u01e0\55\0\5\u0189\13\0"+
    "\2\u0189\1\0\2\u0189\3\0\2\u0189\1\0\1\u0189\2\0"+
    "\1\u0189\2\0\1\u0189\10\0\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\4\13\1\251\21\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\1\13\1\225\3\13\13\0\12\13\1\310\13\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\17\13"+
    "\1\u01e6\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\3\13\1\u01e7\22\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\3\13\1\u01e8\22\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\10\13\1\337\15\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\4\13\1\u01e9\13\0"+
    "\26\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\1\13\1\246"+
    "\3\13\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\13\1\u01ea\1\13\1\u01eb\22\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\10\13\1\u01ec"+
    "\5\13\1\u01ed\4\13\1\u01ee\2\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\1\13\1\u01ef\24\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\10\13\1\u01ee"+
    "\15\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\3\13\1\u01f0\22\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\24\13\1\310\1\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\12\13\1\251\13\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\3\13\1\u01f1"+
    "\22\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\4\13\1\314\21\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\u01a6\25\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\3\13\1\u01ba\22\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\11\13\1\u01d1\14\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\3\13"+
    "\1\u0192\22\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\11\13\1\u01f2\14\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\1\13\1\246\24\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\3\13\1\251\22\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\10\13"+
    "\1\u01f3\15\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\3\13"+
    "\1\u01f4\1\13\13\0\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\12\13\1\u0140\13\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\3\13\1\201\22\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\17\13"+
    "\1\u01f5\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\3\13"+
    "\1\u01f6\1\13\13\0\26\13\1\0\3\13\104\0\1\u01f7"+
    "\1\u01f8\103\0\1\u01f9\105\0\1\u01fa\105\0\1\u01fb\42\0"+
    "\1\u01fc\122\0\1\u01fd\117\0\1\u01ad\103\0\1\u01fe\111\0"+
    "\1\u01ad\14\0\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\4\13"+
    "\1\u01ff\21\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\1\13\1\u0200\24\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\12\13\1\u0201\13\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\12\13\1\265\13\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\20\13"+
    "\1\223\5\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\3\13\1\u01eb\22\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\10\13\1\u0202\12\13\1\u01ee\2\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\13\13"+
    "\1\310\12\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\6\13\1\310\17\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\3\13\1\265\22\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\3\13\1\u0203\1\u0120\13\0\1\u0204"+
    "\25\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\10\13\1\u0205\15\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\10\13\1\201\15\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\11\13\1\u0206\14\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\17\13\1\u0207"+
    "\6\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\1\13\1\u0208"+
    "\3\13\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\13\1\u014c\3\13\13\0\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\1\13\1\u0209\24\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\1\13\1\u020a"+
    "\1\13\1\u020b\22\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\13\1\u020c\24\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\1\u020d\2\13\1\u020e\4\13"+
    "\1\u020f\5\13\1\u01ed\4\13\1\u0210\2\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\1\13\1\u0211\24\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\10\13"+
    "\1\u0212\15\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\3\13\1\u0213\22\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\4\13\1\u0214\21\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\3\13\1\u0215\1\13\13\0\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\17\13"+
    "\1\u0161\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\11\13\1\u0112\14\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\1\u0216\4\13\13\0\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\17\13\1\u012c\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\3\13\1\223\1\13\13\0"+
    "\3\13\1\310\22\13\1\0\3\13\10\u01d3\1\u0217\21\u01d3"+
    "\1\0\53\u01d3\6\u016d\1\u01d3\1\u016d\1\u01d4\2\u01d3\4\u016d"+
    "\4\u01d3\1\u016d\2\u01d3\1\u016d\3\u01d3\1\0\1\u01d3\1\u01d4"+
    "\1\u016d\3\u01d4\13\u01d3\2\u01d4\2\u016d\1\u01d4\4\u016d\1\u01d4"+
    "\1\u016d\1\u01d4\5\u016d\1\u01d4\4\u016d\1\u01d3\3\u016d\34\0"+
    "\1\u01d5\1\0\3\u01d5\13\0\2\u01d5\2\0\1\u01d5\4\0"+
    "\1\u01d5\1\0\1\u01d5\5\0\1\u01d5\10\0\32\u016f\1\0"+
    "\1\u016f\1\u01d6\1\u016f\3\u01d6\5\u016f\1\u01d6\5\u016f\2\u01d6"+
    "\2\u016f\1\u01d6\4\u016f\1\u01d6\1\u016f\1\u01d6\5\u016f\1\u01d6"+
    "\10\u016f\32\u0170\1\0\1\u0170\1\u01d7\1\u0170\3\u01d7\11\u0170"+
    "\1\u01d7\1\u0170\2\u01d7\2\u0170\1\u01d7\4\u0170\1\u01d7\1\u0170"+
    "\1\u01d7\5\u0170\1\u01d7\10\u0170\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\3\13\1\u0218\22\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\3\13\1\223\22\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\1\u020d\25\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\4\13\1\u0219"+
    "\21\13\1\0\3\13\10\u01dc\1\u01de\75\u01dc\6\12\1\0"+
    "\2\12\2\0\4\12\4\0\1\12\2\0\1\12\5\0"+
    "\2\u01dd\2\12\1\u01dd\13\0\10\12\1\u01dd\15\12\1\0"+
    "\3\12\34\0\2\u01de\2\0\1\u01de\23\0\1\u01de\61\0"+
    "\1\u021a\122\0\1\u021b\117\0\1\u01e0\103\0\1\u021c\111\0"+
    "\1\u01e0\14\0\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\12\13"+
    "\1\256\13\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\12\13\1\u021d\13\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\4\13\1\u0119\21\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\1\13\1\u021e\24\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\1\13\1\u021f\3\13"+
    "\13\0\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\10\13\1\u0220\15\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\1\13\1\u0221\7\13\1\u0222\14\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\10\13"+
    "\1\307\15\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\3\13\1\u0223\22\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\1\u01f0\4\13\13\0\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\12\13\1\u01ee\13\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\3\13\1\u012c"+
    "\22\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\17\13\1\u0224\6\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\1\246\4\13\13\0\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\3\13\1\u0119\22\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\1\13\1\u0205\24\13"+
    "\1\0\3\13\104\0\1\u0225\1\u0226\104\0\1\u0227\1\u0228"+
    "\104\0\1\u0229\1\u022a\61\0\2\u01ad\63\0\1\u022b\140\0"+
    "\1\u01ad\12\0\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\16\13"+
    "\1\225\7\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\12\13\1\u022c\13\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\1\13\1\u0221\24\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\11\13\1\u022d\14\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\11\13"+
    "\1\244\14\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\1\225"+
    "\4\13\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\10\13\1\225\15\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\4\13\1\274\13\0\26\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\4\13\1\u0175\21\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\4\13\1\225\13\0"+
    "\26\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\1\13\1\u022e"+
    "\3\13\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\10\13\1\u022f\15\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\16\13\1\344\7\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\11\13\1\u0119"+
    "\14\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\3\13\1\u0230\22\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\13\1\u0231\7\13\1\u0222\14\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\3\13\1\u0223"+
    "\13\13\1\u0232\1\13\1\u020d\4\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\u0213\4\13\13\0\26\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\3\13\1\u0223\12\13"+
    "\1\u020d\1\u0232\6\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\12\13\1\u0233\13\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\1\13\1\u0234\3\13\13\0\26\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\11\13\1\u0235"+
    "\14\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\1\223\4\13"+
    "\13\0\26\13\1\0\3\13\10\u01d3\1\u0217\21\u01d3\1\0"+
    "\1\u01d3\1\u0217\1\u01d3\3\u0217\13\u01d3\2\u0217\2\u01d3\1\u0217"+
    "\4\u01d3\1\u0217\1\u01d3\1\u0217\5\u01d3\1\u0217\10\u01d3\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\13\13\1\u0236\12\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\10\13\1\u0237"+
    "\15\13\1\0\3\13\61\0\2\u01e0\63\0\1\u0238\140\0"+
    "\1\u01e0\12\0\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\1\u0239"+
    "\25\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\23\13\1\201\2\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\15\13\1\u023a\10\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\7\13\1\u01ee\16\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\12\13\1\u023b"+
    "\13\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\1\13\1\u023c\24\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\17\13\1\246\6\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\21\13\1\u01d9\4\13\1\0"+
    "\3\13\31\0\1\u01f7\105\0\1\u01f8\127\0\1\u023d\105\0"+
    "\1\u023e\134\0\1\u01f7\105\0\1\u01f8\70\0\1\u023f\20\0"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\24\13\1\244\1\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\17\13"+
    "\1\u0240\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\15\13\1\u0241\10\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\7\13\1\u0242\16\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\10\13\1\u0243\15\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\12\13"+
    "\1\u0244\13\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\4\13\1\u01ba\21\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\3\13\1\u0223\10\13\1\u0245\11\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\2\13"+
    "\1\223\23\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\17\13\1\225\6\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\3\13\1\u0246\22\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\10\13\1\u0247\15\13"+
    "\1\0\3\13\65\0\1\u0248\20\0\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\4\13\1\u0120\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\1\13\1\u0125\24\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\1\13\1\u01ee"+
    "\24\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\2\0\1\12\5\0\5\13\13\0"+
    "\10\13\1\u0249\15\13\1\0\3\13\73\0\1\u024a\12\0"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\3\13\1\310\11\13"+
    "\1\310\10\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\1\13\1\u0125\15\13\1\u0151\6\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\3\13\1\u0223\10\13"+
    "\1\u024b\11\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\17\13\1\u0151\6\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\1\13\1\u024c\24\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\24\13\1\u024d\1\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\12\13"+
    "\1\u024e\13\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\4\13\1\u0198\21\13\1\0\3\13\73\0\1\u024f"+
    "\12\0\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\5\13\13\0\11\13\1\u0250"+
    "\14\13\1\0\3\13\72\0\1\u01ad\13\0\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\24\13\1\u0251\1\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\3\13\1\u0223\10\13"+
    "\1\u0252\11\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\5\13"+
    "\13\0\4\13\1\u0253\12\13\1\u0151\6\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\4\13\1\310\21\13"+
    "\1\0\3\13\72\0\1\u01e0\13\0\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\12\13\1\u0198\13\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\1\u0254\16\13\1\u0151\6\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\24\13"+
    "\1\u0255\1\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\2\0\1\12\5\0\4\13"+
    "\1\u0256\13\0\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\2\0\1\12\5\0"+
    "\5\13\13\0\1\13\1\204\24\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\2\0"+
    "\1\12\5\0\5\13\13\0\17\13\1\u0257\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\2\0\1\12\5\0\4\13\1\251\13\0\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\2\0\1\12\5\0\5\13\13\0\4\13"+
    "\1\u0166\14\13\1\u0258\4\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\2\0\1\12"+
    "\5\0\5\13\13\0\13\13\1\u0259\12\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\2\0\1\12\5\0\5\13\13\0\14\13\1\u01a2\11\13"+
    "\1\0\3\13";

  private static int [] zzUnpackTrans() {
    int [] result = new int[38500];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\11\0\4\1\1\11\1\1\1\11\3\1\2\11\4\1"+
    "\1\11\15\1\1\11\1\1\1\11\24\1\1\11\2\1"+
    "\1\11\3\1\1\11\2\1\2\11\1\1\1\11\3\1"+
    "\1\11\1\1\1\11\5\1\1\11\1\1\1\11\1\1"+
    "\1\11\2\1\1\11\15\1\1\0\1\1\1\0\1\1"+
    "\1\11\1\1\3\0\1\1\1\0\2\1\2\0\34\1"+
    "\10\0\43\1\1\0\1\1\2\0\32\1\3\0\1\1"+
    "\1\11\2\1\1\0\1\11\1\1\1\0\1\11\2\1"+
    "\1\0\1\11\1\1\1\0\3\1\1\0\1\11\1\1"+
    "\1\0\3\1\10\0\1\1\1\0\2\1\1\0\1\1"+
    "\1\0\1\1\2\0\41\1\15\0\35\1\1\0\23\1"+
    "\3\0\5\1\1\0\1\1\5\0\1\1\1\0\1\1"+
    "\11\0\40\1\4\0\1\11\5\0\40\1\1\0\10\1"+
    "\1\0\2\1\2\11\5\0\21\1\2\11\6\0\33\1"+
    "\3\0\10\1\7\0\14\1\1\0\4\1\2\11\1\0"+
    "\10\1\1\0\1\1\1\0\4\1\1\0\12\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[601];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specific to PerlTokenMaker; this signals that we are inside
	 * an unquoted/double quoted/backtick EOF heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOF_UNQUOTED			= -1;

	/**
	 * Token type specific to PerlTokenMaker; this signals that we are inside
	 * an single quoted EOF heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOF_SINGLE_QUOTED		= -2;

	/**
	 * Token type specific to PerlTokenMaker; this signals that we are inside
	 * an unquoted/double quoted/backtick EOT heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOT_UNQUOTED			= -3;

	/**
	 * Token type specific to PerlTokenMaker; this signals that we are inside
	 * an single quoted EOT heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOT_SINGLE_QUOTED		= -4;

	/**
	 * Token type specific to PerlTokenMaker; this signals we are in a POD
	 * block.
	 */
	public static final int INTERNAL_POD						= -5;

	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public PerlTokenMaker() {
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "#", null };
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean getMarkOccurrencesOfTokenType(int type) {
		return super.getMarkOccurrencesOfTokenType(type) || type==Token.VARIABLE;
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	@Override
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = STRING;
				start = text.offset;
				break;
			case Token.LITERAL_CHAR:
				state = CHAR_LITERAL;
				start = text.offset;
				break;
			case Token.LITERAL_BACKQUOTE:
				state = BACKTICKS;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOF_UNQUOTED:
				state = HEREDOC_EOF_UNQUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOF_SINGLE_QUOTED:
				state = HEREDOC_EOF_SINGLE_QUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOT_UNQUOTED:
				state = HEREDOC_EOT_UNQUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOT_SINGLE_QUOTED:
				state = HEREDOC_EOT_SINGLE_QUOTED;
				start = text.offset;
				break;
			case INTERNAL_POD:
				state = POD;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Returns whether a regular expression token can follow the specified
	 * token.
	 *
	 * @param t The token to check, which may be <code>null</code>.
	 * @return Whether a regular expression token may follow this one.
	 */
	private static boolean regexCanFollow(Token t) {
		char ch;
		// We basically try to mimic Eclipse's JS editor's behavior here.
		return t==null ||
				//t.isOperator() ||
				(t.length()==1 && (
					(ch=t.charAt(0))=='=' ||
					ch=='(' ||
					ch==',' ||
					ch=='?' ||
					ch==':' ||
					ch=='[' ||
					ch=='!' ||
					ch=='&'
				)) ||
				/* Operators "==", "===", "!=", "!==", etc. */
				(t.getType()==Token.OPERATOR &&
					((ch=t.charAt(t.length()-1))=='=' || ch=='~'));
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PerlTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public PerlTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 174) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 2:
          { addToken(Token.IDENTIFIER);
          }
        case 46: break;
        case 34:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.LITERAL_BACKQUOTE); addToken(temp,zzMarkedPos-1, Token.VARIABLE); start = zzMarkedPos;
          }
        case 47: break;
        case 40:
          { if (start==zzStartRead) { addToken(Token.COMMENT_DOCUMENTATION); yybegin(YYINITIAL); }
          }
        case 48: break;
        case 26:
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 49: break;
        case 11:
          { start = zzMarkedPos-1; yybegin(STRING);
          }
        case 50: break;
        case 38:
          { if (start==zzStartRead) { addToken(Token.PREPROCESSOR); addNullToken(); return firstToken; }
          }
        case 51: break;
        case 31:
          { addToken(Token.FUNCTION);
          }
        case 52: break;
        case 36:
          { boolean highlightedAsRegex = false;
					if (firstToken==null) {
						addToken(Token.REGEX);
						highlightedAsRegex = true;
					}
					else {
						// If this is *likely* to be a regex, based on
						// the previous token, highlight it as such.
						Token t = firstToken.getLastNonCommentNonWhitespaceToken();
						if (regexCanFollow(t)) {
							addToken(Token.REGEX);
							highlightedAsRegex = true;
						}
					}
					// If it doesn't *appear* to be a regex, highlight it as
					// individual tokens.
					if (!highlightedAsRegex) {
						int temp = zzStartRead + 1;
						addToken(zzStartRead, zzStartRead, Token.OPERATOR);
						zzStartRead = zzCurrentPos = zzMarkedPos = temp;
					}
          }
        case 53: break;
        case 30:
          { addToken(Token.VARIABLE);
          }
        case 54: break;
        case 1:
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 55: break;
        case 24:
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_SINGLE_QUOTED); return firstToken;
          }
        case 56: break;
        case 4:
          { addToken(Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 57: break;
        case 29:
          { addToken(Token.PREPROCESSOR); addNullToken(); return firstToken;
          }
        case 58: break;
        case 41:
          { if (start==zzStartRead) { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos; }
          }
        case 59: break;
        case 44:
          { start = zzStartRead; yybegin(HEREDOC_EOF_SINGLE_QUOTED);
          }
        case 60: break;
        case 45:
          { start = zzStartRead; yybegin(HEREDOC_EOT_SINGLE_QUOTED);
          }
        case 61: break;
        case 42:
          { start = zzStartRead; yybegin(HEREDOC_EOF_UNQUOTED);
          }
        case 62: break;
        case 13:
          { /* Skip escaped chars. */
          }
        case 63: break;
        case 37:
          { addToken(Token.REGEX);
          }
        case 64: break;
        case 18:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_CHAR);
          }
        case 65: break;
        case 28:
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 66: break;
        case 21:
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_UNQUOTED); return firstToken;
          }
        case 67: break;
        case 6:
          { addToken(Token.WHITESPACE);
          }
        case 68: break;
        case 10:
          { start = zzMarkedPos-1; yybegin(CHAR_LITERAL);
          }
        case 69: break;
        case 3:
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 70: break;
        case 33:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addToken(temp,zzMarkedPos-1, Token.VARIABLE); start = zzMarkedPos;
          }
        case 71: break;
        case 20:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_BACKQUOTE);
          }
        case 72: break;
        case 15:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 73: break;
        case 16:
          { /* Skip escaped single quotes only, but this should still work. */
          }
        case 74: break;
        case 23:
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_UNQUOTED); return firstToken;
          }
        case 75: break;
        case 35:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.PREPROCESSOR); addToken(temp,zzMarkedPos-1, Token.VARIABLE); start = zzMarkedPos;
          }
        case 76: break;
        case 39:
          { addToken(Token.COMMENT_EOL); start = zzMarkedPos; yybegin(POD);
          }
        case 77: break;
        case 32:
          { addToken(Token.RESERVED_WORD);
          }
        case 78: break;
        case 19:
          { addToken(start,zzStartRead-1, Token.LITERAL_BACKQUOTE); return firstToken;
          }
        case 79: break;
        case 8:
          { addToken(Token.SEPARATOR);
          }
        case 80: break;
        case 5:
          { addNullToken(); return firstToken;
          }
        case 81: break;
        case 7:
          { addToken(Token.OPERATOR);
          }
        case 82: break;
        case 17:
          { addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
          }
        case 83: break;
        case 25:
          { addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_POD); return firstToken;
          }
        case 84: break;
        case 27:
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 85: break;
        case 43:
          { start = zzStartRead; yybegin(HEREDOC_EOT_UNQUOTED);
          }
        case 86: break;
        case 9:
          { start = zzMarkedPos-1; yybegin(BACKTICKS);
          }
        case 87: break;
        case 12:
          {
          }
        case 88: break;
        case 14:
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 89: break;
        case 22:
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_SINGLE_QUOTED); return firstToken;
          }
        case 90: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case HEREDOC_EOF_SINGLE_QUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_SINGLE_QUOTED); return firstToken;
            }
            case 602: break;
            case HEREDOC_EOT_SINGLE_QUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_SINGLE_QUOTED); return firstToken;
            }
            case 603: break;
            case HEREDOC_EOT_UNQUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_UNQUOTED); return firstToken;
            }
            case 604: break;
            case STRING: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 605: break;
            case BACKTICKS: {
              addToken(start,zzStartRead-1, Token.LITERAL_BACKQUOTE); return firstToken;
            }
            case 606: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 607: break;
            case HEREDOC_EOF_UNQUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_UNQUOTED); return firstToken;
            }
            case 608: break;
            case CHAR_LITERAL: {
              addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
            }
            case 609: break;
            case POD: {
              addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_POD); return firstToken;
            }
            case 610: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
