/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public final class MinElf {
    public static final int ELF_MAGIC = 1179403647;
    public static final int DT_NULL = 0;
    public static final int DT_NEEDED = 1;
    public static final int DT_STRTAB = 5;
    public static final int PT_LOAD = 1;
    public static final int PT_DYNAMIC = 2;
    public static final int PN_XNUM = 65535;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] extract_DT_NEEDED(File elfFile) throws IOException {
        try (FileInputStream is = new FileInputStream(elfFile);){
            String[] stringArray = MinElf.extract_DT_NEEDED(is.getChannel());
            return stringArray;
        }
    }

    public static String[] extract_DT_NEEDED(FileChannel fc) throws IOException {
        long d_tag;
        int e_phentsize;
        boolean is32;
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        if (MinElf.getu32(fc, bb, 0L) != 1179403647L) {
            throw new ElfError("file is not ELF");
        }
        boolean bl = is32 = MinElf.getu8(fc, bb, 4L) == 1;
        if (MinElf.getu8(fc, bb, 5L) == 2) {
            bb.order(ByteOrder.BIG_ENDIAN);
        }
        long e_phoff = is32 ? MinElf.getu32(fc, bb, 28L) : MinElf.get64(fc, bb, 32L);
        long e_phnum = is32 ? (long)MinElf.getu16(fc, bb, 44L) : (long)MinElf.getu16(fc, bb, 56L);
        int n = e_phentsize = is32 ? MinElf.getu16(fc, bb, 42L) : MinElf.getu16(fc, bb, 54L);
        if (e_phnum == 65535L) {
            long sh_info;
            long e_shoff = is32 ? MinElf.getu32(fc, bb, 32L) : MinElf.get64(fc, bb, 40L);
            e_phnum = sh_info = is32 ? MinElf.getu32(fc, bb, e_shoff + 28L) : MinElf.getu32(fc, bb, e_shoff + 44L);
        }
        long dynStart = 0L;
        long phdr = e_phoff;
        for (long i = 0L; i < e_phnum; ++i) {
            long p_type;
            long l = p_type = is32 ? MinElf.getu32(fc, bb, phdr + 0L) : MinElf.getu32(fc, bb, phdr + 0L);
            if (p_type == 2L) {
                long p_offset;
                dynStart = p_offset = is32 ? MinElf.getu32(fc, bb, phdr + 4L) : MinElf.get64(fc, bb, phdr + 8L);
                break;
            }
            phdr += (long)e_phentsize;
        }
        if (dynStart == 0L) {
            throw new ElfError("ELF file does not contain dynamic linking information");
        }
        int nr_DT_NEEDED = 0;
        long dyn = dynStart;
        long ptr_DT_STRTAB = 0L;
        do {
            long l = d_tag = is32 ? MinElf.getu32(fc, bb, dyn + 0L) : MinElf.get64(fc, bb, dyn + 0L);
            if (d_tag == 1L) {
                if (nr_DT_NEEDED == Integer.MAX_VALUE) {
                    throw new ElfError("malformed DT_NEEDED section");
                }
                ++nr_DT_NEEDED;
            } else if (d_tag == 5L) {
                ptr_DT_STRTAB = is32 ? MinElf.getu32(fc, bb, dyn + 4L) : MinElf.get64(fc, bb, dyn + 8L);
            }
            dyn += is32 ? 8L : 16L;
        } while (d_tag != 0L);
        if (ptr_DT_STRTAB == 0L) {
            throw new ElfError("Dynamic section string-table not found");
        }
        long off_DT_STRTAB = 0L;
        phdr = e_phoff;
        int i = 0;
        while ((long)i < e_phnum) {
            long p_type;
            long l = p_type = is32 ? MinElf.getu32(fc, bb, phdr + 0L) : MinElf.getu32(fc, bb, phdr + 0L);
            if (p_type == 1L) {
                long p_memsz;
                long p_vaddr = is32 ? MinElf.getu32(fc, bb, phdr + 8L) : MinElf.get64(fc, bb, phdr + 16L);
                long l2 = p_memsz = is32 ? MinElf.getu32(fc, bb, phdr + 20L) : MinElf.get64(fc, bb, phdr + 40L);
                if (p_vaddr <= ptr_DT_STRTAB && ptr_DT_STRTAB < p_vaddr + p_memsz) {
                    long p_offset = is32 ? MinElf.getu32(fc, bb, phdr + 4L) : MinElf.get64(fc, bb, phdr + 8L);
                    off_DT_STRTAB = p_offset + (ptr_DT_STRTAB - p_vaddr);
                    break;
                }
            }
            phdr += (long)e_phentsize;
            ++i;
        }
        if (off_DT_STRTAB == 0L) {
            throw new ElfError("did not find file offset of DT_STRTAB table");
        }
        String[] needed = new String[nr_DT_NEEDED];
        nr_DT_NEEDED = 0;
        dyn = dynStart;
        do {
            long l = d_tag = is32 ? MinElf.getu32(fc, bb, dyn + 0L) : MinElf.get64(fc, bb, dyn + 0L);
            if (d_tag == 1L) {
                long d_val = is32 ? MinElf.getu32(fc, bb, dyn + 4L) : MinElf.get64(fc, bb, dyn + 8L);
                needed[nr_DT_NEEDED] = MinElf.getSz(fc, bb, off_DT_STRTAB + d_val);
                if (nr_DT_NEEDED == Integer.MAX_VALUE) {
                    throw new ElfError("malformed DT_NEEDED section");
                }
                ++nr_DT_NEEDED;
            }
            dyn += is32 ? 8L : 16L;
        } while (d_tag != 0L);
        if (nr_DT_NEEDED != needed.length) {
            throw new ElfError("malformed DT_NEEDED section");
        }
        return needed;
    }

    private static String getSz(FileChannel fc, ByteBuffer bb, long offset) throws IOException {
        short b;
        StringBuilder sb = new StringBuilder();
        while ((b = MinElf.getu8(fc, bb, offset++)) != 0) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    private static void read(FileChannel fc, ByteBuffer bb, int sz, long offset) throws IOException {
        bb.position(0);
        bb.limit(sz);
        if (fc.read(bb, offset) != sz) {
            throw new ElfError("ELF file truncated");
        }
        bb.position(0);
    }

    private static long get64(FileChannel fc, ByteBuffer bb, long offset) throws IOException {
        MinElf.read(fc, bb, 8, offset);
        return bb.getLong();
    }

    private static long getu32(FileChannel fc, ByteBuffer bb, long offset) throws IOException {
        MinElf.read(fc, bb, 4, offset);
        return (long)bb.getInt() & 0xFFFFFFFFL;
    }

    private static int getu16(FileChannel fc, ByteBuffer bb, long offset) throws IOException {
        MinElf.read(fc, bb, 2, offset);
        return bb.getShort() & 0xFFFF;
    }

    private static short getu8(FileChannel fc, ByteBuffer bb, long offset) throws IOException {
        MinElf.read(fc, bb, 1, offset);
        return (short)(bb.get() & 0xFF);
    }

    private static class ElfError
    extends RuntimeException {
        ElfError(String why) {
            super(why);
        }
    }
}

