/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.facebook.csslayout.CSSConstants;
import com.facebook.csslayout.FloatUtil;
import com.facebook.csslayout.Spacing;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.views.view.ColorUtil;
import java.util.Locale;
import javax.annotation.Nullable;

class ReactViewBackgroundDrawable
extends Drawable {
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    @Nullable
    private Spacing mBorderWidth;
    @Nullable
    private Spacing mBorderColor;
    @Nullable
    private BorderStyle mBorderStyle;
    @Nullable
    private PathEffect mPathEffectForBorderStyle;
    @Nullable
    private Path mPathForBorderRadius;
    @Nullable
    private RectF mTempRectForBorderRadius;
    private boolean mNeedUpdatePathForBorderRadius = false;
    private float mBorderRadius = Float.NaN;
    private final Paint mPaint = new Paint(1);
    private int mColor = 0;
    private int mAlpha = 255;

    ReactViewBackgroundDrawable() {
    }

    public void draw(Canvas canvas) {
        if (!CSSConstants.isUndefined(this.mBorderRadius) && this.mBorderRadius > 0.0f) {
            this.drawRoundedBackgroundWithBorders(canvas);
        } else {
            this.drawRectangularBackgroundWithBorders(canvas);
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mNeedUpdatePathForBorderRadius = true;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return ColorUtil.getOpacityFromColor(ColorUtil.multiplyColorAlpha(this.mColor, this.mAlpha));
    }

    public void getOutline(Outline outline) {
        if (Build.VERSION.SDK_INT < 21) {
            super.getOutline(outline);
            return;
        }
        if (!CSSConstants.isUndefined(this.mBorderRadius) && this.mBorderRadius > 0.0f) {
            float extraRadiusFromBorderWidth = this.mBorderWidth != null ? this.mBorderWidth.get(8) / 2.0f : 0.0f;
            outline.setRoundRect(this.getBounds(), this.mBorderRadius + extraRadiusFromBorderWidth);
        } else {
            outline.setRect(this.getBounds());
        }
    }

    public void setBorderWidth(int position, float width) {
        if (this.mBorderWidth == null) {
            this.mBorderWidth = new Spacing();
        }
        if (!FloatUtil.floatsEqual(this.mBorderWidth.getRaw(position), width)) {
            this.mBorderWidth.set(position, width);
            if (position == 8) {
                this.mNeedUpdatePathForBorderRadius = true;
            }
            this.invalidateSelf();
        }
    }

    public void setBorderColor(int position, float color) {
        if (this.mBorderColor == null) {
            this.mBorderColor = new Spacing();
            this.mBorderColor.setDefault(0, -1.6777216E7f);
            this.mBorderColor.setDefault(1, -1.6777216E7f);
            this.mBorderColor.setDefault(2, -1.6777216E7f);
            this.mBorderColor.setDefault(3, -1.6777216E7f);
        }
        if (!FloatUtil.floatsEqual(this.mBorderColor.getRaw(position), color)) {
            this.mBorderColor.set(position, color);
            this.invalidateSelf();
        }
    }

    public void setBorderStyle(@Nullable String style2) {
        BorderStyle borderStyle;
        BorderStyle borderStyle2 = borderStyle = style2 == null ? null : BorderStyle.valueOf(style2.toUpperCase(Locale.US));
        if (this.mBorderStyle != borderStyle) {
            this.mBorderStyle = borderStyle;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setRadius(float radius) {
        if (this.mBorderRadius != radius) {
            this.mBorderRadius = radius;
            this.invalidateSelf();
        }
    }

    public void setColor(int color) {
        this.mColor = color;
        this.invalidateSelf();
    }

    @VisibleForTesting
    public int getColor() {
        return this.mColor;
    }

    private void drawRoundedBackgroundWithBorders(Canvas canvas) {
        float fullBorderWidth;
        this.updatePath();
        int useColor = ColorUtil.multiplyColorAlpha(this.mColor, this.mAlpha);
        if (useColor >>> 24 != 0) {
            this.mPaint.setColor(useColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawPath(this.mPathForBorderRadius, this.mPaint);
        }
        if ((fullBorderWidth = this.getFullBorderWidth()) > 0.0f) {
            int borderColor = this.getFullBorderColor();
            this.mPaint.setColor(ColorUtil.multiplyColorAlpha(borderColor, this.mAlpha));
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(fullBorderWidth);
            this.mPaint.setPathEffect(this.mPathEffectForBorderStyle);
            canvas.drawPath(this.mPathForBorderRadius, this.mPaint);
        }
    }

    private void updatePath() {
        if (!this.mNeedUpdatePathForBorderRadius) {
            return;
        }
        this.mNeedUpdatePathForBorderRadius = false;
        if (this.mPathForBorderRadius == null) {
            this.mPathForBorderRadius = new Path();
            this.mTempRectForBorderRadius = new RectF();
        }
        this.mPathForBorderRadius.reset();
        this.mTempRectForBorderRadius.set(this.getBounds());
        float fullBorderWidth = this.getFullBorderWidth();
        if (fullBorderWidth > 0.0f) {
            this.mTempRectForBorderRadius.inset(fullBorderWidth * 0.5f, fullBorderWidth * 0.5f);
        }
        this.mPathForBorderRadius.addRoundRect(this.mTempRectForBorderRadius, this.mBorderRadius, this.mBorderRadius, Path.Direction.CW);
        this.mPathEffectForBorderStyle = this.mBorderStyle != null ? this.mBorderStyle.getPathEffect(this.getFullBorderWidth()) : null;
    }

    private float getFullBorderWidth() {
        return this.mBorderWidth != null && !CSSConstants.isUndefined(this.mBorderWidth.getRaw(8)) ? this.mBorderWidth.getRaw(8) : 0.0f;
    }

    private int getFullBorderColor() {
        return this.mBorderColor != null && !CSSConstants.isUndefined(this.mBorderColor.getRaw(8)) ? (int)this.mBorderColor.getRaw(8) : -16777216;
    }

    private void drawRectangularBackgroundWithBorders(Canvas canvas) {
        int useColor = ColorUtil.multiplyColorAlpha(this.mColor, this.mAlpha);
        if (useColor >>> 24 != 0) {
            this.mPaint.setColor(useColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.getBounds(), this.mPaint);
        }
        if (this.getBorderWidth(0) > 0 || this.getBorderWidth(1) > 0 || this.getBorderWidth(2) > 0 || this.getBorderWidth(3) > 0) {
            int borderLeft = this.getBorderWidth(0);
            int borderTop = this.getBorderWidth(1);
            int borderRight = this.getBorderWidth(2);
            int borderBottom = this.getBorderWidth(3);
            int colorLeft = this.getBorderColor(0);
            int colorTop = this.getBorderColor(1);
            int colorRight = this.getBorderColor(2);
            int colorBottom = this.getBorderColor(3);
            int width = this.getBounds().width();
            int height = this.getBounds().height();
            if (borderLeft > 0 && colorLeft != 0) {
                this.mPaint.setColor(colorLeft);
                canvas.drawRect(0.0f, (float)borderTop, (float)borderLeft, (float)(height - borderBottom), this.mPaint);
            }
            if (borderTop > 0 && colorTop != 0) {
                this.mPaint.setColor(colorTop);
                canvas.drawRect(0.0f, 0.0f, (float)width, (float)borderTop, this.mPaint);
            }
            if (borderRight > 0 && colorRight != 0) {
                this.mPaint.setColor(colorRight);
                canvas.drawRect((float)(width - borderRight), (float)borderTop, (float)width, (float)(height - borderBottom), this.mPaint);
            }
            if (borderBottom > 0 && colorBottom != 0) {
                this.mPaint.setColor(colorBottom);
                canvas.drawRect(0.0f, (float)(height - borderBottom), (float)width, (float)height, this.mPaint);
            }
        }
    }

    private int getBorderWidth(int position) {
        return this.mBorderWidth != null ? Math.round(this.mBorderWidth.get(position)) : 0;
    }

    private int getBorderColor(int position) {
        return this.mBorderColor != null ? (int)this.mBorderColor.get(position) : -16777216;
    }

    private static enum BorderStyle {
        SOLID,
        DASHED,
        DOTTED;


        @Nullable
        public PathEffect getPathEffect(float borderWidth) {
            switch (this) {
                case SOLID: {
                    return null;
                }
                case DASHED: {
                    return new DashPathEffect(new float[]{borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f}, 0.0f);
                }
                case DOTTED: {
                    return new DashPathEffect(new float[]{borderWidth, borderWidth, borderWidth, borderWidth}, 0.0f);
                }
            }
            return null;
        }
    }
}

