/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.os.Build;
import android.view.View;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.AccessibilityHelper;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIProp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BaseViewPropertyApplicator {
    private static final String PROP_DECOMPOSED_MATRIX = "decomposedMatrix";
    private static final String PROP_DECOMPOSED_MATRIX_ROTATE = "rotate";
    private static final String PROP_DECOMPOSED_MATRIX_SCALE_X = "scaleX";
    private static final String PROP_DECOMPOSED_MATRIX_SCALE_Y = "scaleY";
    private static final String PROP_DECOMPOSED_MATRIX_TRANSLATE_X = "translateX";
    private static final String PROP_DECOMPOSED_MATRIX_TRANSLATE_Y = "translateY";
    private static final String PROP_OPACITY = "opacity";
    private static final String PROP_RENDER_TO_HARDWARE_TEXTURE = "renderToHardwareTextureAndroid";
    private static final String PROP_ACCESSIBILITY_LABEL = "accessibilityLabel";
    private static final String PROP_ACCESSIBILITY_COMPONENT_TYPE = "accessibilityComponentType";
    private static final String PROP_ACCESSIBILITY_LIVE_REGION = "accessibilityLiveRegion";
    private static final String PROP_IMPORTANT_FOR_ACCESSIBILITY = "importantForAccessibility";
    private static final String PROP_ROTATION = "rotation";
    private static final String PROP_SCALE_X = "scaleX";
    private static final String PROP_SCALE_Y = "scaleY";
    private static final String PROP_TRANSLATE_X = "translateX";
    private static final String PROP_TRANSLATE_Y = "translateY";
    public static final String PROP_TEST_ID = "testID";
    private static final Map<String, UIProp.Type> mCommonProps;

    public static Map<String, UIProp.Type> getCommonProps() {
        return mCommonProps;
    }

    public static void applyCommonViewProperties(View view, CatalystStylesDiffMap props) {
        if (props.hasKey("backgroundColor")) {
            int backgroundColor = props.getInt("backgroundColor", 0);
            view.setBackgroundColor(backgroundColor);
        }
        if (props.hasKey(PROP_DECOMPOSED_MATRIX)) {
            ReadableMap decomposedMatrix = props.getMap(PROP_DECOMPOSED_MATRIX);
            if (decomposedMatrix == null) {
                BaseViewPropertyApplicator.resetTransformMatrix(view);
            } else {
                BaseViewPropertyApplicator.setTransformMatrix(view, decomposedMatrix);
            }
        }
        if (props.hasKey(PROP_OPACITY)) {
            view.setAlpha(props.getFloat(PROP_OPACITY, 1.0f));
        }
        if (props.hasKey(PROP_RENDER_TO_HARDWARE_TEXTURE)) {
            boolean useHWTexture = props.getBoolean(PROP_RENDER_TO_HARDWARE_TEXTURE, false);
            view.setLayerType(useHWTexture ? 2 : 0, null);
        }
        if (props.hasKey(PROP_TEST_ID)) {
            view.setTag((Object)props.getString(PROP_TEST_ID));
        }
        if (props.hasKey(PROP_ACCESSIBILITY_LABEL)) {
            view.setContentDescription((CharSequence)props.getString(PROP_ACCESSIBILITY_LABEL));
        }
        if (props.hasKey(PROP_ACCESSIBILITY_COMPONENT_TYPE)) {
            AccessibilityHelper.updateAccessibilityComponentType(view, props.getString(PROP_ACCESSIBILITY_COMPONENT_TYPE));
        }
        if (props.hasKey(PROP_ACCESSIBILITY_LIVE_REGION) && Build.VERSION.SDK_INT >= 19) {
            String liveRegionString = props.getString(PROP_ACCESSIBILITY_LIVE_REGION);
            if (liveRegionString == null || liveRegionString.equals("none")) {
                view.setAccessibilityLiveRegion(0);
            } else if (liveRegionString.equals("polite")) {
                view.setAccessibilityLiveRegion(1);
            } else if (liveRegionString.equals("assertive")) {
                view.setAccessibilityLiveRegion(2);
            }
        }
        if (props.hasKey(PROP_IMPORTANT_FOR_ACCESSIBILITY)) {
            String importantForAccessibility = props.getString(PROP_IMPORTANT_FOR_ACCESSIBILITY);
            if (importantForAccessibility == null || importantForAccessibility.equals("auto")) {
                view.setImportantForAccessibility(0);
            } else if (importantForAccessibility.equals("yes")) {
                view.setImportantForAccessibility(1);
            } else if (importantForAccessibility.equals("no")) {
                view.setImportantForAccessibility(2);
            } else if (importantForAccessibility.equals("no-hide-descendants")) {
                view.setImportantForAccessibility(4);
            }
        }
        if (props.hasKey(PROP_ROTATION)) {
            view.setRotation(props.getFloat(PROP_ROTATION, 0.0f));
        }
        if (props.hasKey("scaleX")) {
            view.setScaleX(props.getFloat("scaleX", 1.0f));
        }
        if (props.hasKey("scaleY")) {
            view.setScaleY(props.getFloat("scaleY", 1.0f));
        }
        if (props.hasKey("translateX")) {
            view.setTranslationX(PixelUtil.toPixelFromDIP(props.getFloat("translateX", 0.0f)));
        }
        if (props.hasKey("translateY")) {
            view.setTranslationY(PixelUtil.toPixelFromDIP(props.getFloat("translateY", 0.0f)));
        }
    }

    private static void setTransformMatrix(View view, ReadableMap matrix) {
        view.setTranslationX(PixelUtil.toPixelFromDIP((float)matrix.getDouble("translateX")));
        view.setTranslationY(PixelUtil.toPixelFromDIP((float)matrix.getDouble("translateY")));
        view.setRotation((float)matrix.getDouble(PROP_DECOMPOSED_MATRIX_ROTATE));
        view.setScaleX((float)matrix.getDouble("scaleX"));
        view.setScaleY((float)matrix.getDouble("scaleY"));
    }

    private static void resetTransformMatrix(View view) {
        view.setTranslationX(PixelUtil.toPixelFromDIP(0.0f));
        view.setTranslationY(PixelUtil.toPixelFromDIP(0.0f));
        view.setRotation(0.0f);
        view.setScaleX(1.0f);
        view.setScaleY(1.0f);
    }

    static {
        HashMap<String, UIProp.Type> props = new HashMap<String, UIProp.Type>();
        props.put(PROP_ACCESSIBILITY_LABEL, UIProp.Type.STRING);
        props.put(PROP_ACCESSIBILITY_COMPONENT_TYPE, UIProp.Type.STRING);
        props.put(PROP_ACCESSIBILITY_LIVE_REGION, UIProp.Type.STRING);
        props.put("backgroundColor", UIProp.Type.STRING);
        props.put(PROP_IMPORTANT_FOR_ACCESSIBILITY, UIProp.Type.STRING);
        props.put(PROP_OPACITY, UIProp.Type.NUMBER);
        props.put(PROP_ROTATION, UIProp.Type.NUMBER);
        props.put("scaleX", UIProp.Type.NUMBER);
        props.put("scaleY", UIProp.Type.NUMBER);
        props.put("translateX", UIProp.Type.NUMBER);
        props.put("translateY", UIProp.Type.NUMBER);
        props.put(PROP_TEST_ID, UIProp.Type.STRING);
        props.put(PROP_RENDER_TO_HARDWARE_TEXTURE, UIProp.Type.BOOLEAN);
        mCommonProps = Collections.unmodifiableMap(props);
    }
}

