/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import javax.annotation.Nullable;

public class CatalystQueueConfigurationSpec {
    private final MessageQueueThreadSpec mNativeModulesQueueThreadSpec;
    private final MessageQueueThreadSpec mJSQueueThreadSpec;

    private CatalystQueueConfigurationSpec(MessageQueueThreadSpec nativeModulesQueueThreadSpec, MessageQueueThreadSpec jsQueueThreadSpec) {
        this.mNativeModulesQueueThreadSpec = nativeModulesQueueThreadSpec;
        this.mJSQueueThreadSpec = jsQueueThreadSpec;
    }

    public MessageQueueThreadSpec getNativeModulesQueueThreadSpec() {
        return this.mNativeModulesQueueThreadSpec;
    }

    public MessageQueueThreadSpec getJSQueueThreadSpec() {
        return this.mJSQueueThreadSpec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CatalystQueueConfigurationSpec createDefault() {
        return CatalystQueueConfigurationSpec.builder().setJSQueueThreadSpec(MessageQueueThreadSpec.newBackgroundThreadSpec("js")).setNativeModulesQueueThreadSpec(MessageQueueThreadSpec.newBackgroundThreadSpec("native_modules")).build();
    }

    public static class Builder {
        @Nullable
        private MessageQueueThreadSpec mNativeModulesQueueSpec;
        @Nullable
        private MessageQueueThreadSpec mJSQueueSpec;

        public Builder setNativeModulesQueueThreadSpec(MessageQueueThreadSpec spec) {
            Assertions.assertCondition((this.mNativeModulesQueueSpec == null ? 1 : 0) != 0, (String)"Setting native modules queue spec multiple times!");
            this.mNativeModulesQueueSpec = spec;
            return this;
        }

        public Builder setJSQueueThreadSpec(MessageQueueThreadSpec spec) {
            Assertions.assertCondition((this.mJSQueueSpec == null ? 1 : 0) != 0, (String)"Setting JS queue multiple times!");
            this.mJSQueueSpec = spec;
            return this;
        }

        public CatalystQueueConfigurationSpec build() {
            return new CatalystQueueConfigurationSpec((MessageQueueThreadSpec)Assertions.assertNotNull((Object)this.mNativeModulesQueueSpec), (MessageQueueThreadSpec)Assertions.assertNotNull((Object)this.mJSQueueSpec));
        }
    }
}

