/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonGeneratorHelper {
    public static void writeObjectField(JsonGenerator jg, String name, Object object) throws IOException {
        if (object instanceof Map) {
            JsonGeneratorHelper.writeMap(jg, name, (Map)object);
        } else if (object instanceof List) {
            JsonGeneratorHelper.writeList(jg, name, (List)object);
        } else {
            jg.writeObjectField(name, object);
        }
    }

    private static void writeMap(JsonGenerator jg, String name, Map map) throws IOException {
        jg.writeObjectFieldStart(name);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            JsonGeneratorHelper.writeObjectField(jg, entry.getKey().toString(), entry.getValue());
        }
        jg.writeEndObject();
    }

    private static void writeList(JsonGenerator jg, String name, List list) throws IOException {
        jg.writeArrayFieldStart(name);
        for (Object item : list) {
            jg.writeObject(item);
        }
        jg.writeEndArray();
    }
}

