/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.LifecycleState;
import com.facebook.react.ReactInstanceManagerImpl;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.ViewManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class ReactInstanceManager {
    public abstract DevSupportManager getDevSupportManager();

    public abstract void createReactContextInBackground();

    public abstract boolean hasStartedCreatingInitialContext();

    public abstract void onBackPressed();

    public abstract void onPause();

    public abstract void onResume(Activity var1, DefaultHardwareBackBtnHandler var2);

    public abstract void onDestroy();

    public abstract void onActivityResult(int var1, int var2, Intent var3);

    public abstract void showDevOptionsDialog();

    public abstract String getSourceUrl();

    public abstract void attachMeasuredRootView(ReactRootView var1);

    public abstract void detachRootView(ReactRootView var1);

    public abstract List<ViewManager> createAllViewManagers(ReactApplicationContext var1);

    public abstract void addReactInstanceEventListener(ReactInstanceEventListener var1);

    @Nullable
    @VisibleForTesting
    public abstract ReactContext getCurrentReactContext();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected final List<ReactPackage> mPackages = new ArrayList<ReactPackage>();
        @Nullable
        protected String mJSBundleFile;
        @Nullable
        protected String mJSMainModuleName;
        @Nullable
        protected NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
        @Nullable
        protected Application mApplication;
        protected boolean mUseDeveloperSupport;
        @Nullable
        protected LifecycleState mInitialLifecycleState;
        @Nullable
        protected UIImplementationProvider mUIImplementationProvider;
        @Nullable
        protected NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;

        protected Builder() {
        }

        public Builder setUIImplementationProvider(@Nullable UIImplementationProvider uiImplementationProvider) {
            this.mUIImplementationProvider = uiImplementationProvider;
            return this;
        }

        public Builder setBundleAssetName(String bundleAssetName) {
            return this.setJSBundleFile(bundleAssetName == null ? null : "assets://" + bundleAssetName);
        }

        public Builder setJSBundleFile(String jsBundleFile) {
            this.mJSBundleFile = jsBundleFile;
            return this;
        }

        public Builder setJSMainModuleName(String jsMainModuleName) {
            this.mJSMainModuleName = jsMainModuleName;
            return this;
        }

        public Builder addPackage(ReactPackage reactPackage) {
            this.mPackages.add(reactPackage);
            return this;
        }

        public Builder setBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener) {
            this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
            return this;
        }

        public Builder setApplication(Application application) {
            this.mApplication = application;
            return this;
        }

        public Builder setUseDeveloperSupport(boolean useDeveloperSupport) {
            this.mUseDeveloperSupport = useDeveloperSupport;
            return this;
        }

        public Builder setInitialLifecycleState(LifecycleState initialLifecycleState) {
            this.mInitialLifecycleState = initialLifecycleState;
            return this;
        }

        public Builder setNativeModuleCallExceptionHandler(NativeModuleCallExceptionHandler handler) {
            this.mNativeModuleCallExceptionHandler = handler;
            return this;
        }

        public ReactInstanceManager build() {
            Assertions.assertCondition((this.mUseDeveloperSupport || this.mJSBundleFile != null ? 1 : 0) != 0, (String)"JS Bundle File has to be provided when dev support is disabled");
            Assertions.assertCondition((this.mJSMainModuleName != null || this.mJSBundleFile != null ? 1 : 0) != 0, (String)"Either MainModuleName or JS Bundle File needs to be provided");
            if (this.mUIImplementationProvider == null) {
                this.mUIImplementationProvider = new UIImplementationProvider();
            }
            return new ReactInstanceManagerImpl((Context)Assertions.assertNotNull((Object)this.mApplication, (String)"Application property has not been set with this builder"), this.mJSBundleFile, this.mJSMainModuleName, this.mPackages, this.mUseDeveloperSupport, this.mBridgeIdleDebugListener, (LifecycleState)((Object)Assertions.assertNotNull((Object)((Object)this.mInitialLifecycleState), (String)"Initial lifecycle state was not set")), this.mUIImplementationProvider, this.mNativeModuleCallExceptionHandler);
        }
    }

    public static interface ReactInstanceEventListener {
        public void onReactContextInitialized(ReactContext var1);
    }
}

